/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.domain;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.ow2.jonas.deployment.common.AbsDeploymentDesc;
import org.ow2.jonas.deployment.domain.xml.Cluster;
import org.ow2.jonas.deployment.domain.xml.ClusterDaemon;
import org.ow2.jonas.deployment.domain.xml.Domain;
import org.ow2.jonas.deployment.domain.xml.Server;

public class DomainMap
extends AbsDeploymentDesc {
    private String name = null;
    private String description = null;
    private String username = null;
    private String password = null;
    private Vector clusterDaemons = null;
    private Vector clusters = null;
    private Vector servers = null;

    public Vector getClusterDaemons() {
        return this.clusterDaemons;
    }

    public void setClusterDaemons(Vector clusterDaemons) {
        this.clusterDaemons = clusterDaemons;
    }

    public Vector getClusters() {
        return this.clusters;
    }

    public void setClusters(Vector clusters) {
        this.clusters = clusters;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Vector getServers() {
        return this.servers;
    }

    public void setServers(Vector servers) {
        this.servers = servers;
    }

    public DomainMap(Domain domain) {
        this.name = domain.getName();
        this.description = domain.getDescription();
        this.username = domain.getUsername();
        this.password = domain.getPassword();
        this.clusterDaemons = new Vector();
        this.clusters = new Vector();
        this.servers = new Vector();
        Iterator i = domain.getClusterDaemonList().iterator();
        while (i.hasNext()) {
            ClusterDaemon clusterDaemon = (ClusterDaemon)i.next();
            this.clusterDaemons.add(clusterDaemon);
        }
        i = domain.getClusterList().iterator();
        while (i.hasNext()) {
            Cluster cluster = (Cluster)i.next();
            this.clusters.add(cluster);
        }
        i = domain.getServerList().iterator();
        while (i.hasNext()) {
            Server server = (Server)i.next();
            this.servers.add(server);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nname=" + this.name);
        ret.append("\ndescription=" + this.description);
        ret.append("\nclusterDaemons=");
        Enumeration e = this.clusterDaemons.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        ret.append("\nservers=");
        e = this.servers.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        ret.append("\nclusters=");
        e = this.clusters.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        return ret.toString();
    }
}

