/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import org.ow2.jonas.deployment.web.MethodsDesc;
import org.ow2.jonas.deployment.web.Pattern;

public class PatternEntry {
    private Pattern pattern = null;
    private boolean uncheckedLastEntry = false;
    private MethodsDesc methods = null;
    private boolean irrelevant = false;
    private StringBuffer qualified = null;

    public PatternEntry(String pattern) {
        this.pattern = new Pattern(pattern);
        this.methods = new MethodsDesc();
        this.qualified = new StringBuffer(pattern);
    }

    public void addMethods(String[] methods, String transportGuarantee, boolean isExcluded) {
        this.methods.addMethods(methods, transportGuarantee, isExcluded);
    }

    public void addExcludedMethods(String[] methods, String transportGuarantee) {
        this.addMethods(methods, transportGuarantee, true);
    }

    public void addUncheckedMethods(String[] methods, String transportGuarantee) {
        this.addMethods(methods, transportGuarantee, false);
    }

    public void addMethodsOnRoles(String[] methods, String[] roles, String transportGuarantee) {
        for (int r = 0; r < roles.length; ++r) {
            this.addMethodsOnRole(methods, roles[r], transportGuarantee);
        }
    }

    public void addMethodsOnRole(String[] methods, String role, String transportGuarantee) {
        this.methods.addMethodsOnRole(methods, role, transportGuarantee);
    }

    public void setUncheckedLastEntry() {
        this.uncheckedLastEntry = true;
    }

    public boolean isUncheckedLastEntry() {
        return this.uncheckedLastEntry;
    }

    public void addQualifiedPattern(Pattern otherPattern) {
        if (otherPattern.isMatching(this.pattern)) {
            this.irrelevant = true;
        } else {
            this.qualified.append(":");
            this.qualified.append(otherPattern);
        }
    }

    public Map getRolesPermissionsMap() {
        Map roleMapActions = this.methods.getRoleMapActions();
        String roleName = null;
        String actions = null;
        HashMap rolesPermissionsMap = new HashMap();
        Iterator it = roleMapActions.keySet().iterator();
        while (it.hasNext()) {
            roleName = (String)it.next();
            actions = (String)roleMapActions.get(roleName);
            if (actions == null) continue;
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new WebResourcePermission(this.getQualifiedPattern(), actions));
            rolesPermissionsMap.put(roleName, pc);
        }
        return rolesPermissionsMap;
    }

    public PermissionCollection getExcludedPermissions() {
        Permissions pc = new Permissions();
        String actions = this.methods.getExcludedActions();
        if (!actions.equals("")) {
            ((PermissionCollection)pc).add(new WebResourcePermission(this.getQualifiedPattern(), actions));
            ((PermissionCollection)pc).add(new WebUserDataPermission(this.getQualifiedPattern(), actions));
        }
        return pc;
    }

    public PermissionCollection getUncheckedPermissions() {
        String actions = null;
        ArrayList permissions = new ArrayList();
        actions = this.methods.getUncheckedActions();
        if (actions == null || !actions.equals("")) {
            permissions.add(new WebResourcePermission(this.getQualifiedPattern(), actions));
            permissions.add(new WebUserDataPermission(this.getQualifiedPattern(), actions));
        }
        List actionsList = this.methods.getUncheckedWebUserDataActionsRoleList();
        Iterator it = actionsList.iterator();
        while (it.hasNext()) {
            actions = (String)it.next();
            permissions.add(new WebUserDataPermission(this.getQualifiedPattern(), actions));
        }
        Permissions pc = new Permissions();
        Iterator it2 = permissions.iterator();
        while (it2.hasNext()) {
            Permission p = (Permission)it2.next();
            if (p instanceof WebUserDataPermission) {
                WebUserDataPermission wdp = (WebUserDataPermission)p;
                String wdpName = wdp.getName();
                String wdpActions = wdp.getActions();
                if (wdpActions == null) {
                    ((PermissionCollection)pc).add(p);
                    continue;
                }
                boolean wasMerged = false;
                Iterator itLoop = permissions.iterator();
                while (itLoop.hasNext()) {
                    boolean loopNoWTransport;
                    WebUserDataPermission loopWdp;
                    Permission loopPerm = (Permission)itLoop.next();
                    if (!(loopPerm instanceof WebUserDataPermission) || (loopWdp = (WebUserDataPermission)loopPerm).equals(wdp)) continue;
                    String loopWdpName = loopWdp.getName();
                    String loopWdpActions = loopWdp.getActions();
                    if (loopWdpActions == null) continue;
                    boolean wNoTransport = wdpActions.indexOf(":") == -1;
                    boolean bl = loopNoWTransport = loopWdpActions.indexOf(":") == -1;
                    if (!wdpName.equals(loopWdpName) || !wNoTransport || !loopNoWTransport) continue;
                    String newActions = wdpActions + "," + loopWdpActions;
                    Enumeration existingPermissions = ((PermissionCollection)pc).elements();
                    boolean exist = false;
                    WebUserDataPermission permissionToAdd = new WebUserDataPermission(wdpName, newActions);
                    while (existingPermissions.hasMoreElements()) {
                        Permission perm = (Permission)existingPermissions.nextElement();
                        if (!perm.equals(permissionToAdd)) continue;
                        exist = true;
                    }
                    if (exist) continue;
                    wasMerged = true;
                    ((PermissionCollection)pc).add(permissionToAdd);
                }
                if (wasMerged) continue;
                ((PermissionCollection)pc).add(p);
                continue;
            }
            ((PermissionCollection)pc).add(p);
        }
        return pc;
    }

    public boolean isIrrelevant() {
        return this.irrelevant;
    }

    public String getQualifiedPattern() {
        return this.qualified.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PatternEntry[pattern=");
        sb.append(this.pattern);
        sb.append(";qualified=");
        sb.append(this.getQualifiedPattern());
        sb.append(";irrelevant=");
        sb.append(this.irrelevant);
        sb.append("]");
        return sb.toString();
    }
}

