/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.web.MethodsDesc;
import org.ow2.jonas.deployment.web.Pattern;
import org.ow2.jonas.deployment.web.PatternEntry;
import org.ow2.jonas.deployment.web.xml.AuthConstraint;
import org.ow2.jonas.deployment.web.xml.SecurityConstraint;
import org.ow2.jonas.deployment.web.xml.UserDataConstraint;
import org.ow2.jonas.deployment.web.xml.WebApp;
import org.ow2.jonas.deployment.web.xml.WebResourceCollection;
import org.ow2.jonas.lib.util.Log;

public class SecurityConstraintListDesc {
    private static final String DEFAULT_PATTERN = "/";
    private WebApp webApp = null;
    private Map mapPatterns = null;
    private PermissionCollection excludedPermissions = null;
    private PermissionCollection uncheckedPermissions = null;
    private Map permissionsByRole = null;
    private static Logger logger = Log.getLogger("org.ow2.jonas.security.jacc");

    public SecurityConstraintListDesc(WebApp webApp) {
        this.webApp = webApp;
        this.mapPatterns = new HashMap();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.permissionsByRole = new HashMap();
        try {
            this.initConstraints();
            this.qualifyPatterns();
            this.buildPermissions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initConstraints() {
        String[] securityRoles = new String[this.webApp.getSecurityRoleList().size()];
        int r = 0;
        Iterator itSecurityRoles = this.webApp.getSecurityRoleList().iterator();
        while (itSecurityRoles.hasNext()) {
            securityRoles[r] = ((SecurityRole)itSecurityRoles.next()).getRoleName();
            ++r;
        }
        SecurityConstraint securityConstraint = null;
        Iterator it = this.webApp.getSecurityConstraintList().iterator();
        while (it.hasNext()) {
            securityConstraint = (SecurityConstraint)it.next();
            JLinkedList webResourceCollectionList = securityConstraint.getWebResourceCollectionList();
            AuthConstraint authConstraint = securityConstraint.getAuthConstraint();
            UserDataConstraint userDataConstraint = securityConstraint.getUserDataConstraint();
            JLinkedList rolesList = null;
            boolean hasAuthConstraint = false;
            boolean isExcludingAuthConstraint = false;
            if (authConstraint != null) {
                rolesList = authConstraint.getRoleNameList();
                hasAuthConstraint = true;
                isExcludingAuthConstraint = rolesList.size() == 0;
            }
            String transportGuarantee = null;
            if (userDataConstraint != null) {
                transportGuarantee = userDataConstraint.getTransportGuarantee();
            }
            WebResourceCollection webRC = null;
            Iterator itWebRC = webResourceCollectionList.iterator();
            while (itWebRC.hasNext()) {
                webRC = (WebResourceCollection)itWebRC.next();
                JLinkedList methodList = webRC.getHttpMethodList();
                String urlPatternString = null;
                Iterator itPattern = webRC.getUrlPatternList().iterator();
                while (itPattern.hasNext()) {
                    urlPatternString = (String)itPattern.next();
                    PatternEntry patternEntry = (PatternEntry)this.mapPatterns.get(urlPatternString);
                    if (patternEntry == null) {
                        patternEntry = new PatternEntry(urlPatternString);
                        this.mapPatterns.put(urlPatternString, patternEntry);
                    }
                    String[] methods = null;
                    methods = methodList.isEmpty() ? MethodsDesc.METHODS : (String[])methodList.toArray(new String[methodList.size()]);
                    if (hasAuthConstraint) {
                        if (isExcludingAuthConstraint) {
                            patternEntry.addExcludedMethods(methods, transportGuarantee);
                            continue;
                        }
                        Iterator itRole = rolesList.iterator();
                        while (itRole.hasNext()) {
                            String roleName = (String)itRole.next();
                            if (roleName.equals("*")) {
                                patternEntry.addMethodsOnRoles(methods, securityRoles, transportGuarantee);
                                continue;
                            }
                            patternEntry.addMethodsOnRole(methods, roleName, transportGuarantee);
                        }
                        continue;
                    }
                    patternEntry.addUncheckedMethods(methods, transportGuarantee);
                }
            }
        }
    }

    private synchronized void qualifyPatterns() {
        PatternEntry defaultPatternEntry = (PatternEntry)this.mapPatterns.get(DEFAULT_PATTERN);
        if (defaultPatternEntry == null) {
            defaultPatternEntry = new PatternEntry(DEFAULT_PATTERN);
            defaultPatternEntry.setUncheckedLastEntry();
            this.mapPatterns.put(DEFAULT_PATTERN, defaultPatternEntry);
        }
        PatternEntry patternEntry = null;
        Pattern otherPattern = null;
        String patternString = null;
        ArrayList patterns = new ArrayList();
        Iterator it = this.mapPatterns.keySet().iterator();
        while (it.hasNext()) {
            patternString = (String)it.next();
            patterns.add(new Pattern(patternString));
        }
        Collections.sort(patterns);
        Pattern pattern = null;
        Iterator it2 = this.mapPatterns.keySet().iterator();
        while (it2.hasNext()) {
            patternString = (String)it2.next();
            pattern = new Pattern(patternString);
            patternEntry = (PatternEntry)this.mapPatterns.get(patternString);
            Iterator itOther = patterns.iterator();
            while (itOther.hasNext()) {
                otherPattern = (Pattern)itOther.next();
                if (pattern.isPathPrefix() && pattern.isMatching(otherPattern)) {
                    if (otherPattern.isPathPrefix() && !pattern.equals(otherPattern)) {
                        patternEntry.addQualifiedPattern(otherPattern);
                        continue;
                    }
                    if (!otherPattern.isExactPattern()) continue;
                    patternEntry.addQualifiedPattern(otherPattern);
                    continue;
                }
                if (pattern.isExtensionPattern()) {
                    if (!otherPattern.isPathPrefix() && (!pattern.isMatching(otherPattern) || !otherPattern.isExactPattern())) continue;
                    patternEntry.addQualifiedPattern(otherPattern);
                    continue;
                }
                if (!pattern.isDefaultPattern() || otherPattern.isDefaultPattern()) continue;
                patternEntry.addQualifiedPattern(otherPattern);
            }
        }
    }

    private void buildPermissions() {
        PatternEntry patternEntry = null;
        Iterator it = this.mapPatterns.values().iterator();
        while (it.hasNext()) {
            patternEntry = (PatternEntry)it.next();
            if (patternEntry.isIrrelevant()) continue;
            if (patternEntry.isUncheckedLastEntry()) {
                this.addUncheckedPermissions(patternEntry.getUncheckedPermissions());
                continue;
            }
            this.addExcludedPermissions(patternEntry.getExcludedPermissions());
            this.addUncheckedPermissions(patternEntry.getUncheckedPermissions());
            this.addRolePermissions(patternEntry.getRolesPermissionsMap());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Excluded permissions = " + this.excludedPermissions));
            logger.log(BasicLevel.DEBUG, (Object)("Unchecked permissions = " + this.uncheckedPermissions));
            logger.log(BasicLevel.DEBUG, (Object)"Roles Permissions = ");
            String roleName = null;
            Iterator it2 = this.permissionsByRole.keySet().iterator();
            while (it2.hasNext()) {
                roleName = (String)it2.next();
                logger.log(BasicLevel.DEBUG, (Object)("Permissions for role " + roleName + " are " + this.permissionsByRole.get(roleName)));
            }
        }
    }

    private void addExcludedPermissions(PermissionCollection permissions) {
        if (permissions == null) {
            return;
        }
        Enumeration e = permissions.elements();
        while (e.hasMoreElements()) {
            this.excludedPermissions.add((Permission)e.nextElement());
        }
    }

    private void addUncheckedPermissions(PermissionCollection permissions) {
        if (permissions == null) {
            return;
        }
        Enumeration e = permissions.elements();
        while (e.hasMoreElements()) {
            this.uncheckedPermissions.add((Permission)e.nextElement());
        }
    }

    private void addRolePermissions(Map rolePermissionsMap) {
        if (rolePermissionsMap == null) {
            return;
        }
        String roleName = null;
        PermissionCollection permissions = null;
        PermissionCollection existingRolePermissions = null;
        Iterator it = rolePermissionsMap.keySet().iterator();
        while (it.hasNext()) {
            roleName = (String)it.next();
            permissions = (PermissionCollection)rolePermissionsMap.get(roleName);
            if (permissions == null) continue;
            existingRolePermissions = (PermissionCollection)this.permissionsByRole.get(roleName);
            if (existingRolePermissions == null) {
                existingRolePermissions = new Permissions();
                this.permissionsByRole.put(roleName, existingRolePermissions);
            }
            Enumeration e = permissions.elements();
            while (e.hasMoreElements()) {
                existingRolePermissions.add((Permission)e.nextElement());
            }
        }
    }

    public PermissionCollection getExcludedPermissions() {
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.uncheckedPermissions;
    }

    public Map getPermissionsByRole() {
        return this.permissionsByRole;
    }
}

