/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class Bootstrap {
    private static final String REQUIRED_JVM_VERSION = "1.5";

    private Bootstrap() {
    }

    public static void main(String[] args) {
        String classToRun = args[0];
        String specVersion = System.getProperty("java.specification.version");
        if (specVersion.compareTo(REQUIRED_JVM_VERSION) < 0) {
            String implVersion = System.getProperty("java.vm.version");
            System.err.println("A '1.5' JVM version or higher is required for JOnAS. Current JVM implementation version is '" + implVersion + "' with specification '" + specVersion + "'");
            System.exit(0);
        }
        try {
            LoaderManager lm = LoaderManager.getInstance();
            JClassLoader jonasLoader = null;
            jonasLoader = lm.getExternalLoader();
            Thread.currentThread().setContextClassLoader(jonasLoader);
            Class clazz = jonasLoader.loadClass(classToRun);
            Class[] argList = new Class[]{args.getClass()};
            Method meth = clazz.getMethod("main", argList);
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            meth.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String message = t.getMessage();
            if (t instanceof Error) {
                System.err.println("Error during execution of " + classToRun + " : " + message);
            } else if (t instanceof Exception) {
                System.err.println("Exception during execution of " + classToRun + " : " + message);
            }
            t.printStackTrace(System.err);
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println(classToRun + " reflection error : " + e);
            e.printStackTrace();
            System.exit(2);
        }
    }
}

