/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.ow2.jonas.lib.bootstrap.JFileFilter;

public class JURLs
extends Vector {
    public void add(File file) throws MalformedURLException {
        this.add(file, null, null, null);
    }

    public void addDir(File file) throws MalformedURLException {
        if (!file.exists() || !file.isDirectory()) {
            String err = "Warning: Resource " + file.getName();
            err = err + " cannot be loaded : The directory does not exist";
            System.out.println(err);
        } else if (!this.contains(file.toURL())) {
            this.add(file.toURL());
        }
    }

    public void add(File file, String filter) throws MalformedURLException {
        if (file.isDirectory()) {
            this.add(file, filter, null, null);
        } else {
            String err = "Warning: Resource " + file.getName();
            err = err + " cannot be loaded : It is not a directory";
            System.out.println(err);
        }
    }

    public void addNotStartWith(File file, String prefix) throws MalformedURLException {
        if (file.isDirectory()) {
            this.add(file, null, prefix, null);
        } else {
            String err = "Warning: Resource " + file.getName();
            err = err + " cannot be loaded : It is not a directory";
            System.out.println(err);
        }
    }

    public void addNotEndWith(File file, String suffix) throws MalformedURLException {
        if (file.isDirectory()) {
            this.add(file, null, null, suffix);
        } else {
            String err = "Warning: Resource " + file.getName();
            err = err + " cannot be loaded : It is not a directory";
            System.out.println(err);
        }
    }

    public void add(File file, String filter, String prefix, String suffix) throws MalformedURLException {
        if (!file.exists()) {
            String err = "Warning: Resource " + file.getPath();
            err = err + " cannot be loaded : The file or directory does not exist";
            err = err + "(Check your environment variable)";
            System.out.println(err);
        } else if (file.isFile()) {
            if (!this.isMatching(file, prefix, suffix) && !this.contains(file.toURL())) {
                this.add(file.toURL());
            }
        } else {
            File[] childrenFiles = null;
            childrenFiles = filter != null ? file.listFiles(new JFileFilter(filter)) : file.listFiles();
            for (int i = 0; i < childrenFiles.length; ++i) {
                this.add(childrenFiles[i], filter, prefix, suffix);
            }
        }
    }

    private boolean isMatching(File file, String prefix, String suffix) {
        String fileName = file.getName();
        if (prefix == null) {
            if (suffix == null) {
                return false;
            }
            return fileName.endsWith(suffix);
        }
        if (suffix == null) {
            return fileName.startsWith(prefix);
        }
        return fileName.startsWith(prefix) || fileName.endsWith(suffix);
    }

    public void merge(JURLs jurl) {
        Enumeration e = jurl.elements();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            if (this.contains(url)) continue;
            this.add(url);
        }
    }

    public void remove(File file) throws MalformedURLException {
        if (file.exists()) {
            this.remove(file.toURL());
        } else {
            String err = "Warning: Resource " + file.getName();
            err = err + " cannot be removed : It doesn't exist";
            System.out.println(err);
        }
    }

    public URL[] toURLs() {
        return (URL[])super.toArray(new URL[this.elementCount]);
    }
}

