/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.LogEntryImpl;
import org.ow2.jonas.workcleaner.LogEntry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerLog {
    private Log logger = LogFactory.getLog(DeployerLog.class);
    private static final String SEPARATOR_ENTRY = ";";
    private File logFile;
    private Vector<LogEntry> logEntries = null;

    public DeployerLog(File logFile) throws DeployerLogException {
        this.logger.debug("logfile=" + logFile.getName(), new Object[0]);
        this.logFile = logFile;
        this.logEntries = new Vector();
        this.loadEntries();
    }

    protected Log getLogger() {
        return this.logger;
    }

    private synchronized void loadEntries() throws DeployerLogException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.logFile));
        }
        catch (FileNotFoundException e) {
            throw new DeployerLogException("Can not read the " + this.logFile + " file");
        }
        String line = null;
        String field = null;
        File originalField = null;
        File copyField = null;
        StringTokenizer st = null;
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, SEPARATOR_ENTRY);
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                originalField = new File(field);
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                copyField = new File(field);
                this.logger.debug("Entry[originalField=" + originalField + ",copyField=" + copyField + "]", new Object[0]);
                this.logEntries.add((Object)new LogEntryImpl(originalField, copyField));
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new DeployerLogException("Error while reading the log file " + this.logFile + " :" + ioe.getMessage());
        }
    }

    private synchronized void saveEntries() throws DeployerLogException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(this.logFile)));
        }
        catch (IOException e) {
            throw new DeployerLogException("Problem while trying to get an output stream for the " + this.logFile + " file");
        }
        LogEntry logEntry = null;
        String original = null;
        String copy = null;
        String line = null;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements()) {
            logEntry = (LogEntry)e.nextElement();
            try {
                original = logEntry.getOriginal().getCanonicalPath();
                copy = logEntry.getCopy().getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new DeployerLogException("Problem while trying to get files names ");
            }
            line = original + SEPARATOR_ENTRY + copy;
            pw.println(line);
        }
        pw.close();
    }

    public synchronized Vector<LogEntry> getEntries() {
        return this.logEntries;
    }

    public synchronized Vector<LogEntry> removeEntry(LogEntry entry) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not remove a entry, the vector is null");
        }
        if (!this.logEntries.contains((Object)entry)) {
            throw new DeployerLogException("Can not remove entry " + entry + ". There is no such entry");
        }
        this.logEntries.remove((Object)entry);
        this.saveEntries();
        return this.logEntries;
    }

    public synchronized Vector<LogEntry> addEntry(File original, File copy) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not add an entry, the vector is null");
        }
        LogEntry logEntry = null;
        File originalEntry = null;
        File copyEntry = null;
        boolean found = false;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements() && !found) {
            logEntry = (LogEntry)e.nextElement();
            originalEntry = logEntry.getOriginal();
            copyEntry = logEntry.getCopy();
            if (!originalEntry.getPath().equals(original.getPath()) || !copyEntry.getPath().equals(copy.getPath())) continue;
            found = true;
        }
        if (found) {
            return this.logEntries;
        }
        logEntry = new LogEntryImpl(original, copy);
        this.logEntries.add((Object)logEntry);
        this.saveEntries();
        return this.logEntries;
    }
}

