/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.listener.TimestampedLogger;
import org.objectweb.jonas.ant.JOnASBaseTask;
import org.objectweb.jonas.ant.JOnASClusterConfigTask;
import org.objectweb.jonas.ant.cluster.ClusterDaemon;
import org.objectweb.jonas.ant.jonasbase.Carol;
import org.objectweb.jonas.ant.jonasbase.Db;
import org.objectweb.jonas.ant.jonasbase.Discovery;
import org.objectweb.jonas.ant.jonasbase.Ha;
import org.objectweb.jonas.ant.jonasbase.JdbcRa;
import org.objectweb.jonas.ant.jonasbase.Jms;
import org.objectweb.jonas.ant.jonasbase.JonasProperties;
import org.objectweb.jonas.ant.jonasbase.Mail;
import org.objectweb.jonas.ant.jonasbase.Services;
import org.objectweb.jonas.ant.jonasbase.Tasks;
import org.objectweb.jonas.ant.jonasbase.WebContainer;
import org.objectweb.jonas.ant.jonasbase.web.Ajp;
import org.objectweb.jonas.ant.jonasbase.web.Cluster;
import org.objectweb.jonas.ant.jonasbase.web.Http;
import org.objectweb.jonas.ant.jonasbase.web.Https;
import org.objectweb.jonas.ant.jonasbase.web.Tomcat;
import org.objectweb.jonas.ant.jonasbase.wsdl.WsdlPublish;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;
import org.ow2.jonas.tools.configurator.impl.FileReplacerHelper;

public class Jonas4
extends FileReplacerHelper
implements JonasConfigurator {
    public boolean isDebug = true;
    private File jonasFileBase;
    private JOnASBaseTask jonasBase;
    private JOnASClusterConfigTask clusterDaemonTask;
    private ClusterDaemon clusterDaemon;
    private static Logger logger = Logger.getLogger(Jonas4.class);
    private Carol carol;
    private boolean isProtocolsListSet = false;
    private Db db;
    private boolean isDbActivated = false;
    private Discovery discovery;
    private boolean isDiscoveryMaster = false;
    private JdbcRa jdbcRa;
    private boolean isJdbcRaActivated = false;
    private Jms jms;
    private JonasProperties jonasProperties;
    private Mail mail;
    private boolean isMailActivated = false;
    private Services services;
    private WebContainer webContainer;
    private Tomcat tomcat;
    private Ajp ajp;
    private Http http;
    private Https https;
    private Cluster cluster;
    private org.objectweb.jonas.ant.jonasbase.wsdl.File file;
    private WsdlPublish wsdlPublish;
    private boolean isWsdlPublishActivated = false;
    private Ha ha;
    private Project project;
    private boolean isJonasRootSet = false;
    private boolean isJonasBaseSet = false;
    private Boolean isHttpActivated = true;
    private Boolean isHttpsActivated = false;
    private Boolean isAjpActivated = false;
    private Boolean isHttpReplicationActivated = false;
    private Boolean isHaActivated = false;
    private Boolean isEjbClusteringActivated = false;
    private String saveCmiMCastAddr;
    private String saveCmiMCastPort;

    public Jonas4() {
        ResourceBundle properties = ResourceBundle.getBundle("properties.configurator");
        this.isDebug = new Boolean(properties.getString("debug_mode"));
        this.jonasBase = new JOnASBaseTask();
        this.createProject();
        this.jonasBase.setProject(this.project);
        this.clusterDaemonTask = new JOnASClusterConfigTask();
        this.clusterDaemonTask.setProject(this.project);
        this.carol = new Carol();
        this.db = new Db();
        this.discovery = new Discovery();
        this.jdbcRa = new JdbcRa();
        this.jms = new Jms();
        try {
            this.jonasProperties = new JonasProperties();
        }
        catch (NoClassDefFoundError e) {
            this.jonasProperties = null;
            this.services = new Services();
        }
        this.mail = new Mail();
        this.webContainer = new WebContainer();
        this.tomcat = new Tomcat();
        this.ajp = new Ajp();
        this.http = new Http();
        this.https = new Https();
        this.cluster = new Cluster();
        this.wsdlPublish = new WsdlPublish();
        this.file = new org.objectweb.jonas.ant.jonasbase.wsdl.File();
        this.ha = new Ha();
        this.clusterDaemon = new ClusterDaemon();
        this.clusterDaemon.setProtocol("jrmp");
        this.clusterDaemon.setPort("1099");
        logger.debug("Created the Jonas5 instance");
    }

    private void createProject() {
        this.project = new Project();
        this.project.init();
        this.project.initProperties();
        if (logger.isDebugEnabled()) {
            TimestampedLogger logger = new TimestampedLogger();
            logger.setMessageOutputLevel(4);
            logger.setOutputPrintStream(new PrintStream(new OutputStream(){
                StringBuffer buf = new StringBuffer();

                public void write(int b) throws IOException {
                    if (b == 10 || b == 13) {
                        if (this.buf.length() > 0) {
                            logger.debug(this.buf);
                            this.buf.setLength(0);
                        }
                    } else {
                        this.buf.append((char)b);
                    }
                }
            }));
            this.project.addBuildListener(logger);
        }
    }

    public void setJdk(String jdk) {
        logger.debug("[GlobalParameters] setting jdk : " + jdk);
        if (!this.isDebug) {
            throw new IllegalArgumentException("jdk unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setJavaOpts(String javaOpts) {
        logger.debug("[GlobalParameters] setting java opts : " + javaOpts);
        if (this.jonasProperties != null) {
            this.jonasProperties.setJvmopts(javaOpts);
        }
    }

    public void setJonasRoot(String jonasRoot) {
        logger.debug("[GlobalParameters] setting jonas root : " + jonasRoot);
        File jonasFileRoot = new File(jonasRoot);
        this.jonasBase.setJonasRoot(jonasFileRoot);
        this.discovery.setJonasRoot(jonasRoot);
        this.isJonasRootSet = true;
    }

    public void setJonasBase(String jonasBase) {
        logger.debug("[GlobalParameters] setting jonas base : " + jonasBase);
        this.jonasFileBase = new File(jonasBase);
        this.jonasBase.setDestDir(this.jonasFileBase);
        this.isJonasBaseSet = true;
    }

    public void setJonasVersion(String jonasVersion) {
        logger.debug("[GlobalParameters] setting version : " + jonasVersion);
        if (!this.isDebug) {
            throw new IllegalArgumentException("jonasVersion unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setJonasName(String jonasName) {
        logger.debug("[GlobalParameters] setting jonas name : " + jonasName);
        if (this.jonasProperties != null) {
            this.jonasProperties.setServerName(jonasName);
        }
    }

    public void setJonasDomain(String jonasDomain) {
        logger.debug("[GlobalParameters] setting jonas domain : " + jonasDomain);
        if (this.jonasProperties != null) {
            this.jonasProperties.setDomainName(jonasDomain);
        }
    }

    public void setHost(String jonasHost) {
        logger.debug("[GlobalParameters] setting host : " + jonasHost);
        this.addReplacement("carol.properties", "://localhost:", "://" + jonasHost + ":");
    }

    public void setProtocolsList(String protocolsList) {
        logger.debug("[Protocols configuration] setting protocols list : " + protocolsList);
        this.carol.setProtocols(protocolsList);
        this.isProtocolsListSet = true;
    }

    public void setProtocolsIrmiPort(String irmiPort) {
        logger.debug("[Protocols configuration] setting irmi port : " + irmiPort);
        this.carol.setIrmiPort(irmiPort);
    }

    public void setProtocolsIiopPort(String iiopPort) {
        logger.debug("[Protocols configuration] setting iiop port : " + iiopPort);
        this.carol.setIiopPort(iiopPort);
    }

    public void setProtocolsJrmpPort(String jrmpPort) {
        logger.debug("[Protocols configuration] setting jrmp port : " + jrmpPort);
        this.carol.setJrmpPort(jrmpPort);
    }

    public void setProtocolsCmiPort(String cmiPort) {
        logger.debug("[Protocols configuration] setting cmi port : " + cmiPort);
        this.carol.setCmiPort(cmiPort);
    }

    public void setProtocolsLocalCallOptimized(Boolean localCallOptimized) {
        logger.debug("[Protocols configuration] setting jndi local call optimisation : " + localCallOptimized);
        this.carol.setJrmpOptimization(localCallOptimized.booleanValue());
    }

    public void setServices(String services) {
        logger.debug("setting active services list : " + services);
        if (this.jonasProperties != null) {
            this.jonasProperties.setServices(services);
        } else {
            this.services.setNames(services);
        }
    }

    public void setHttpsConnectorActivation(Boolean activation) {
        logger.debug("[Web configuration] setting isHttpsActivated : " + activation);
        this.isHttpsActivated = activation;
    }

    public void setAjpConnectorActivation(Boolean activation) {
        logger.debug("[Web configuration] setting isAjpActivated : " + activation);
        this.isAjpActivated = activation;
    }

    public void setHttpSessionReplicationActivation(Boolean activation) {
        logger.debug("[Web configuration] setting isHttpReplicationActivated : " + activation);
        this.isHttpReplicationActivated = activation;
    }

    public void setHttpPort(String httpPort) {
        logger.debug("[Web configuration] setting http port : " + httpPort);
        this.http.setPort(httpPort);
        this.addReplacement("uddi.properties", ":9000/", ":" + httpPort + "/");
    }

    public void setHttpMaxThreads(String httpMaxThreads) {
        logger.debug("[Web configuration] setting max http threads : " + httpMaxThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpMaxThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setHttpMinSpareThreads(String httpMinSpareThreads) {
        logger.debug("[Web configuration] setting min http spare threads : " + httpMinSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpMinSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setHttpMaxSpareThreads(String httpMaxSpareThreads) {
        logger.debug("[Web configuration] setting max http spare threads : " + httpMaxSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpMaxSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setHttpsPort(String httpsPort) {
        logger.debug("[Web configuration] setting https port : " + httpsPort);
        this.https.setPort(httpsPort);
    }

    public void setHttpsMaxThreads(String httpsMaxThreads) {
        logger.debug("[Web configuration] setting max https threads : " + httpsMaxThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpsMaxThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setHttpsMinSpareThreads(String httpsMinSpareThreads) {
        logger.debug("[Web configuration] setting min https spare threads : " + httpsMinSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpsMinSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setHttpsMaxSpareThreads(String httpsMaxSpareThreads) {
        logger.debug("[Web configuration] setting max https spare threads : " + httpsMaxSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("httpsMaxSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setAjpPort(String ajpPort) {
        logger.debug("[Web configuration] setting ajp port : " + ajpPort);
        this.ajp.setPort(ajpPort);
    }

    public void setAjpMaxThreads(String ajpMaxThreads) {
        logger.debug("[Web configuration] setting max ajp threads : " + ajpMaxThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("ajpMaxThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setAjpMinSpareThreads(String ajpMinSpareThreads) {
        logger.debug("[Web configuration] setting min ajp spare threads : " + ajpMinSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("ajpMinSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setAjpMaxSpareThreads(String ajpMaxSpareThreads) {
        logger.debug("[Web configuration] setting max ajp spare threads : " + ajpMaxSpareThreads);
        if (!this.isDebug) {
            throw new IllegalArgumentException("ajpMaxSpareThreads unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setJvmRoute(String jvmRoute) {
        logger.debug("[Web configuration] setting jvm route : " + jvmRoute);
        try {
            this.tomcat.setJvmRoute(jvmRoute);
        }
        catch (NoSuchMethodError e) {
            this.addReplacement("server.xml", "<Engine name=\"jonas\" defaultHost=\"localhost\">", "<Engine name=\"jonas\" defaultHost=\"localhost\" jvmRoute=\"" + jvmRoute + "\">");
        }
    }

    public void setHttpReplicationClusterName(String clusterName) {
        logger.debug("[Web configuration] setting cluster name : " + clusterName);
        this.cluster.setName(clusterName);
    }

    public void setHttpReplicationMCastAddr(String mCastAddr) {
        logger.debug("[Web configuration] setting multi cast address : " + mCastAddr);
        this.cluster.setMcastAddr(mCastAddr);
    }

    public void setHttpReplicationMCastPort(String mCastPort) {
        logger.debug("[Web configuration] setting multi cast port : " + mCastPort);
        this.cluster.setMcastPort(mCastPort);
    }

    public void setHttpReplicationListenPort(String listenPort) {
        logger.debug("[Web configuration] setting listen port : " + listenPort);
        this.cluster.setListenPort(listenPort);
    }

    public void setDbPort(String port) {
        logger.debug("[Database configuration] setting db port: " + port);
        this.isDbActivated = true;
        this.db.setPort(port);
        this.addReplacement("HSQL1.properties", ":9001/", ":" + port + "/");
    }

    public void setDiscoveryMasterActivated(Boolean masterActivated) {
        logger.debug("[Discovery configuration] setting masterActivated : " + masterActivated);
        this.isDiscoveryMaster = masterActivated;
    }

    public void setDiscoverySourcePort(String sourcePort) {
        logger.debug("[Discovery configuration] setting source port : " + sourcePort);
        this.discovery.setSourcePort(sourcePort);
    }

    public void setDiscoveryDomainName(String domainName) {
        logger.debug("[Discovery configuration] setting domain name : " + domainName);
        if (!this.isJonasRootSet) {
            logger.error("[Discovery configuration] As jonas root isn't set, domain name skipped : ");
        } else {
            this.discovery.setDomainName(domainName);
        }
    }

    public void setDiscoveryGreetingPort(String greetingPort) {
        logger.debug("[Discovery configuration] setting greeting port : " + greetingPort);
        this.discovery.setGreetingPort(greetingPort);
    }

    public void setDiscoveryMulticastAddress(String multicastAddress) {
        logger.debug("[Discovery configuration] setting multicast address : " + multicastAddress);
        this.discovery.setMcastAddr(multicastAddress);
    }

    public void setDiscoveryMulticastPort(String multicastPort) {
        logger.debug("[Discovery configuration] setting multicast port : " + multicastPort);
        this.discovery.setMcastPort(multicastPort);
    }

    public void setDiscoveryTtl(String ttl) {
        logger.debug("[Discovery configuration] setting tlt : " + ttl);
        if (!this.isDebug) {
            throw new IllegalArgumentException("ttl unsupported");
        }
        logger.debug("Parameter cannot be applied");
    }

    public void setMailFactoryType(String factoryType) {
        logger.debug("[Mail Service Configuration] setting mail factory type : " + factoryType);
        this.mail.setType(factoryType);
        this.isMailActivated = true;
    }

    public void setMailFactoryName(String factoryName) {
        logger.debug("[Mail Service Configuration] setting mail factory name : " + factoryName);
        this.mail.setName(factoryName);
        this.isMailActivated = true;
    }

    public void setWSDLFileName(String fileName) {
        logger.debug("[WS Service configuration] setting file name : " + fileName);
        this.file.setName(fileName);
        this.isWsdlPublishActivated = true;
    }

    public void setWSDLFileDir(String fileDir) {
        logger.debug("[WS Service configuration] setting file directory : " + fileDir);
        this.file.setDir(fileDir);
        this.isWsdlPublishActivated = true;
    }

    public void setHaActivated(Boolean activated) {
        logger.debug("[HA Service configuration] setting ha activated : " + activated);
        this.isHaActivated = activated;
    }

    public void setHaMulticastAddr(String multicastAddr) {
        logger.debug("[HA Service configuration] setting multicast address : " + multicastAddr);
        this.ha.setMcastAddr(multicastAddr);
    }

    public void setHaMulticastPort(String multicastPort) {
        logger.debug("[HA Service configuration] setting multicast port : " + multicastPort);
        this.ha.setMcastPort(multicastPort);
    }

    public void setSecurityManagerActivation(Boolean activation) {
        logger.debug("[Security Manager configuration] setting isActivated : " + activation);
        if (this.jonasProperties != null) {
            this.jonasProperties.setSecurityManager(activation.booleanValue());
        } else {
            this.addReplacement("jonas.properties", "jonas.security.manager    true", "jonas.security.manager    " + activation.toString());
        }
    }

    public void setEjbClusteringActivated(Boolean activated) {
        logger.debug("[Ejb Clustering configuration] setting ejb clustering activated activated : " + activated);
        this.isEjbClusteringActivated = activated;
    }

    public void setEjbClusteringMulticastAddr(String multicastAddr) {
        logger.debug("[Ejb Clustering configuration] setting multicast address : " + multicastAddr);
        this.saveCmiMCastAddr = multicastAddr;
    }

    public void setEjbClusteringMulticastPort(String multicastPort) {
        logger.debug("[Ejb Clustering configuration] setting multicast port : " + multicastPort);
        this.saveCmiMCastPort = multicastPort;
    }

    public void setJmsPort(String port) {
        logger.debug("[Jms configuration] setting port : " + port);
        this.jms.setPort(port);
    }

    public void setJmsQueue(String queue) {
        logger.debug("[Jms configuration] setting queue : " + queue);
        this.jms.setInitialQueues(queue);
    }

    public void setJmsTopic(String topic) {
        logger.debug("[Jms configuration] setting topic : " + topic);
        this.jms.setInitialTopics(topic);
    }

    public void setJdbcDrivers(String driver) {
        logger.debug("[Jdbc configuration] setting drivers: " + driver);
        this.jdbcRa.setDriverName(driver);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcDsClass(String dsClass) {
        logger.debug("[Jdbc configuration] setting ds class : " + dsClass);
        if (!this.isDebug) {
            throw new IllegalArgumentException("dsClass unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcRaName(String raName) {
        logger.debug("[Jdbc configuration] setting RA name : " + raName);
        this.jdbcRa.setName(raName);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcCheckLevel(String checkLevel) {
        logger.debug("[Jdbc configuration] setting check level: " + checkLevel);
        if (!this.isDebug) {
            throw new IllegalArgumentException("checkLevel unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcTestStatement(String testStatement) {
        logger.debug("[Jdbc configuration] setting test statement: " + testStatement);
        if (!this.isDebug) {
            throw new IllegalArgumentException("testStatement unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcJndiname(String jndiname) {
        logger.debug("[Jdbc configuration] setting jndi name: " + jndiname);
        this.jdbcRa.setJndiName(jndiname);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcMappername(String mappername) {
        logger.debug("[Jdbc configuration] setting mappername: " + mappername);
        this.jdbcRa.setMapperName(mappername);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPassword(String password) {
        logger.debug("[Jdbc configuration] setting password: " + password);
        this.jdbcRa.setPassword(password);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcRarlink(String rarLink) {
        logger.debug("[Jdbc configuration] setting rar link: " + rarLink);
        if (!this.isDebug) {
            throw new IllegalArgumentException("rarLink unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcUrl(String url) {
        logger.debug("[Jdbc configuration] setting url: " + url);
        this.jdbcRa.setUrl(url);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcUser(String user) {
        logger.debug("[Jdbc configuration] setting user: " + user);
        this.jdbcRa.setUser(user);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolInit(String poolInit) {
        logger.debug("[Jdbc configuration] setting pool init : " + poolInit);
        if (!this.isDebug) {
            throw new IllegalArgumentException("poolInit unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMax(String poolMax) {
        logger.debug("[Jdbc configuration] setting pool max: " + poolMax);
        this.jdbcRa.setMaxPoolSize(poolMax);
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMaxAgeMinutes(String poolMaxAgeMinutes) {
        logger.debug("[Jdbc configuration] setting pool max age minutes: " + poolMaxAgeMinutes);
        try {
            this.jdbcRa.setConnMaxAge(poolMaxAgeMinutes);
        }
        catch (NoSuchMethodError e) {
            if (this.isDebug) {
                logger.debug("Parameter cannot be applied");
            }
            throw new IllegalArgumentException("poolMaxAgeMinutes unsupported");
        }
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMaxOpentime(String poolMaxOpenTime) {
        logger.debug("[Jdbc configuration] setting pool max open time: " + poolMaxOpenTime);
        try {
            this.jdbcRa.setMaxOpenTime(poolMaxOpenTime);
        }
        catch (NoSuchMethodError e) {
            if (this.isDebug) {
                logger.debug("Parameter cannot be applied");
            }
            throw new IllegalArgumentException("poolMaxOpenTime unsupported");
        }
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMaxWaiters(String poolMaxWaiters) {
        logger.debug("[Jdbc configuration] setting max waiters: " + poolMaxWaiters);
        try {
            this.jdbcRa.setMaxWaiters(poolMaxWaiters);
        }
        catch (NoSuchMethodError e) {
            if (this.isDebug) {
                logger.debug("Parameter cannot be applied");
            }
            throw new IllegalArgumentException("poolMaxWaiters unsupported");
        }
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMaxWaittime(String poolMaxWaittime) {
        logger.debug("[Jdbc configuration] setting pool max wait time: " + poolMaxWaittime);
        try {
            this.jdbcRa.setMaxWaitTime(poolMaxWaittime);
        }
        catch (NoSuchMethodError e) {
            if (this.isDebug) {
                logger.debug("Parameter cannot be applied");
            }
            throw new IllegalArgumentException("poolMaxWaittime unsupported");
        }
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolMin(String poolMin) {
        logger.debug("[Jdbc configuration] setting pool min: " + poolMin);
        if (!this.isDebug) {
            throw new IllegalArgumentException("poolMin unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolSamplingPeriod(String poolSamplingPeriod) {
        logger.debug("[Jdbc configuration] setting pool sampling period : " + poolSamplingPeriod);
        if (!this.isDebug) {
            throw new IllegalArgumentException("poolSamplingPeriod unsupported");
        }
        logger.debug("Parameter cannot be applied");
        this.isJdbcRaActivated = true;
    }

    public void setJdbcPoolPstmtMax(String pstmtMax) {
        logger.debug("[Jdbc configuration] setting max prepared statements: " + pstmtMax);
        try {
            this.jdbcRa.setMaxPreparedStatementsSize(pstmtMax);
        }
        catch (NoSuchMethodError e) {
            if (this.isDebug) {
                logger.debug("Parameter cannot be applied");
            }
            throw new IllegalArgumentException("pstmtMax unsupported");
        }
        this.isJdbcRaActivated = true;
    }

    public void execute() {
        if (!this.isJonasRootSet) {
            throw new IllegalArgumentException("Jonas root is not set.");
        }
        if (!this.isJonasBaseSet) {
            throw new IllegalArgumentException("Jonas base is not set.");
        }
        if (this.isHttpActivated.booleanValue()) {
            this.tomcat.addConfiguredHttp(this.http);
        }
        if (this.isHttpsActivated.booleanValue()) {
            this.tomcat.addConfiguredHttps(this.https);
        }
        if (this.isAjpActivated.booleanValue()) {
            this.tomcat.addConfiguredAjp(this.ajp);
        }
        if (this.isHttpReplicationActivated.booleanValue()) {
            this.tomcat.addConfiguredCluster(this.cluster);
        }
        this.webContainer.addConfiguredTomcat(this.tomcat);
        if (this.isEjbClusteringActivated.booleanValue()) {
            this.carol.setCmiMcastAddr(this.saveCmiMCastAddr);
            this.carol.setCmiMcastPort(this.saveCmiMCastPort);
        }
        if (!this.isProtocolsListSet) {
            this.carol.setProtocols("jrmp");
        }
        this.jonasBase.addConfiguredCarol(this.carol);
        if (this.isDbActivated) {
            this.jonasBase.addConfiguredDb(this.db);
        }
        if (this.isDiscoveryMaster) {
            this.discovery.setSourcePort("-1");
        }
        this.jonasBase.addConfiguredDiscovery(this.discovery);
        if (this.isJdbcRaActivated) {
            this.jonasBase.addConfiguredJdbcRa(this.jdbcRa);
        }
        this.jonasBase.addConfiguredJms(this.jms);
        if (this.jonasProperties != null) {
            this.jonasBase.addConfiguredJonasProperties(this.jonasProperties);
        } else {
            this.jonasBase.addConfiguredServices(this.services);
        }
        if (this.isMailActivated) {
            this.jonasBase.addConfiguredMail(this.mail);
        }
        this.jonasBase.addConfiguredWebContainer(this.webContainer);
        if (this.isWsdlPublishActivated) {
            this.wsdlPublish.addConfiguredFile(this.file);
            this.jonasBase.addConfiguredWsdlPublish(this.wsdlPublish);
        }
        if (this.isHaActivated.booleanValue()) {
            this.jonasBase.addTasks((Tasks)this.ha);
        }
        this.jonasBase.execute();
        this.doReplacements(new File(this.jonasFileBase, "conf"));
    }

    public void setCDClusterName(String clusterName) {
        logger.debug("[Cluster daemon configuration] setting cluster name : " + clusterName);
        this.clusterDaemon.setName(clusterName);
        this.clusterDaemon.updateName();
    }

    public void setCDClusterDomain(String clusterDomain) {
        logger.debug("[Cluster daemon configuration] setting cluster domain name : " + clusterDomain);
        this.clusterDaemon.setDomainName(clusterDomain);
    }

    public void setCDProtocol(String protocol) {
        logger.debug("[Cluster daemon configuration] setting protocol : " + protocol);
        this.clusterDaemon.setProtocol(protocol);
    }

    public void setCDPort(String port) {
        logger.debug("[Cluster daemon configuration] setting port : " + port);
        this.clusterDaemon.setPort(port);
    }

    public void setCDDestDirPrefix(String destDirPrefix) {
        logger.debug("[Cluster daemon configuration] setting dest dir prefix : " + destDirPrefix);
        this.clusterDaemon.setDestDirPrefix(destDirPrefix);
        this.clusterDaemonTask.setDestDirPrefix(destDirPrefix);
        this.clusterDaemon.setCdDir(destDirPrefix);
        this.clusterDaemonTask.setCdDir(destDirPrefix);
    }

    public void setCDInteractionMode(String interactionMode) {
        logger.debug("[Cluster daemon configuration] setting interaction mode : " + interactionMode);
        this.clusterDaemon.setInteractionMode(interactionMode);
    }

    public void setCDJavaHome(String javaHome) {
        logger.debug("[Cluster daemon configuration] setting java home : " + javaHome);
        this.clusterDaemon.setJdk(javaHome);
    }

    public void setCDJonasRoot(String jonasRoot) {
        logger.debug("[Cluster daemon configuration] setting jonas root : " + jonasRoot);
        this.clusterDaemon.setJonasRoot(jonasRoot);
        this.clusterDaemonTask.setJonasRoot(new File(jonasRoot));
    }

    public void setCDServerNamePrefix(String serverNamePrefix) {
        logger.debug("[Cluster daemon configuration] setting server name prefix : " + serverNamePrefix);
        this.clusterDaemon.setClusterNodesName(serverNamePrefix);
    }

    public void setCDXparam(String xparam) {
        logger.debug("[Cluster daemon configuration] setting xparam : " + xparam);
        this.clusterDaemon.setXprm(xparam);
    }

    public void setCDAutoBoot(boolean autoBoot) {
        logger.debug("[Cluster daemon configuration] setting auto boot : " + autoBoot);
        this.clusterDaemon.setAutoBoot(new Boolean(autoBoot).toString());
    }

    public void setCDNbInstances(int nbInsts) {
        logger.debug("[Cluster daemon configuration] setting nb instance : " + nbInsts);
        this.clusterDaemon.setInstNb(nbInsts);
        this.clusterDaemonTask.setWebInstNb(nbInsts);
        this.clusterDaemonTask.setEjbInstNb(0);
    }

    public void executeCDConf() {
        this.clusterDaemonTask.addConfiguredClusterDaemon(this.clusterDaemon);
        this.clusterDaemonTask.execute();
    }
}

