/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.AbsArchiveImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryArchive
extends AbsArchiveImpl
implements IArchive {
    private Map<String, URL> urlMap = new HashMap();

    public MemoryArchive() {
    }

    public MemoryArchive(ClassLoader classLoader, List<String> classNames) {
        this.addClassResource(classLoader, classNames);
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getName() {
        return "ArchiveInMemory";
    }

    @Override
    public URL getResource(String resourceName) {
        return (URL)this.urlMap.get((Object)resourceName);
    }

    @Override
    public Iterator<URL> getResources() {
        return this.urlMap.values().iterator();
    }

    @Override
    public Iterator<URL> getResources(String resourceName) {
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.urlMap.get((Object)resourceName));
        return linkedList.iterator();
    }

    @Override
    public URL getURL() {
        try {
            return new URL("file:///" + System.identityHashCode(this));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot build URL", (Throwable)e);
        }
    }

    public void addResource(String resourceName, URL url) {
        this.urlMap.put((Object)resourceName, (Object)url);
    }

    public void addClassResource(ClassLoader classLoader, List<String> classNames) {
        Iterator i$ = classNames.iterator();
        while (i$.hasNext()) {
            String className = (String)i$.next();
            String resourceName = className.replace('.', '/').concat(".class");
            this.urlMap.put((Object)resourceName, (Object)classLoader.getResource(resourceName));
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.urlMap.keySet().iterator();
    }
}

