/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.deployer.DeployerManagerCallbackType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployerManager
implements IDeployerManager {
    public static final String DEPLOYER_FACTORY_CLASS_NAME = DeployerManager.class.getName();
    private static Log logger = LogFactory.getLog(DeployerManager.class);
    private List<IDeployer> deployers = new ArrayList();
    private List<IDeployerManagerCallback> callbacks = new ArrayList();

    @Override
    public void register(IDeployer deployer) {
        if (deployer != null) {
            logger.debug("Registering deployer ''{0}''", deployer.getClass());
            this.deployers.add((Object)deployer);
        }
    }

    @Override
    public void unregister(IDeployer deployer) {
        if (this.deployers.contains((Object)deployer)) {
            logger.debug("Unregistering deployer ''{0}''", deployer);
            this.deployers.remove((Object)deployer);
        } else {
            logger.warn("Cannot unregister the deployer ''{0}'' as it is not registered.", deployer);
        }
    }

    protected IDeployer findDeployerForDeployable(IDeployable<?> deployable) throws UnsupportedDeployerException {
        Iterator i$ = this.deployers.iterator();
        while (i$.hasNext()) {
            IDeployer deployer = (IDeployer)i$.next();
            if (!deployer.supports(deployable)) continue;
            return deployer;
        }
        throw new UnsupportedDeployerException("No deployer was found for the deployable '" + deployable + "'.");
    }

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.callback(DeployerManagerCallbackType.PRE_DEPLOY, deployable);
        this.findDeployerForDeployable(deployable).deploy(deployable);
        this.callback(DeployerManagerCallbackType.POST_DEPLOY, deployable);
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        this.callback(DeployerManagerCallbackType.PRE_UNDEPLOY, deployable);
        this.findDeployerForDeployable(deployable).undeploy(deployable);
        this.callback(DeployerManagerCallbackType.POST_UNDEPLOY, deployable);
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException, UnsupportedDeployerException {
        return this.findDeployerForDeployable(deployable).isDeployed(deployable);
    }

    @Override
    public void addCallback(IDeployerManagerCallback callback) {
        if (!this.callbacks.contains((Object)callback)) {
            this.callbacks.add((Object)callback);
        } else {
            logger.warn("Callback already added", new Object[0]);
        }
    }

    @Override
    public void removeCallback(IDeployerManagerCallback callback) {
        if (!this.callbacks.contains((Object)callback)) {
            logger.warn("Callback doesn't exist", new Object[0]);
        } else {
            this.callbacks.remove((Object)callback);
        }
    }

    private void callback(DeployerManagerCallbackType type, IDeployable<?> deployable) {
        Iterator i$ = this.callbacks.iterator();
        while (i$.hasNext()) {
            IDeployerManagerCallback callback = (IDeployerManagerCallback)i$.next();
            try {
                switch (type) {
                    case PRE_DEPLOY: {
                        callback.preDeploy(deployable);
                        break;
                    }
                    case POST_DEPLOY: {
                        callback.postDeploy(deployable);
                        break;
                    }
                    case PRE_UNDEPLOY: {
                        callback.preUndeploy(deployable);
                        break;
                    }
                    case POST_UNDEPLOY: {
                        callback.postUndeploy(deployable);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error during the execution of the ''{0}'' callback for ''{1}''", new Object[]{type, deployable.getArchive(), t});
                t.printStackTrace();
            }
        }
    }
}

