/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.car.impl.xml.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.metadata.car.api.ICarClassMetadata;
import org.ow2.util.ee.metadata.car.api.ICarFieldMetadata;
import org.ow2.util.ee.metadata.car.api.ICarMethodMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.xml.struct.CAR;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(CarMetadataMerge.class);
    private CarDeployableMetadata carDeployableMetadata;

    public CarMetadataMerge(CarDeployableMetadata carDeployableMetadata) {
        this.carDeployableMetadata = carDeployableMetadata;
    }

    public void merge(CAR car) {
        this.applyJndiEnvironmentRefsGroup(car, this.carDeployableMetadata);
        String callbackHandler = car.getCallbackHandler();
        if (callbackHandler != null) {
            ICarClassMetadata carClassMetadata = this.getClassMetadata(callbackHandler.replace('.', '/'));
            if (carClassMetadata == null) {
                LOGGER.error("The callback handler class '" + callbackHandler + "' defined in xml was not found.", new Object[0]);
            } else {
                carClassMetadata.setCallbackHandler(true);
            }
        }
    }

    public ICarClassMetadata getClassMetadata(String className) {
        return this.carDeployableMetadata.getCarClassMetadata(className);
    }

    @Override
    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        IArchiveMetadata metadata = this.carDeployableMetadata.getDeployable().getArchive().getMetadata();
        String mainClassName = metadata.get(Attributes.Name.MAIN_CLASS.toString());
        if (mainClassName == null && (mainClassName = metadata.get("main-class")) != null) {
            LOGGER.warn("The '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute is not written correctly in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'", new Object[0]);
        }
        if (mainClassName == null) {
            throw new IllegalStateException("No '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute found in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'");
        }
        return CarMetadataMerge.encode(mainClassName);
    }

    @Override
    protected List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(IEnvironmentRefAccessor carMetadata, String name) {
        ArrayList elements = new ArrayList();
        Collection<ICarClassMetadata> clientClassesMetadata = this.carDeployableMetadata.getCarClassMetadataCollection();
        if (clientClassesMetadata != null) {
            Iterator i$ = clientClassesMetadata.iterator();
            while (i$.hasNext()) {
                Collection methodMetadatas;
                ICarClassMetadata classMetadata = (ICarClassMetadata)i$.next();
                Collection fieldMetadatas = classMetadata.getStandardFieldMetadataCollection();
                if (fieldMetadatas != null) {
                    Iterator i$2 = fieldMetadatas.iterator();
                    while (i$2.hasNext()) {
                        ICarFieldMetadata fieldMetadata = (ICarFieldMetadata)i$2.next();
                        this.addJaxwsWebServiceRefIfFound(fieldMetadata, name, elements);
                    }
                }
                if ((methodMetadatas = classMetadata.getStandardMethodMetadataCollection()) == null) continue;
                Iterator i$3 = methodMetadatas.iterator();
                while (i$3.hasNext()) {
                    ICarMethodMetadata methodMetadata = (ICarMethodMetadata)i$3.next();
                    this.addJaxwsWebServiceRefIfFound(methodMetadata, name, elements);
                }
            }
        }
        return elements;
    }

    @Override
    protected Collection<? extends ICommonClassMetadata> getAllClassMetadatas() {
        return this.carDeployableMetadata.getCarClassMetadataCollection();
    }

    @Override
    protected Collection<? extends ICommonMethodMetadata> getAllMethodMetadatas() {
        ArrayList methodMetadatas = new ArrayList();
        Collection<ICarClassMetadata> classMetadatas = this.carDeployableMetadata.getCarClassMetadataCollection();
        Iterator i$ = classMetadatas.iterator();
        while (i$.hasNext()) {
            ICommonClassMetadata classMetadata = (ICommonClassMetadata)i$.next();
            methodMetadatas.addAll(classMetadata.getStandardMethodMetadataCollection());
        }
        return methodMetadatas;
    }

    @Override
    protected Collection<? extends ICommonFieldMetadata> getAllFieldMetadatas() {
        ArrayList fieldMetadatas = new ArrayList();
        Collection<ICarClassMetadata> classMetadatas = this.carDeployableMetadata.getCarClassMetadataCollection();
        Iterator i$ = classMetadatas.iterator();
        while (i$.hasNext()) {
            ICommonClassMetadata classMetadata = (ICommonClassMetadata)i$.next();
            fieldMetadatas.addAll(classMetadata.getStandardFieldMetadataCollection());
        }
        return fieldMetadatas;
    }
}

