/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.impl.ASMScannerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployableMetadataFactory {
    private IScanner scanner;

    public AbsDeployableMetadataFactory() {
        this(new ASMScannerImpl());
    }

    public AbsDeployableMetadataFactory(IScanner scanner) {
        this.scanner = scanner;
    }

    protected void addClassToSetIfNotNull(String className, Set<String> stringSet) {
        if (className != null) {
            stringSet.add((Object)className.replace('.', '/'));
        }
    }

    protected void scan(Set<String> initialClassNameSet, IClassesLocator archiveClassLocator, List<? extends IClassesLocator> externClassLocator, IArchiveConfigurator archiveConfigurator) throws DeployableMetadataException {
        List archiveConfiguratorList = Arrays.asList(new IArchiveConfigurator[]{archiveConfigurator});
        HashSet classNameSet = new HashSet();
        ArrayList scannedClasses = new ArrayList();
        ArrayList nextClassNameToScan = new ArrayList();
        nextClassNameToScan.addAll(initialClassNameSet);
        try {
            while (nextClassNameToScan.size() != 0) {
                String className;
                Iterator i$ = nextClassNameToScan.iterator();
                while (i$.hasNext()) {
                    className = (String)i$.next();
                    URL url = archiveClassLocator.getClassURL(className);
                    if (url == null && externClassLocator != null) {
                        IClassesLocator classesLocator;
                        Iterator i$2 = externClassLocator.iterator();
                        while (i$2.hasNext() && (url = (classesLocator = (IClassesLocator)i$2.next()).getClassURL(className)) == null) {
                        }
                    }
                    if (url != null) {
                        this.scanner.scanClass(url, classNameSet, archiveConfiguratorList);
                    }
                    scannedClasses.add(className);
                }
                nextClassNameToScan.clear();
                i$ = classNameSet.iterator();
                while (i$.hasNext()) {
                    className = (String)i$.next();
                    if (scannedClasses.contains(className)) continue;
                    nextClassNameToScan.add(className);
                }
                classNameSet.clear();
            }
        }
        catch (ScanException e) {
            throw new DeployableMetadataException("Error during scan", e);
        }
    }
}

