/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.persistence.PersistenceContextType;
import org.ow2.util.asm.Type;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.struct.IJwsHandlerChain;
import org.ow2.util.ee.metadata.common.api.xml.struct.IActivationConfig;
import org.ow2.util.ee.metadata.common.api.xml.struct.IAroundInvoke;
import org.ow2.util.ee.metadata.common.api.xml.struct.ICommonEJBRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBLocalRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvEntry;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IInjectionTarget;
import org.ow2.util.ee.metadata.common.api.xml.struct.ILifeCycleCallback;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMessageDestinationRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMethodDD;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceContextRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceUnitRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceEnvRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IServiceRef;
import org.ow2.util.ee.metadata.common.impl.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.struct.JAnnotationResource;
import org.ow2.util.ee.metadata.common.impl.struct.JEjbEJB;
import org.ow2.util.ee.metadata.common.impl.struct.JInterceptors;
import org.ow2.util.ee.metadata.common.impl.struct.JavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.impl.struct.JavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ActivationConfig;
import org.ow2.util.ee.metadata.ejbjar.api.ClassType;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.TransactionAttributeLevel;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IApplicationException;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IAssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IBean;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IContainerTransaction;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEJB3;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptorBinding;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IMethodPermission;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IRemoveMethod;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.ISession;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JActivationConfigProperty;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JCommonBean;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JLocal;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemote;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemove;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.CommonMetadataMerge;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbJarMetadataMerge<E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>>
extends CommonMetadataMerge<E, D, C, M, F> {
    private static final String WILDCARD = "*";
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static Log logger = LogFactory.getLog(EjbJarMetadataMerge.class);

    private EjbJarMetadataMerge(D ejbMetadata) {
        super(ejbMetadata);
    }

    public static <E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>> void merge(D ejbMetadata) {
        super.resolve();
    }

    private void resolve() {
        String ejbClass;
        String ejbName;
        Iterator i$;
        String ejbClass2;
        String ejbName2;
        ISession session;
        Iterator i$2;
        List<ISession> sessionList;
        IEnterpriseBeans enterpriseBeans;
        IEJB3 ejb3 = this.getEjbJarDeployableMetadata().getEjb3();
        HashMap ejbNameClasses = new HashMap();
        if (ejb3 != null && (enterpriseBeans = ejb3.getEnterpriseBeans()) != null) {
            sessionList = enterpriseBeans.getSessionList();
            i$2 = sessionList.iterator();
            while (i$2.hasNext()) {
                session = (ISession)i$2.next();
                ejbName2 = session.getEjbName();
                ejbClass2 = session.getEjbClass();
                if (ejbName2 == null || "".equals(ejbName2) || ejbClass2 == null || "".equals(ejbClass2)) continue;
                ejbNameClasses.put(ejbName2, ejbClass2);
            }
            List<IMessageDriven> mdbList = enterpriseBeans.getMessageDrivenList();
            i$ = mdbList.iterator();
            while (i$.hasNext()) {
                IMessageDriven mdb = (IMessageDriven)i$.next();
                ejbName = mdb.getEjbName();
                ejbClass = mdb.getEjbClass();
                if (ejbName == null || "".equals(ejbName) || ejbClass == null || "".equals(ejbClass)) continue;
                ejbNameClasses.put(ejbName, ejbClass);
            }
        }
        Iterator i$3 = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataCollection().iterator();
        while (i$3.hasNext()) {
            IEjbJarClassMetadata classMetadata = (IEjbJarClassMetadata)i$3.next();
            if (!classMetadata.isBean()) continue;
            String ejbName3 = classMetadata.getJCommonBean().getName();
            String ejbClass3 = classMetadata.getClassName();
            String existingEjbClassForEJBName = (String)ejbNameClasses.get(ejbName3);
            if (existingEjbClassForEJBName != null && !ejbClass3.equals(existingEjbClassForEJBName)) continue;
            this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName3, ejbClass3);
        }
        if (ejb3 != null) {
            IAssemblyDescriptor assemblyDescriptor;
            IInterceptors interceptors;
            enterpriseBeans = ejb3.getEnterpriseBeans();
            if (enterpriseBeans != null) {
                sessionList = enterpriseBeans.getSessionList();
                i$2 = sessionList.iterator();
                while (i$2.hasNext()) {
                    session = (ISession)i$2.next();
                    ejbName2 = session.getEjbName();
                    ejbClass2 = session.getEjbClass();
                    Object classAnnotationMetadata = this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName2, ejbClass2);
                    this.applySessionBean(session, classAnnotationMetadata);
                }
                List<IMessageDriven> messageDrivenList = enterpriseBeans.getMessageDrivenList();
                i$ = messageDrivenList.iterator();
                while (i$.hasNext()) {
                    IMessageDriven messageDriven = (IMessageDriven)i$.next();
                    ejbName = messageDriven.getEjbName();
                    ejbClass = messageDriven.getEjbClass();
                    Object classAnnotationMetadata = this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName, ejbClass);
                    this.applyMessageDrivenBean(messageDriven, classAnnotationMetadata);
                }
            }
            if ((interceptors = ejb3.getInterceptors()) != null) {
                this.applyInterceptors(interceptors);
            }
            if ((assemblyDescriptor = ejb3.getAssemblyDescriptor()) != null) {
                this.mergeApplicationException(assemblyDescriptor);
                this.mergeInterceptorBinding(assemblyDescriptor);
                this.mergeContainerTransaction(assemblyDescriptor);
                this.mergeAssemblySecurity(assemblyDescriptor);
            }
        }
    }

    private void applyInterceptors(IInterceptors interceptors) {
        List<IInterceptor> interceptorList = interceptors.getInterceptorList();
        if (interceptorList != null) {
            Iterator i$ = interceptorList.iterator();
            while (i$.hasNext()) {
                IInterceptor interceptor = (IInterceptor)i$.next();
                String itCptClass = interceptor.getInterceptorClass();
                if (itCptClass == null) {
                    throw new IllegalStateException("Invalid interceptor with name '" + interceptor + "': No interceptor-class");
                }
                Object itcpMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(EjbJarMetadataMerge.encode(itCptClass));
                if (itcpMetadata == null) {
                    throw new IllegalStateException("No metadata found for class '" + itCptClass + "'.");
                }
                this.applyJndiEnvironmentRefsGroup((IEnvironment)interceptor, itcpMetadata);
            }
        }
    }

    private void applySessionBean(ISession sessionbean, C classAnnotationMetadata) {
        String encodedItf;
        String itf;
        Iterator i$;
        String localHome;
        this.applyCommonBean(sessionbean, classAnnotationMetadata);
        String sessionType = sessionbean.getSessionType();
        if (sessionType == null && !classAnnotationMetadata.isSession()) {
            throw new IllegalStateException("Missing session-type for bean '" + sessionbean + "' and no annotation in '" + classAnnotationMetadata + "'.");
        }
        if ("Stateless".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATELESS);
        } else if ("Stateful".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATEFUL);
        }
        String remoteHome = sessionbean.getRemoteHome();
        if (remoteHome != null) {
            classAnnotationMetadata.setRemoteHome(remoteHome);
        }
        if ((localHome = sessionbean.getLocalHome()) != null) {
            classAnnotationMetadata.setLocalHome(localHome);
        }
        if (sessionbean.getBusinessLocalList().size() > 0) {
            IJLocal jLocal = classAnnotationMetadata.getLocalInterfaces();
            if (jLocal == null) {
                jLocal = new JLocal();
                classAnnotationMetadata.setLocalInterfaces(jLocal);
            }
            i$ = sessionbean.getBusinessLocalList().iterator();
            while (i$.hasNext()) {
                itf = (String)i$.next();
                encodedItf = EjbJarMetadataMerge.encode(itf);
                if (jLocal.contains(encodedItf)) continue;
                jLocal.addInterface(encodedItf);
            }
        }
        if (sessionbean.getMappedName() != null) {
            IJCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
            if (jCommonBean == null) {
                throw new IllegalStateException("No JCommonBean attribute on class '" + classAnnotationMetadata.getClassName() + "' while there is a mapped name.");
            }
            jCommonBean.setMappedName(sessionbean.getMappedName());
        }
        if (sessionbean.getBusinessRemoteList().size() > 0) {
            IJRemote jRemote = classAnnotationMetadata.getRemoteInterfaces();
            if (jRemote == null) {
                jRemote = new JRemote();
                classAnnotationMetadata.setRemoteInterfaces(jRemote);
            }
            i$ = sessionbean.getBusinessRemoteList().iterator();
            while (i$.hasNext()) {
                itf = (String)i$.next();
                encodedItf = EjbJarMetadataMerge.encode(itf);
                if (jRemote.contains(encodedItf)) continue;
                jRemote.addInterface(encodedItf);
            }
        }
        if (sessionbean.getRemoveMethodList().size() > 0) {
            if (!classAnnotationMetadata.isStateful()) {
                throw new IllegalStateException("Cannot apply XML DD remove methods on a bean which is not a stateful bean. Bean class is '" + classAnnotationMetadata.getClassName() + "'. Remove Methods are '" + sessionbean.getRemoveMethodList() + "'.");
            }
            Iterator i$2 = sessionbean.getRemoveMethodList().iterator();
            while (i$2.hasNext()) {
                IRemoveMethod removeMethod = (IRemoveMethod)i$2.next();
                IMethodDD method = removeMethod.getMethod();
                List<M> methods = this.getMethodsForGivenMethodDD(method, classAnnotationMetadata);
                if (methods.size() == 0) {
                    logger.warn("No method found for the remove-method ''{0}'' on the class ''{1}''", method, classAnnotationMetadata.getClassName());
                } else if (methods.size() > 1) {
                    logger.warn("Found more than 1 method for the remove-method ''{0}'' on the class ''{1}''.All these methods will be set as remove methods.", method, classAnnotationMetadata.getClassName());
                }
                Iterator i$3 = methods.iterator();
                while (i$3.hasNext()) {
                    IEjbJarMethodMetadata methodAnnotationMetadata = (IEjbJarMethodMetadata)i$3.next();
                    Remove previousRemove = methodAnnotationMetadata.getJRemove();
                    Boolean retainXML = removeMethod.getRetainIfException();
                    boolean retain = false;
                    if (retainXML != null) {
                        retain = retainXML;
                    } else if (previousRemove != null) {
                        retain = previousRemove.retainIfException();
                    }
                    JRemove jRemove = new JRemove(retain);
                    methodAnnotationMetadata.setRemove(jRemove);
                }
            }
        }
    }

    private void applyMessageDrivenBean(IMessageDriven messageDrivenBean, C classAnnotationMetadata) {
        this.applyCommonBean(messageDrivenBean, classAnnotationMetadata);
        if (messageDrivenBean.getMessageDestinationType() != null) {
            ActivationConfig activationConfig = new ActivationConfig();
            messageDrivenBean.addActivationConfig(activationConfig);
            activationConfig.setName("destinationType");
            activationConfig.setValue(messageDrivenBean.getMessageDestinationType());
        }
        classAnnotationMetadata.setClassType(ClassType.MDB);
        IJMessageDriven jMessageDriven = classAnnotationMetadata.getJMessageDriven();
        if (jMessageDriven == null) {
            jMessageDriven = new JMessageDriven();
            classAnnotationMetadata.setJMessageDriven(jMessageDriven);
        }
        List<IActivationConfig> activationConfigList = messageDrivenBean.getActivationConfigList();
        Iterator i$ = activationConfigList.iterator();
        while (i$.hasNext()) {
            IActivationConfig activationConfig = (IActivationConfig)i$.next();
            JActivationConfigProperty actProperty = new JActivationConfigProperty(activationConfig.getName(), activationConfig.getValue());
            jMessageDriven.addActivationConfigProperty(actProperty);
        }
        jMessageDriven.setMessageDestinationLink(messageDrivenBean.getMessageDestinationLink());
    }

    private void applyCommonBean(IBean bean, C classAnnotationMetadata) {
        String runAsRole;
        if (classAnnotationMetadata.getJCommonBean() == null) {
            classAnnotationMetadata.setJCommonBean(new JCommonBean());
        }
        IJCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
        jCommonBean.setName(bean.getEjbName());
        if (bean.getMappedName() != null) {
            jCommonBean.setMappedName(bean.getMappedName());
        }
        if ((runAsRole = bean.getRunAsRole()) != null) {
            classAnnotationMetadata.setRunAs(runAsRole);
        }
        classAnnotationMetadata.setSecurityRoleRefList(bean.getSecurityRoleRefList());
        String transactionType = bean.getTransactionType();
        if (transactionType != null) {
            if ("Bean".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.BEAN);
            } else if ("Container".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.CONTAINER);
            } else {
                throw new IllegalStateException("Invalid transaction type '" + transactionType + "' found");
            }
        }
        this.applyJndiEnvironmentRefsGroup((IEnvironment)bean, classAnnotationMetadata);
    }

    protected void applyJndiEnvironmentRefsGroup(IEnvironment envGroup, C classAnnotationMetadata) {
        this.applyLifeCycle(envGroup.getPostConstructCallbackList(), classAnnotationMetadata, "post-construct");
        this.applyLifeCycle(envGroup.getPreDestroyCallbackList(), classAnnotationMetadata, "pre-destroy");
        this.applyLifeCycle(envGroup.getPrePassivateCallbackList(), classAnnotationMetadata, "pre-passivate");
        this.applyLifeCycle(envGroup.getPostActivateCallbackList(), classAnnotationMetadata, "post-activate");
        this.applyAroundInvoke(envGroup.getAroundInvokeList(), classAnnotationMetadata, "around-invoke");
        this.applyEjbRef(envGroup.getEJBRefList(), classAnnotationMetadata);
        this.applyEjbLocalRef(envGroup.getEJBLocalRefList(), classAnnotationMetadata);
        this.applyResourceRef(envGroup.getResourceRefList(), classAnnotationMetadata);
        this.applyResourceEnvRef(envGroup.getResourceEnvRefList(), classAnnotationMetadata);
        this.applyEnvEntry(envGroup.getEnvEntryList(), classAnnotationMetadata);
        this.applyPersistenceUnitRef(envGroup.getPersistenceUnitRefList(), classAnnotationMetadata);
        this.applyPersistenceContextRef(envGroup.getPersistenceContextRefList(), classAnnotationMetadata);
        this.applyMessageDestinationRef(envGroup.getMessageDestinationRefList(), classAnnotationMetadata);
        this.applyServiceRef(envGroup.getServiceRefList(), classAnnotationMetadata);
        this.applyHandlerChain(classAnnotationMetadata);
    }

    protected void applyEnvEntry(List<IEnvEntry> envEntryList, C classAnnotationMetadata) {
        if (envEntryList == null) {
            return;
        }
        ArrayList structEnvEntryList = new ArrayList();
        Iterator i$ = envEntryList.iterator();
        while (i$.hasNext()) {
            IEnvEntry envEntry = (IEnvEntry)i$.next();
            EnvEntry builtEntry = new EnvEntry(envEntry.getEnvEntryName(), envEntry.getEnvEntryType(), envEntry.getEnvEntryValue());
            structEnvEntryList.add(builtEntry);
            List<IInjectionTarget> injectionTargetList = envEntry.getInjectionTargetList();
            if (injectionTargetList == null) continue;
            Iterator i$2 = injectionTargetList.iterator();
            while (i$2.hasNext()) {
                IInjectionTarget injectionTarget = (IInjectionTarget)i$2.next();
                if (envEntry.getEnvEntryValue() == null) continue;
                JAnnotationResource jResource = new JAnnotationResource();
                jResource.setName(envEntry.getEnvEntryName());
                jResource.setType(envEntry.getEnvEntryType());
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource(jResource);
            }
        }
        classAnnotationMetadata.setEnvEntryCollection(structEnvEntryList);
    }

    protected void applyServiceRef(List<IServiceRef> serviceRefList, C classAnnotationMetadata) {
        if (serviceRefList == null) {
            return;
        }
        Iterator i$ = serviceRefList.iterator();
        while (i$.hasNext()) {
            IServiceRef serviceRef = (IServiceRef)i$.next();
            List<IInjectionTarget> injectionTargetList = serviceRef.getInjectionTargetList();
            if (injectionTargetList != null && injectionTargetList.size() > 0) {
                Iterator i$2 = injectionTargetList.iterator();
                while (i$2.hasNext()) {
                    IInjectionTarget target = (IInjectionTarget)i$2.next();
                    ISharedMetadata sharedMetadata = this.getInjectionTarget(classAnnotationMetadata, target);
                    IJaxwsWebServiceRef wsr = sharedMetadata.getJaxwsWebServiceRef();
                    if (wsr != null) {
                        this.mergeWebServiceRef(serviceRef, wsr);
                        continue;
                    }
                    sharedMetadata.setJaxwsWebServiceRef(this.createJaxwsWebServiceRefFromXML(serviceRef));
                }
                continue;
            }
            String name = serviceRef.getName();
            List<IJaxwsWebServiceRef> metadatas = this.findJaxwsWebServiceRefMetadata(classAnnotationMetadata, name);
            if (metadatas.isEmpty()) {
                IJaxwsWebServiceRef existing = classAnnotationMetadata.getJaxwsWebServiceRef();
                ArrayList webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs();
                if (webServiceRefs == null) {
                    webServiceRefs = new ArrayList();
                    classAnnotationMetadata.setJaxwsWebServiceRefs(webServiceRefs);
                }
                if (existing != null) {
                    webServiceRefs.add(existing);
                    classAnnotationMetadata.setJaxwsWebServiceRef(null);
                }
                webServiceRefs.add(this.createJaxwsWebServiceRefFromXML(serviceRef));
                continue;
            }
            if (metadatas.size() > 1) {
                throw new IllegalStateException("Too many matching WebServiceRef metadata for '" + name + "' service-ref of class '" + classAnnotationMetadata.getClassName() + "'");
            }
            this.mergeWebServiceRef(serviceRef, (IJaxwsWebServiceRef)metadatas.get(0));
        }
    }

    private List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(C classAnnotationMetadata, String name) {
        Collection methodMetadatas;
        Collection fieldMetadatas;
        List<IJaxwsWebServiceRef> webServiceRefs;
        ArrayList elements = new ArrayList();
        IJaxwsWebServiceRef classAnnotation = classAnnotationMetadata.getJaxwsWebServiceRef();
        if (classAnnotation != null && name.equals(classAnnotation.getName())) {
            elements.add(classAnnotation);
        }
        if ((webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs()) != null) {
            Iterator i$ = webServiceRefs.iterator();
            while (i$.hasNext()) {
                IJaxwsWebServiceRef ref = (IJaxwsWebServiceRef)i$.next();
                if (!name.equals(ref.getName())) continue;
                elements.add(ref);
            }
        }
        if ((fieldMetadatas = classAnnotationMetadata.getStandardFieldMetadataCollection()) != null) {
            Iterator i$ = fieldMetadatas.iterator();
            while (i$.hasNext()) {
                IEjbJarFieldMetadata fieldMetadata = (IEjbJarFieldMetadata)i$.next();
                this.addJaxwsWebServiceRefIfFound(fieldMetadata, name, elements);
            }
        }
        if ((methodMetadatas = classAnnotationMetadata.getStandardMethodMetadataCollection()) != null) {
            Iterator i$ = methodMetadatas.iterator();
            while (i$.hasNext()) {
                IEjbJarMethodMetadata methodMetadata = (IEjbJarMethodMetadata)i$.next();
                this.addJaxwsWebServiceRefIfFound(methodMetadata, name, elements);
            }
        }
        return elements;
    }

    private void applyMessageDestinationRef(List<IMessageDestinationRef> messageDestinationRefList, C classAnnotationMetadata) {
        if (messageDestinationRefList == null) {
            return;
        }
        Iterator i$ = messageDestinationRefList.iterator();
        while (i$.hasNext()) {
            IMessageDestinationRef messageDestinationRef = (IMessageDestinationRef)i$.next();
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(messageDestinationRef.getName());
            jResource.setType(messageDestinationRef.getType());
            jResource.setMappedName(messageDestinationRef.getMappedName());
            jResource.setMessageDestinationLink(messageDestinationRef.getLink());
            this.applyJResource(jResource, classAnnotationMetadata, messageDestinationRef.getInjectionTargetList());
        }
    }

    private void applyResourceRef(List<IResourceRef> resourceRefList, C classAnnotationMetadata) {
        if (resourceRefList == null) {
            return;
        }
        Iterator i$ = resourceRefList.iterator();
        while (i$.hasNext()) {
            IResourceRef resourceRef = (IResourceRef)i$.next();
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceRef.getResRefName());
            jResource.setType(resourceRef.getResRefType());
            jResource.setMappedName(resourceRef.getMappedName());
            this.applyJResource(jResource, classAnnotationMetadata, resourceRef.getInjectionTargetList());
        }
    }

    private void applyResourceEnvRef(List<IResourceEnvRef> resourceEnvRefList, C classAnnotationMetadata) {
        if (resourceEnvRefList == null) {
            return;
        }
        Iterator i$ = resourceEnvRefList.iterator();
        while (i$.hasNext()) {
            IResourceEnvRef resourceEnvRef = (IResourceEnvRef)i$.next();
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceEnvRef.getResourceEnvRefName());
            jResource.setType(resourceEnvRef.getResourceEnvRefType());
            jResource.setMappedName(resourceEnvRef.getMappedName());
            this.applyJResource(jResource, classAnnotationMetadata, resourceEnvRef.getInjectionTargetList());
        }
    }

    private void applyPersistenceUnitRef(List<IPersistenceUnitRef> persistenceUnitRefList, C classAnnotationMetadata) {
        if (persistenceUnitRefList == null) {
            return;
        }
        Iterator i$ = persistenceUnitRefList.iterator();
        while (i$.hasNext()) {
            IPersistenceUnitRef persistenceUnitRef = (IPersistenceUnitRef)i$.next();
            JavaxPersistenceUnit jPersistenceUnit = new JavaxPersistenceUnit();
            jPersistenceUnit.setName(persistenceUnitRef.getPersistenceUnitRefName());
            jPersistenceUnit.setUnitName(persistenceUnitRef.getPersistenceUnitName());
            this.applyJPersistenceUnit(jPersistenceUnit, classAnnotationMetadata, persistenceUnitRef.getInjectionTargetList());
        }
    }

    private void applyPersistenceContextRef(List<IPersistenceContextRef> persistenceContextRefList, C classAnnotationMetadata) {
        if (persistenceContextRefList == null) {
            return;
        }
        Iterator i$ = persistenceContextRefList.iterator();
        while (i$.hasNext()) {
            IPersistenceContextRef persistenceContextRef = (IPersistenceContextRef)i$.next();
            JavaxPersistenceContext jPersistenceContext = new JavaxPersistenceContext();
            jPersistenceContext.setName(persistenceContextRef.getPersistenceContextRefName());
            jPersistenceContext.setUnitName(persistenceContextRef.getPersistenceUnitName());
            String type = persistenceContextRef.getPersistenceUnitName();
            if (PersistenceContextType.TRANSACTION.toString().equals(type)) {
                jPersistenceContext.setType(PersistenceContextType.TRANSACTION);
            } else if (PersistenceContextType.EXTENDED.toString().equals(type)) {
                jPersistenceContext.setType(PersistenceContextType.EXTENDED);
            }
            this.applyJPersistenceContext(jPersistenceContext, classAnnotationMetadata, persistenceContextRef.getInjectionTargetList());
        }
    }

    protected void applyJPersistenceUnit(JavaxPersistenceUnit jPersistenceUnit, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJavaxPersistenceUnit existingJPersistentUnit = classAnnotationMetadata.getJavaxPersistenceUnit();
        ArrayList jPersistentUnits = classAnnotationMetadata.getJavaxPersistencePersistenceUnits();
        if (jPersistentUnits == null) {
            jPersistentUnits = new ArrayList();
            classAnnotationMetadata.setJavaxPersistencePersistenceUnits(jPersistentUnits);
        }
        if (existingJPersistentUnit != null) {
            jPersistentUnits.add(existingJPersistentUnit);
            classAnnotationMetadata.setJavaxPersistenceUnit(null);
        }
        jPersistentUnits.add(jPersistenceUnit);
        if (injectionTargetList != null) {
            Iterator i$ = injectionTargetList.iterator();
            while (i$.hasNext()) {
                IInjectionTarget injectionTarget = (IInjectionTarget)i$.next();
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJavaxPersistenceUnit(jPersistenceUnit);
            }
        }
    }

    protected void applyJPersistenceContext(JavaxPersistenceContext jPersistenceContext, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJavaxPersistenceContext existingJPersistentContext = classAnnotationMetadata.getJavaxPersistenceContext();
        ArrayList jPersistentContexts = classAnnotationMetadata.getJavaxPersistencePersistenceContexts();
        if (jPersistentContexts == null) {
            jPersistentContexts = new ArrayList();
            classAnnotationMetadata.setJavaxPersistencePersistenceContexts(jPersistentContexts);
        }
        if (existingJPersistentContext != null) {
            jPersistentContexts.add(existingJPersistentContext);
            classAnnotationMetadata.setJavaxPersistenceContext(null);
        }
        jPersistentContexts.add(jPersistenceContext);
        if (injectionTargetList != null) {
            Iterator i$ = injectionTargetList.iterator();
            while (i$.hasNext()) {
                IInjectionTarget injectionTarget = (IInjectionTarget)i$.next();
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJavaxPersistenceContext(jPersistenceContext);
            }
        }
    }

    private void applyEjbRef(List<IEJBRef> ejbRefList, C classAnnotationMetadata) {
        if (ejbRefList == null) {
            return;
        }
        Iterator i$ = ejbRefList.iterator();
        while (i$.hasNext()) {
            IEJBRef ejbRef = (IEJBRef)i$.next();
            JEjbEJB jEJB = EjbJarMetadataMerge.buildEJB(ejbRef);
            if (ejbRef.getHome() != null) {
                jEJB.setBeanInterface(ejbRef.getHome());
            } else if (ejbRef.getRemote() != null) {
                jEJB.setBeanInterface(ejbRef.getRemote());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbRef.getInjectionTargetList());
        }
    }

    private void applyEjbLocalRef(List<IEJBLocalRef> ejbLocalRefList, C classAnnotationMetadata) {
        if (ejbLocalRefList == null) {
            return;
        }
        Iterator i$ = ejbLocalRefList.iterator();
        while (i$.hasNext()) {
            IEJBLocalRef ejbLocalRef = (IEJBLocalRef)i$.next();
            JEjbEJB jEJB = EjbJarMetadataMerge.buildEJB(ejbLocalRef);
            if (ejbLocalRef.getLocalHome() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocalHome());
            } else if (ejbLocalRef.getLocal() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocal());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbLocalRef.getInjectionTargetList());
        }
    }

    protected void applyJResource(JAnnotationResource jResource, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJAnnotationResource existingJResource = classAnnotationMetadata.getJAnnotationResource();
        ArrayList jResources = classAnnotationMetadata.getJAnnotationResources();
        if (jResources == null) {
            jResources = new ArrayList();
            classAnnotationMetadata.setJAnnotationResources(jResources);
        }
        if (existingJResource != null) {
            jResources.add(existingJResource);
            classAnnotationMetadata.setJAnnotationResource(null);
        }
        IJAnnotationResource resourceToUse = null;
        Iterator i$ = jResources.iterator();
        while (i$.hasNext()) {
            IJAnnotationResource currentResource = (IJAnnotationResource)i$.next();
            if (!jResource.getName().equals(currentResource.getName())) continue;
            resourceToUse = currentResource;
        }
        if (resourceToUse != null) {
            if (jResource.getMappedName() != null && !"".equals(jResource.getMappedName())) {
                resourceToUse.setMappedName(jResource.getMappedName());
            }
        } else {
            jResources.add(jResource);
            resourceToUse = jResource;
        }
        if (injectionTargetList != null) {
            i$ = injectionTargetList.iterator();
            while (i$.hasNext()) {
                IInjectionTarget injectionTarget = (IInjectionTarget)i$.next();
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource(resourceToUse);
            }
        }
    }

    protected ISharedMetadata getInjectionTarget(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String injectionTargetName = injectionTarget.getTargetName();
        M method = this.getMethod(classAnnotationMetadata, injectionTarget);
        if (method != null) {
            return method;
        }
        F field = this.getField(classAnnotationMetadata, injectionTarget);
        if (field == null) {
            throw new IllegalArgumentException("No method or field for injection target name '" + injectionTargetName + "' found in the class '" + classAnnotationMetadata.getClassName() + "'.");
        }
        return field;
    }

    protected M getMethod(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace((CharSequence)".", (CharSequence)"/");
        String methodName = injectionTarget.getTargetName();
        Object foundClassMetadata = classAnnotationMetadata.getLinkedClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List methods = foundClassMetadata.searchStandardMethodMetadata(methodName);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException("Too many methods with name '" + methodName + "' found in the class '" + clName + "'.");
        }
        return (M)((IEjbJarMethodMetadata)methods.get(0));
    }

    protected F getField(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace((CharSequence)".", (CharSequence)"/");
        String fieldName = injectionTarget.getTargetName();
        Object foundClassMetadata = classAnnotationMetadata.getLinkedClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List fields = foundClassMetadata.searchStandardFieldMetadata(fieldName);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Too many fields with name '" + fieldName + "' found in the class '" + clName + "'.");
        }
        return (F)((IEjbJarFieldMetadata)fields.get(0));
    }

    protected void applyJEJB(JEjbEJB jEJB, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJEjbEJB existingJEjbEJB = classAnnotationMetadata.getJEjbEJB();
        ArrayList jEjbEJBs = classAnnotationMetadata.getJEjbEJBs();
        if (jEjbEJBs == null) {
            jEjbEJBs = new ArrayList();
            classAnnotationMetadata.setJEjbEJBs(jEjbEJBs);
        }
        if (existingJEjbEJB != null) {
            jEjbEJBs.add(existingJEjbEJB);
            classAnnotationMetadata.setJEjbEJB(null);
        }
        jEjbEJBs.add(jEJB);
        if (injectionTargetList != null) {
            Iterator i$ = injectionTargetList.iterator();
            while (i$.hasNext()) {
                IInjectionTarget injectionTarget = (IInjectionTarget)i$.next();
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJEjbEJB(jEJB);
            }
        }
    }

    private static JEjbEJB buildEJB(ICommonEJBRef ref) {
        JEjbEJB jEJB = new JEjbEJB();
        if (ref.getEjbRefName() != null) {
            jEJB.setName(ref.getEjbRefName());
        }
        if (ref.getMappedName() != null) {
            jEJB.setMappedName(ref.getMappedName());
        }
        if (ref.getEjbLink() != null) {
            jEJB.setBeanName(ref.getEjbLink());
        }
        return jEJB;
    }

    private void applyAroundInvoke(List<IAroundInvoke> aroundInvokeList, C classAnnotationMetadata, String type) {
        Iterator i$ = aroundInvokeList.iterator();
        while (i$.hasNext()) {
            IAroundInvoke aroundInvoke = (IAroundInvoke)i$.next();
            String interceptorClassName = null;
            interceptorClassName = aroundInvoke.getClassName() == null ? classAnnotationMetadata.getClassName() : EjbJarMetadataMerge.encode(aroundInvoke.getClassName());
            String searchMethodName = aroundInvoke.getMethodName();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void applyLifeCycle(List<ILifeCycleCallback> lifecycleList, C classAnnotationMetadata, String type) {
        Iterator i$ = lifecycleList.iterator();
        while (i$.hasNext()) {
            ILifeCycleCallback lifecycleCallback = (ILifeCycleCallback)i$.next();
            String interceptorClassName = null;
            interceptorClassName = lifecycleCallback.getLifecycleCallbackClass() == null ? classAnnotationMetadata.getClassName() : EjbJarMetadataMerge.encode(lifecycleCallback.getLifecycleCallbackClass());
            String searchMethodName = lifecycleCallback.getLifecycleCallbackMethod();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void addInterceptorForClass(C classAnnotationMetadata, String interceptorClassName) {
        IJInterceptors interceptors = classAnnotationMetadata.getAnnotationInterceptors();
        if (interceptors == null) {
            interceptors = new JInterceptors();
            classAnnotationMetadata.setAnnotationsInterceptors(interceptors);
        }
        if (!interceptors.contains(interceptorClassName)) {
            interceptors.addClass(interceptorClassName);
        }
    }

    private void applyInterceptor(String type, String interceptorClassName, String methodName, C classAnnotationMetadata) {
        ArrayList superClassesOfBean = new ArrayList();
        C beanClassMetadata = classAnnotationMetadata;
        String superClassBeanName = beanClassMetadata.getClassName();
        while (!superClassBeanName.equals(JAVA_LANG_OBJECT)) {
            superClassesOfBean.add(superClassBeanName);
            beanClassMetadata = beanClassMetadata.getLinkedClassMetadata(superClassBeanName);
            superClassBeanName = beanClassMetadata.getSuperName();
        }
        if (classAnnotationMetadata != null && !superClassesOfBean.contains(interceptorClassName)) {
            this.addInterceptorForClass(classAnnotationMetadata, interceptorClassName);
        }
        ICommonMethodMetadata foundMethod = null;
        Object interceptorMetadata = classAnnotationMetadata.getLinkedClassMetadata(interceptorClassName);
        boolean loop = true;
        while (foundMethod == null && loop) {
            List listMethods = interceptorMetadata.searchStandardMethodMetadata(methodName);
            if (listMethods.size() == 1) {
                foundMethod = (IEjbJarMethodMetadata)listMethods.get(0);
                continue;
            }
            if (listMethods.size() > 1) {
                throw new IllegalStateException("Method with name '" + methodName + "' was found more than once on the class '" + interceptorMetadata.getClassName() + "'.");
            }
            String superClassName = interceptorMetadata.getSuperName();
            if (!superClassName.equals(JAVA_LANG_OBJECT)) {
                interceptorMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(superClassName);
                continue;
            }
            loop = false;
        }
        if (foundMethod == null) {
            throw new IllegalStateException("The method named '" + methodName + "' was not found in the class '" + interceptorMetadata.getClassName() + "' and all its super-classes.");
        }
        if ("post-construct".equals(type)) {
            if (!foundMethod.isPostConstruct()) {
                foundMethod.setPostConstruct(true);
            }
        } else if ("pre-destroy".equals(type)) {
            if (!foundMethod.isPreDestroy()) {
                foundMethod.setPreDestroy(true);
            }
        } else if ("pre-passivate".equals(type)) {
            if (!foundMethod.isPrePassivate()) {
                foundMethod.setPrePassivate(true);
            }
        } else if ("post-activate".equals(type)) {
            if (!foundMethod.isPostActivate()) {
                foundMethod.setPostActivate(true);
            }
        } else if ("around-invoke".equals(type)) {
            if (!foundMethod.isAroundInvoke()) {
                foundMethod.setAroundInvoke(true);
            }
        } else {
            throw new IllegalStateException("No case for type '" + type + "'..");
        }
    }

    public void mergeApplicationException(IAssemblyDescriptor assemblyDescriptor) {
        List<IApplicationException> assemblyDescriptorList = assemblyDescriptor.getApplicationExceptionList();
        if (assemblyDescriptorList != null) {
            Iterator i$ = assemblyDescriptorList.iterator();
            while (i$.hasNext()) {
                IApplicationException applicationException = (IApplicationException)i$.next();
                String className = applicationException.getClassName();
                Object exceptionMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(EjbJarMetadataMerge.encode(className));
                if (exceptionMetadata == null) {
                    throw new IllegalStateException("The class named '" + className + "' was not found. Cannot set ApplicationException on it");
                }
                exceptionMetadata.setApplicationException(applicationException);
                logger.debug("Setting the application-exception ''{0}'' on the class ''{1}''", applicationException, className);
            }
        }
    }

    public void mergeAssemblySecurity(IAssemblyDescriptor assemblyDescriptor) {
        Iterator i$;
        List<String> securityRoles = assemblyDescriptor.getSecurityRoleList();
        Iterator i$2 = securityRoles.iterator();
        while (i$2.hasNext()) {
            String role = (String)i$2.next();
            i$ = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataCollection().iterator();
            while (i$.hasNext()) {
                IEjbJarClassMetadata beanMetadata = (IEjbJarClassMetadata)i$.next();
                if (!beanMetadata.isBean()) continue;
                ArrayList declaredRoles = beanMetadata.getDeclareRoles();
                if (declaredRoles == null) {
                    declaredRoles = new ArrayList();
                }
                if (declaredRoles.contains(role)) continue;
                declaredRoles.add(role);
                beanMetadata.setDeclareRoles(declaredRoles);
            }
        }
        List<IMethodPermission> methodPermissionList = assemblyDescriptor.getMethodPermissionList();
        Iterator i$3 = methodPermissionList.iterator();
        while (i$3.hasNext()) {
            IMethodPermission methodPermission = (IMethodPermission)i$3.next();
            List<IMethodDD> methodDDs = methodPermission.getMethods();
            Iterator i$4 = methodDDs.iterator();
            while (i$4.hasNext()) {
                IMethodDD method = (IMethodDD)i$4.next();
                String ejbName = method.getEjbName();
                Object beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / method-permission");
                }
                List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
                Iterator i$5 = methods.iterator();
                while (i$5.hasNext()) {
                    IEjbJarMethodMetadata methodAnnotationMetadata = (IEjbJarMethodMetadata)i$5.next();
                    if (methodPermission.isUnchecked()) {
                        methodAnnotationMetadata.setPermitAll(true);
                        continue;
                    }
                    if (methodPermission.getRoleNameList().size() <= 0) continue;
                    Iterator i$6 = methodPermission.getRoleNameList().iterator();
                    while (i$6.hasNext()) {
                        String role = (String)i$6.next();
                        ArrayList existingRolesAllowed = methodAnnotationMetadata.getRolesAllowed();
                        if (existingRolesAllowed == null) {
                            existingRolesAllowed = new ArrayList();
                        }
                        if (existingRolesAllowed.contains(role)) continue;
                        existingRolesAllowed.add(role);
                        methodAnnotationMetadata.setRolesAllowed(existingRolesAllowed);
                    }
                }
            }
        }
        List<IMethodDD> excludeMethodList = assemblyDescriptor.getExcludeListMethods();
        i$ = excludeMethodList.iterator();
        while (i$.hasNext()) {
            IMethodDD method = (IMethodDD)i$.next();
            String ejbName = method.getEjbName();
            Object beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
            if (beanMetadata == null) {
                throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / exclude-list");
            }
            List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
            Iterator i$7 = methods.iterator();
            while (i$7.hasNext()) {
                IEjbJarMethodMetadata methodAnnotationMetadata = (IEjbJarMethodMetadata)i$7.next();
                methodAnnotationMetadata.setDenyAll(true);
            }
        }
    }

    public void mergeContainerTransaction(IAssemblyDescriptor assemblyDescriptor) {
        List<IContainerTransaction> containerTransactionList = assemblyDescriptor.getContainerTransactionList();
        if (containerTransactionList == null) {
            return;
        }
        Iterator i$ = containerTransactionList.iterator();
        while (i$.hasNext()) {
            IContainerTransaction containerTransaction = (IContainerTransaction)i$.next();
            TransactionAttributeType transactionAttributeType = containerTransaction.getTransactionAttribute();
            if (transactionAttributeType == null) continue;
            Iterator i$2 = containerTransaction.getMethods().iterator();
            while (i$2.hasNext()) {
                IMethodDD method = (IMethodDD)i$2.next();
                String ejbName = method.getEjbName();
                Object beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of a container transaction");
                }
                String methodName = method.getName();
                TransactionAttributeLevel txlevel = TransactionAttributeLevel.XML_WILDCARD;
                if (WILDCARD.equals(methodName)) {
                    Iterator i$3 = beanMetadata.getStandardMethodMetadataCollection().iterator();
                    while (i$3.hasNext()) {
                        IEjbJarMethodMetadata methodAnnotationMetadata = (IEjbJarMethodMetadata)i$3.next();
                        if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION) continue;
                        methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                        methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                        logger.debug("Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, transactionAttributeType});
                    }
                    continue;
                }
                List<String> params = method.getParams();
                txlevel = params.size() == 0 ? TransactionAttributeLevel.XML_METHOD_NAME : TransactionAttributeLevel.XML_METHOD_PARAMS;
                List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
                if (methods.size() == 0) {
                    throw new IllegalStateException("No matching method found with '" + method + "' for bean '" + ejbName + "'.");
                }
                Iterator i$4 = methods.iterator();
                while (i$4.hasNext()) {
                    IEjbJarMethodMetadata methodAnnotationMetadata = (IEjbJarMethodMetadata)i$4.next();
                    if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION && methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.XML_WILDCARD || (txlevel != TransactionAttributeLevel.XML_METHOD_NAME || methodAnnotationMetadata.getTransactionAttributeLevel() == TransactionAttributeLevel.XML_METHOD_PARAMS) && txlevel != TransactionAttributeLevel.XML_METHOD_PARAMS) continue;
                    methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                    methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                    logger.debug("Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, txlevel});
                }
            }
        }
    }

    public void mergeInterceptorBinding(IAssemblyDescriptor assemblyDescriptor) {
        List<IInterceptorBinding> interceptorBindingList = assemblyDescriptor.getInterceptorBindingList();
        if (interceptorBindingList != null) {
            Iterator i$ = interceptorBindingList.iterator();
            while (i$.hasNext()) {
                Iterator i$2;
                IInterceptorBinding interceptorBinding = (IInterceptorBinding)i$.next();
                String ejbName = interceptorBinding.getEjbName();
                if (WILDCARD.equals(ejbName)) {
                    IJInterceptors defaultInterceptors = this.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses();
                    if (defaultInterceptors == null) {
                        defaultInterceptors = new JInterceptors();
                        this.getEjbJarDeployableMetadata().setDefaultInterceptorsClasses(defaultInterceptors);
                    }
                    Iterator i$3 = interceptorBinding.getInterceptorClassList().iterator();
                    while (i$3.hasNext()) {
                        String interceptor = (String)i$3.next();
                        defaultInterceptors.addClass(EjbJarMetadataMerge.encode(interceptor));
                    }
                    continue;
                }
                Object beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from an interceptor-binding");
                }
                IMethodDD methodDD = interceptorBinding.getMethod();
                if (methodDD == null) {
                    Iterator i$4;
                    List<String> orderList;
                    IJInterceptors interceptors = beanMetadata.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        beanMetadata.setAnnotationsInterceptors(interceptors);
                    }
                    i$2 = interceptorBinding.getInterceptorClassList().iterator();
                    while (i$2.hasNext()) {
                        String interceptor = (String)i$2.next();
                        interceptors.addClass(EjbJarMetadataMerge.encode(interceptor));
                    }
                    if (interceptorBinding.isExcludeDefaultInterceptorsCalled()) {
                        beanMetadata.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                    }
                    if ((orderList = interceptorBinding.getOrderInterceptorClassList()) == null) continue;
                    if (beanMetadata.isOrderedInterceptors()) {
                        throw new IllegalStateException("The interceptor-order element has already been used on the bean '" + ejbName + "'. It can only be used once.");
                    }
                    beanMetadata.setOrderedInterceptors(true);
                    if (!beanMetadata.isExcludedDefaultInterceptors() && beanMetadata.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses() != null) {
                        i$4 = beanMetadata.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses().getClasses().iterator();
                        while (i$4.hasNext()) {
                            String cls = (String)i$4.next();
                            interceptors.addClass(cls);
                        }
                    }
                    i$4 = interceptorBinding.getOrderInterceptorClassList().iterator();
                    while (i$4.hasNext()) {
                        String interceptor = (String)i$4.next();
                        String encodedName = EjbJarMetadataMerge.encode(interceptor);
                        if (interceptors.contains(encodedName)) continue;
                        interceptors.addClass(encodedName);
                    }
                    if (interceptors.size() != orderList.size()) {
                        String err = "The list used for ordering interceptors is not a total list as the size mismatch.";
                        err = err + "The current list is '" + interceptors + "' while the ordering list is '" + orderList + "'.";
                        throw new IllegalStateException(err);
                    }
                    i$4 = orderList.iterator();
                    while (i$4.hasNext()) {
                        String clazz = (String)i$4.next();
                        if (interceptors.contains(EjbJarMetadataMerge.encode(clazz))) continue;
                        throw new IllegalStateException("The element '" + clazz + "' of the ordered list is not present in the interceptors '" + interceptors + "'.");
                    }
                    JInterceptors orderedInterceptors = new JInterceptors();
                    Iterator i$5 = orderList.iterator();
                    while (i$5.hasNext()) {
                        String clazz = (String)i$5.next();
                        orderedInterceptors.addClass(EjbJarMetadataMerge.encode(clazz));
                    }
                    beanMetadata.setAnnotationsInterceptors(orderedInterceptors);
                    continue;
                }
                List<M> methods = this.getMethodsForGivenMethodDD(methodDD, beanMetadata);
                if (methods.size() == 0) {
                    logger.warn("Method with name '" + methodDD.getName() + "' is specified in interceptorBinding element for class '" + beanMetadata.getClassName() + "' but no methods are matching", new Object[0]);
                }
                i$2 = methods.iterator();
                while (i$2.hasNext()) {
                    IEjbJarMethodMetadata method = (IEjbJarMethodMetadata)i$2.next();
                    IJInterceptors interceptors = method.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        method.setAnnotationsInterceptors(interceptors);
                    }
                    Iterator i$6 = interceptorBinding.getInterceptorClassList().iterator();
                    while (i$6.hasNext()) {
                        String interceptor = (String)i$6.next();
                        interceptors.addClass(EjbJarMetadataMerge.encode(interceptor));
                    }
                    if (interceptorBinding.isExcludeClassInterceptorsCalled()) {
                        method.setExcludeClassInterceptors(interceptorBinding.isExcludeClassInterceptors());
                    }
                    if (!interceptorBinding.isExcludeDefaultInterceptorsCalled()) continue;
                    method.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                }
            }
        }
    }

    protected List<M> getMethodsForGivenMethodDD(IMethodDD methodDD, C classAnnotationMetadata) {
        String methodName = methodDD.getName();
        HashMap beanMethods = new HashMap();
        String superClassName = classAnnotationMetadata.getClassName();
        while (!JAVA_LANG_OBJECT.equals(superClassName)) {
            Object superClassAnnotationMetadata = classAnnotationMetadata.getLinkedClassMetadata(superClassName);
            List findingMethods = superClassAnnotationMetadata.searchStandardMethodMetadata(methodName);
            Iterator i$ = findingMethods.iterator();
            while (i$.hasNext()) {
                IEjbJarMethodMetadata method = (IEjbJarMethodMetadata)i$.next();
                if (beanMethods.containsKey(method.getJMethod())) continue;
                beanMethods.put(method.getJMethod(), method);
            }
            superClassName = superClassAnnotationMetadata.getSuperName();
        }
        ArrayList methods = new ArrayList(beanMethods.values());
        List<String> params = methodDD.getParams();
        if (params != null && params.size() > 0) {
            ArrayList newMethods = new ArrayList();
            Iterator i$ = methods.iterator();
            while (i$.hasNext()) {
                IEjbJarMethodMetadata method = (IEjbJarMethodMetadata)i$.next();
                Type[] types = Type.getArgumentTypes(method.getJMethod().getDescriptor());
                if (params.size() != types.length) continue;
                int i = 0;
                boolean matching = false;
                Iterator i$2 = params.iterator();
                while (i$2.hasNext()) {
                    String param = (String)i$2.next();
                    if (param.equals(types[i].getClassName())) {
                        matching = true;
                    }
                    ++i;
                }
                if (!matching) continue;
                newMethods.add(method);
            }
            methods = newMethods;
        }
        return methods;
    }

    protected void applyHandlerChain(C classAnnotationMetadata) {
        IJwsHandlerChain handlerChain = classAnnotationMetadata.getJwsHandlerChain();
        List<IJaxwsWebServiceRef> references = classAnnotationMetadata.getJaxwsWebServiceRefs();
        if (handlerChain != null && references != null && !references.isEmpty()) {
            Iterator i$ = references.iterator();
            while (i$.hasNext()) {
                IJaxwsWebServiceRef reference = (IJaxwsWebServiceRef)i$.next();
                reference.setHandlerChainFile(handlerChain.getFile());
                String classname = EjbJarMetadataMerge.decode(classAnnotationMetadata.getJClass().getName());
                reference.setDeclaringClass(classname);
            }
        }
        Collection allMethodMetadata = classAnnotationMetadata.getStandardMethodMetadataCollection();
        Iterator i$ = allMethodMetadata.iterator();
        while (i$.hasNext()) {
            ICommonMethodMetadata metadata = (ICommonMethodMetadata)i$.next();
            IJwsHandlerChain jwsHandlerChain = metadata.getJwsHandlerChain();
            IJaxwsWebServiceRef reference = metadata.getJaxwsWebServiceRef();
            if (jwsHandlerChain == null || reference == null) continue;
            reference.setHandlerChainFile(jwsHandlerChain.getFile());
            String classname = EjbJarMetadataMerge.decode(metadata.getClassMetadata().getJClass().getName());
            reference.setDeclaringClass(classname);
        }
        Collection allFieldMetadatas = classAnnotationMetadata.getStandardFieldMetadataCollection();
        Iterator i$2 = allFieldMetadatas.iterator();
        while (i$2.hasNext()) {
            ICommonFieldMetadata metadata = (ICommonFieldMetadata)i$2.next();
            IJwsHandlerChain jwsHandlerChain = metadata.getJwsHandlerChain();
            IJaxwsWebServiceRef reference = metadata.getJaxwsWebServiceRef();
            if (jwsHandlerChain == null || reference == null) continue;
            reference.setHandlerChainFile(jwsHandlerChain.getFile());
            String classname = EjbJarMetadataMerge.decode(metadata.getClassMetadata().getJClass().getName());
            reference.setDeclaringClass(classname);
        }
    }
}

