/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xml;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaEntityResolver
implements EntityResolver {
    private Map<String, String> schemasUrls = new HashMap();
    private Map<String, String> dtdsUrls = new HashMap();

    public SchemaEntityResolver(String[] schemas) {
        this(schemas, null, null);
    }

    public SchemaEntityResolver(String[] schemas, String[] dtdPublicIds, String[] dtdsFileNames) {
        URL url = null;
        for (int i = 0; i < schemas.length; ++i) {
            url = this.getURL(schemas[i]);
            String urlString = url.toString();
            String id = urlString.substring(urlString.lastIndexOf(47) + 1);
            this.schemasUrls.put((Object)id, (Object)urlString);
        }
        this.addDtds(dtdPublicIds, dtdsFileNames);
    }

    protected void addDtds(String[] dtdPublicIds, String[] dtdsFileNames) {
        if (dtdPublicIds != null && dtdsFileNames != null && dtdPublicIds.length == dtdsFileNames.length) {
            for (int i = 0; i < dtdPublicIds.length; ++i) {
                String publicId = dtdPublicIds[i];
                String localURL = this.getURL(dtdsFileNames[i]).toString();
                this.dtdsUrls.put((Object)publicId, (Object)localURL);
            }
        }
    }

    protected URL getURL(String resourceName) {
        URL url = this.getClass().getResource("/" + resourceName);
        if (url == null) {
            throw new IllegalStateException("'" + resourceName + "' was not found in the current classloader !");
        }
        return url;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String localPath = null;
        if (publicId != null) {
            localPath = (String)this.dtdsUrls.get((Object)publicId);
        } else if (systemId != null && systemId.toLowerCase().endsWith(".xsd")) {
            String baseName = systemId.substring(systemId.lastIndexOf(47) + 1);
            localPath = (String)this.schemasUrls.get((Object)baseName);
        }
        if (localPath == null) {
            if (publicId != null) {
                throw new SAXException("No DTD found for '" + publicId + "'.");
            }
            throw new SAXException("No XSD found for '" + systemId + "'.");
        }
        return new InputSource(localPath);
    }
}

