/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xmlconfig.mapping;

import java.net.URL;
import java.util.List;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.EmptyEntityResolver;
import org.ow2.util.xml.XMLUtils;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.mapping.AttributeMapping;
import org.ow2.util.xmlconfig.mapping.ClassMapping;
import org.ow2.util.xmlconfig.mapping.XMLMapping;
import org.ow2.util.xmlconfig.ns.MappingResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class XMLMappingBuilder {
    private static final String PACKAGE_ELEMENT = "package";
    private static final String CLASS_ELEMENT = "class";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private URL mappingURL = null;
    private XMLMapping xmlMapping = null;
    private boolean validating = !Boolean.getBoolean("xmlconfig.validating.disable");

    public XMLMappingBuilder(URL mappingURL) {
        this.mappingURL = mappingURL;
        this.xmlMapping = new XMLMapping();
    }

    @Deprecated
    public XMLMappingBuilder(String nameSpace, URL mappingURL) {
        this(mappingURL);
    }

    public void build() throws XMLConfigurationException {
        Document xmlMappingConfigurationDocument = null;
        try {
            xmlMappingConfigurationDocument = this.validating ? DocumentParser.getDocument(this.mappingURL, true, (EntityResolver)new MappingResolver()) : DocumentParser.getDocument(this.mappingURL, false, (EntityResolver)new EmptyEntityResolver());
        }
        catch (DocumentParserException e) {
            throw new XMLConfigurationException("Cannot get a document on the given url '" + this.mappingURL + "'.", e);
        }
        Element rootMappingElement = xmlMappingConfigurationDocument.getDocumentElement();
        NodeList packageList = rootMappingElement.getElementsByTagName(PACKAGE_ELEMENT);
        for (int i = 0; i < packageList.getLength(); ++i) {
            Element packageElement = (Element)packageList.item(i);
            String packageName = XMLUtils.getAttributeValue(packageElement, "name");
            NodeList classList = packageElement.getElementsByTagName(CLASS_ELEMENT);
            this.addClassMapping(classList, packageName + ".", true);
        }
        NodeList classList = rootMappingElement.getElementsByTagName(CLASS_ELEMENT);
        this.addClassMapping(classList, "", false);
    }

    private void addClassMapping(NodeList classList, String packageName, boolean packageParent) {
        for (int c = 0; c < classList.getLength(); ++c) {
            Element classElement = (Element)classList.item(c);
            if (classElement.getParentNode().getNodeName().equals(PACKAGE_ELEMENT) && !packageParent) continue;
            ClassMapping classMapping = new ClassMapping();
            String name = XMLUtils.getAttributeValue(classElement, "name");
            String className = packageName + name;
            classMapping.setName(className);
            String alias = XMLUtils.getAttributeValue(classElement, "alias");
            classMapping.getAliases().add((Object)alias);
            NodeList aliasesList = classElement.getElementsByTagName("aliases");
            if (aliasesList.getLength() > 0) {
                List<String> aliases = XMLUtils.getStringListValueElement((Element)aliasesList.item(0), "alias");
                classMapping.getAliases().addAll(aliases);
            }
            String elementAttribute = XMLUtils.getAttributeValue(classElement, "element-attribute");
            classMapping.setElementAttribute(elementAttribute);
            NodeList attributeList = classElement.getElementsByTagName(ATTRIBUTE_ELEMENT);
            for (int a = 0; a < attributeList.getLength(); ++a) {
                String isOptional;
                String isListElementName;
                String isElementName;
                Element attributeElement = (Element)attributeList.item(a);
                AttributeMapping attributeMapping = new AttributeMapping();
                String attributeName = XMLUtils.getAttributeValue(attributeElement, "name");
                attributeMapping.setName(attributeName);
                String attributeAlias = XMLUtils.getAttributeValue(attributeElement, "alias");
                attributeMapping.getAliases().add((Object)attributeAlias);
                NodeList attributesAiasesList = classElement.getElementsByTagName("aliases");
                if (attributesAiasesList.getLength() > 0) {
                    List<String> aliases = XMLUtils.getStringListValueElement((Element)aliasesList.item(0), "alias");
                    attributeMapping.getAliases().addAll(aliases);
                }
                if (Boolean.parseBoolean((String)(isElementName = XMLUtils.getAttributeValue(attributeElement, "element")))) {
                    attributeMapping.setElement();
                }
                if (Boolean.parseBoolean((String)(isListElementName = XMLUtils.getAttributeValue(attributeElement, "isList")))) {
                    attributeMapping.setListElement();
                }
                if (Boolean.parseBoolean((String)(isOptional = XMLUtils.getAttributeValue(attributeElement, "optional")))) {
                    attributeMapping.setOptional();
                }
                String getter = XMLUtils.getAttributeValue(attributeElement, "getter");
                attributeMapping.setGetter(getter);
                String setter = XMLUtils.getAttributeValue(attributeElement, "setter");
                attributeMapping.setSetter(setter);
                classMapping.addAttributeMapping(attributeMapping);
            }
            this.xmlMapping.addClassMapping(classMapping);
        }
    }

    public XMLMapping getXmlMapping() {
        return this.xmlMapping;
    }
}

