/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxCnxWrapper
implements MBeanServerConnection {
    private MBeanServerConnection mbscnx = null;
    private JMXConnector jmxConnector = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private String protocolProviders = null;
    protected Log logger = LogFactory.getLog(JmxCnxWrapper.class);

    public JmxCnxWrapper(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public JmxCnxWrapper(String url, String user, String password, String providers) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.protocolProviders = providers;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, loaderName);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, loaderName, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object att = null;
        try {
            this.connect();
            att = this.mbscnx.getAttribute(name, attribute);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return att;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attl = new AttributeList();
        try {
            this.connect();
            attl = this.mbscnx.getAttributes(name, attributes);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return attl;
    }

    @Override
    public String getDefaultDomain() throws IOException {
        String domain = null;
        try {
            this.connect();
            domain = this.mbscnx.getDefaultDomain();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return domain;
    }

    @Override
    public String[] getDomains() throws IOException {
        String[] domains = null;
        try {
            this.connect();
            domains = this.mbscnx.getDomains();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return domains;
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        Integer count = null;
        try {
            this.connect();
            count = this.mbscnx.getMBeanCount();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return count;
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo mbi = null;
        try {
            this.connect();
            mbi = this.mbscnx.getMBeanInfo(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return mbi;
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.getObjectInstance(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object o = null;
        try {
            this.connect();
            o = this.mbscnx.invoke(name, operationName, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return o;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        boolean b = false;
        try {
            this.connect();
            b = this.mbscnx.isInstanceOf(name, className);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return b;
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        boolean b = false;
        try {
            this.connect();
            b = this.mbscnx.isRegistered(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return b;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        LinkedHashSet ons = null;
        try {
            this.connect();
            ons = this.mbscnx.queryMBeans(name, query);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        if (ons == null) {
            ons = new LinkedHashSet();
        }
        return ons;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        LinkedHashSet ons = null;
        try {
            this.connect();
            ons = this.mbscnx.queryNames(name, query);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        if (ons == null) {
            ons = new LinkedHashSet();
        }
        return ons;
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.connect();
            this.mbscnx.setAttribute(name, attribute);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attl = new AttributeList();
        try {
            this.connect();
            attl = this.mbscnx.setAttributes(name, attributes);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return attl;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.connect();
            this.mbscnx.unregisterMBean(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void setMBeanServerConnection(MBeanServerConnection cnx) {
        this.mbscnx = cnx;
    }

    public void connect() throws IOException {
        if (this.mbscnx == null) {
            JMXServiceURL jmxUrl;
            Map<String, String[]> env = null;
            if (this.user != null && this.password != null) {
                if (env == null) {
                    env = new HashMap<String, String>(2);
                }
                String[] creds = new String[]{this.user, this.password};
                env.put("jmx.remote.credentials", creds);
            }
            if (this.protocolProviders != null) {
                if (env == null) {
                    env = new HashMap(2);
                }
                env.put("jmx.remote.protocol.provider.pkgs", (String[])this.protocolProviders);
            }
            if ("t3".equals((jmxUrl = new JMXServiceURL(this.url)).getProtocol())) {
                env = this.setCredentialsForT3(env);
            }
            JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(this.url), env);
            this.mbscnx = c.getMBeanServerConnection();
            this.jmxConnector = c;
        }
    }

    private Map setCredentialsForT3(Map map) {
        if (!map.containsKey("java.naming.security.principal") && !map.containsKey("java.naming.security.credentials") && map.containsKey("jmx.remote.credentials")) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.putAll(map);
            String[] cred = (String[])map.get("jmx.remote.credentials");
            newMap.put("java.naming.security.principal", cred[0]);
            newMap.put("java.naming.security.credentials", cred[1]);
            return newMap;
        }
        return map;
    }

    private void analyseException(IOException e) throws IOException {
        boolean toClose = false;
        if (e instanceof ConnectException) {
            toClose = true;
        } else if (e instanceof ConnectIOException) {
            toClose = true;
        } else if (e instanceof UnknownHostException) {
            toClose = true;
        } else {
            String s = e.getMessage();
            if (s.startsWith("javax.naming.NameNotFoundException")) {
                this.logger.error("Persistent error : {0}", e.getMessage(), e);
            } else if (s.startsWith("javax.naming.ServiceUnavailableException")) {
                toClose = true;
            } else if (s.startsWith("javax.naming.ConfigurationException")) {
                toClose = true;
            }
        }
        if (toClose) {
            this.closeJMX();
        }
        throw e;
    }

    private void closeJMX() {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException e) {
                this.logger.error("Error closing connector : {0}", this.url, e);
            }
        }
        this.mbscnx = null;
    }
}

