/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

import java.awt.Dimension;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.GraphConfig;

public class GraphDisplay
extends ApplicationFrame {
    private static final long serialVersionUID = -2999008078436385027L;
    private Map series = new TreeMap();
    private boolean isShown = false;

    public GraphDisplay(GraphConfig conf) {
        super(conf.getTitle());
        String[] serieIds = conf.getSerieIds();
        for (int i = 0; i < serieIds.length; ++i) {
            this.series.put(serieIds[i], new TimeSeries(conf.getLegend(serieIds[i]), Millisecond.class));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (int i = 0; i < serieIds.length; ++i) {
            dataset.addSeries((TimeSeries)this.series.get(serieIds[i]));
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart(conf.getTitle(), null, null, dataset, true, true, false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 250));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    protected GraphDisplay(String title, String[] names) {
        super(title);
        for (int i = 0; i < names.length; ++i) {
            this.series.put(names[i], new TimeSeries(names[i], Millisecond.class));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (int i = 0; i < names.length; ++i) {
            dataset.addSeries((TimeSeries)this.series.get(names[i]));
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, null, null, dataset, true, true, false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 250));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMe() {
        boolean shown;
        GraphDisplay graphDisplay = this;
        synchronized (graphDisplay) {
            shown = this.isShown;
            if (!this.isShown) {
                this.isShown = true;
            }
        }
        if (!shown) {
            this.pack();
            RefineryUtilities.centerFrameOnScreen(this);
            RefineryUtilities.positionFrameRandomly(this);
            RefineryUtilities.positionFrameOnScreen(this, 1.0, 0.0);
            this.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String id, Second second, double value) {
        TimeSeries serie;
        TimeSeries timeSeries = serie = (TimeSeries)this.series.get(id);
        synchronized (timeSeries) {
            serie.addOrUpdate((RegularTimePeriod)second, value);
        }
        this.showMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String id, Millisecond milli, double value) {
        TimeSeries serie;
        TimeSeries timeSeries = serie = (TimeSeries)this.series.get(id);
        synchronized (timeSeries) {
            serie.addOrUpdate((RegularTimePeriod)milli, value);
        }
        this.showMe();
    }

    public void update(String id, long t, double value) {
        this.update(id, new Millisecond(new Date(t)), value);
    }

    public static void main(String[] args) {
        long startTime;
        boolean debug = false;
        boolean relativeTime = false;
        boolean visible = true;
        long delay = 2L;
        int nSeries = 2;
        int nData = 10;
        int errflg = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-d".compareTo(args[i]) == 0) {
                debug = true;
                continue;
            }
            if ("-r".compareTo(args[i]) == 0) {
                relativeTime = !relativeTime;
                continue;
            }
            if ("-v".compareTo(args[i]) == 0) {
                visible = !visible;
                continue;
            }
            if ("-s".compareTo(args[i]) == 0) {
                if (++i >= args.length) {
                    ++errflg;
                    break;
                }
                try {
                    delay = Long.parseLong(args[i]);
                }
                catch (Exception e) {
                    ++errflg;
                    break;
                }
                if (delay > 0L) continue;
                ++errflg;
                break;
            }
            if ("-n".compareTo(args[i]) == 0) {
                if (++i >= args.length) {
                    ++errflg;
                    break;
                }
                try {
                    nSeries = Integer.parseInt(args[i]);
                }
                catch (Exception e) {
                    ++errflg;
                    break;
                }
                if (nSeries >= 1 && nSeries <= 9) continue;
                ++errflg;
                break;
            }
            if ("-m".compareTo(args[i]) == 0) {
                if (++i >= args.length) {
                    ++errflg;
                    break;
                }
                try {
                    nData = Integer.parseInt(args[i]);
                }
                catch (Exception e) {
                    ++errflg;
                    break;
                }
                if (nData >= 2) continue;
                ++errflg;
                break;
            }
            ++errflg;
        }
        if (errflg > 0) {
            System.out.println("Usage: TimeSeriesDemo [-d] [-r] [-v] [-s delay] [-n series] [-m data]\n       -d        : debug\n       -r        : relative time\n       -v        : visible window at end of data only\n       -s delay  : update delay (min 1 second)\n       -n series : number of series (1 to 9)\n       -m data   : number of generated data\n");
            System.exit(2);
        }
        if (debug) {
            System.err.print("+ TimeSeriesDemo -d");
            if (relativeTime) {
                System.err.print(" -r");
            }
            if (!visible) {
                System.err.print(" -v");
            }
            if (delay > 0L) {
                System.err.print(" -s " + delay);
            }
            System.err.print(" -n " + nSeries);
            System.err.print(" -m " + nData);
            System.err.println();
        }
        String[] name = new String[nSeries];
        for (int i = 0; i < nSeries; ++i) {
            name[i] = "Series" + (i + 1);
        }
        GraphDisplay demo = new GraphDisplay("Series", name);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        RefineryUtilities.positionFrameRandomly(demo);
        RefineryUtilities.positionFrameOnScreen(demo, 1.0, 0.0);
        if (visible) {
            demo.setVisible(true);
        }
        System.out.print("seconds");
        for (int i = 0; i < nSeries; ++i) {
            System.out.print("\t" + name[i]);
        }
        System.out.println();
        Random random = new Random();
        long nextTime = startTime = System.currentTimeMillis();
        block11: for (int m = 0; m < nData; ++m) {
            long sleepTime;
            int i;
            double[] value = new double[nSeries];
            int i2 = 0;
            while (i2 < nSeries) {
                value[i2] = random.nextInt((i2 + 1) * 100);
                int n = i2++;
                value[n] = value[n] / 10.0;
            }
            long elapsedTime = nextTime - startTime;
            long date = relativeTime ? elapsedTime : nextTime;
            Second second = new Second(new Date(date));
            String output = "" + date / 1000L;
            for (i = 0; i < nSeries; ++i) {
                output = output + "\t" + (float)value[i];
            }
            System.out.println(output);
            for (i = 0; i < nSeries; ++i) {
                demo.update(name[i], second, value[i]);
            }
            nextTime += delay * 1000L;
            if (!visible) continue;
            while ((sleepTime = nextTime - System.currentTimeMillis()) > 10L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    continue block11;
                }
            }
        }
        demo.setVisible(true);
        System.exit(0);
    }
}

