/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.MatchException;
import com.p6spy.engine.common.P6SpyOptions;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.appender.FileLogger;
import com.p6spy.engine.logging.appender.P6Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;

public class P6LogQuery {
    protected static PrintStream qlog;
    protected static String[] includeTables;
    protected static String[] excludeTables;
    protected static String[] includeCategories;
    protected static String[] excludeCategories;
    protected static String lastStack;
    protected static P6Logger logger;

    public static synchronized void initMethod() {
        String appender = P6SpyOptions.getAppender();
        if (appender == null) {
            appender = "com.p6spy.engine.logging.appender.FileLogger";
        }
        try {
            logger = (P6Logger)P6Util.forName(appender).newInstance();
        }
        catch (Exception e1) {
            try {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                logger = (P6Logger)loader.loadClass(appender).newInstance();
            }
            catch (Exception e) {
                System.err.println("Cannot instantiate " + appender + ", even on second attempt.  Logging to file log4jaux.log: " + e);
            }
        }
        if (logger != null && logger instanceof FileLogger) {
            String logfile = P6SpyOptions.getLogfile();
            logfile = logfile == null ? "spy.log" : logfile;
            ((FileLogger)logger).setLogfile(logfile);
        }
        if (P6SpyOptions.getFilter()) {
            includeTables = P6LogQuery.parseCSVList(P6SpyOptions.getInclude());
            excludeTables = P6LogQuery.parseCSVList(P6SpyOptions.getExclude());
        }
        includeCategories = P6LogQuery.parseCSVList(P6SpyOptions.getIncludecategories());
        excludeCategories = P6LogQuery.parseCSVList(P6SpyOptions.getExcludecategories());
    }

    public static PrintStream logPrintStream(String file) {
        PrintStream ps = null;
        try {
            String path = P6Util.classPathFile(file);
            file = path == null ? file : path;
            ps = P6Util.getPrintStream(file, P6SpyOptions.getAppend());
        }
        catch (IOException io) {
            P6LogQuery.logError("Error opening " + file + ", " + io.getMessage());
            ps = null;
        }
        return ps;
    }

    static String[] parseCSVList(String csvList) {
        String[] array = null;
        if (csvList != null) {
            StringTokenizer tok = new StringTokenizer(csvList, ",");
            ArrayList list = new ArrayList();
            while (tok.hasMoreTokens()) {
                String item = tok.nextToken().toLowerCase().trim();
                if (item == "") continue;
                list.add(item.toLowerCase().trim());
            }
            int max = list.size();
            Iterator it = list.iterator();
            array = new String[max];
            int i = 0;
            while (i < max) {
                array[i] = (String)it.next();
                ++i;
            }
        }
        return array;
    }

    protected static void doLog(long elapsed, String category, String prepared, String sql) {
        P6LogQuery.doLog(-1, elapsed, category, prepared, sql);
    }

    protected static void doLogElapsed(int connectionId, long startTime, long endTime, String category, String prepared, String sql) {
        P6LogQuery.doLog(connectionId, endTime - startTime, category, prepared, sql);
    }

    protected static synchronized void doLog(int connectionId, long elapsed, String category, String prepared, String sql) {
        if (logger != null) {
            Date now = P6Util.timeNow();
            SimpleDateFormat sdf = P6SpyOptions.getDateformatter();
            String stringNow = sdf == null ? Long.toString(now.getTime()) : sdf.format(new Date(now.getTime())).trim();
            logger.logSQL(connectionId, stringNow, elapsed, category, prepared, sql);
            boolean stackTrace = P6SpyOptions.getStackTrace();
            String stackTraceClass = P6SpyOptions.getStackTraceClass();
            if (stackTrace) {
                Exception e = new Exception();
                if (stackTraceClass != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String stack = sw.toString();
                    if (stack.indexOf(stackTraceClass) != -1) {
                        lastStack = stack;
                    } else {
                        e = null;
                    }
                }
                if (e != null) {
                    logger.logException(e);
                }
            }
        }
    }

    static boolean isLoggable(String sql) {
        return !P6SpyOptions.getFilter() || P6LogQuery.queryOk(sql);
    }

    static boolean isCategoryOk(String category) {
        return (includeCategories == null || includeCategories.length == 0 || P6LogQuery.foundCategory(category, includeCategories)) && !P6LogQuery.foundCategory(category, excludeCategories);
    }

    static boolean foundCategory(String category, String[] categories) {
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (category.equals(categories[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static boolean queryOk(String sql) {
        if (P6SpyOptions.getStringMatcherEngine() != null && P6SpyOptions.getSQLExpression() != null) {
            return P6LogQuery.sqlOk(sql);
        }
        return (includeTables == null || includeTables.length == 0 || P6LogQuery.foundTable(sql, includeTables)) && !P6LogQuery.foundTable(sql, excludeTables);
    }

    static boolean sqlOk(String sql) {
        String sqlexpression = P6SpyOptions.getSQLExpression();
        try {
            return P6SpyOptions.getStringMatcherEngine().match(sqlexpression, sql);
        }
        catch (MatchException e) {
            P6LogQuery.logError("Exception during matching sqlexpression [" + sqlexpression + "] to sql [" + sql + "]: ");
            return false;
        }
    }

    static boolean foundTable(String sql, String[] tables) {
        sql = sql.toLowerCase();
        boolean ok = false;
        if (tables != null) {
            int i = 0;
            while (!ok && i < tables.length) {
                ok = P6LogQuery.tableOk(sql, tables[i]);
                ++i;
            }
        }
        return ok;
    }

    static boolean tableOk(String sql, String table) {
        try {
            return P6SpyOptions.getStringMatcherEngine().match(table, sql);
        }
        catch (MatchException e) {
            P6LogQuery.logError("Exception during matching expression [" + table + "] to sql [" + sql + "]: ");
            return false;
        }
    }

    public static void clearLastStack() {
        lastStack = null;
    }

    public static String getLastEntry() {
        return logger.getLastEntry();
    }

    public static String getLastStack() {
        return lastStack;
    }

    public static String[] getIncludeTables() {
        return includeTables;
    }

    public static String[] getExcludeTables() {
        return excludeTables;
    }

    public static void setIncludeTables(String _includeTables) {
        includeTables = P6LogQuery.parseCSVList(_includeTables);
    }

    public static void setExcludeTables(String _excludeTables) {
        excludeTables = P6LogQuery.parseCSVList(_excludeTables);
    }

    public static void setIncludeCategories(String _includeCategories) {
        includeCategories = P6LogQuery.parseCSVList(_includeCategories);
    }

    public static void setExcludeCategories(String _excludeCategories) {
        excludeCategories = P6LogQuery.parseCSVList(_excludeCategories);
    }

    public static void logText(String text) {
        logger.logText(text);
    }

    public static void log(String category, String prepared, String sql) {
        if (logger != null) {
            P6LogQuery.doLog(-1L, category, prepared, sql);
        }
    }

    public static void logElapsed(int connectionId, long startTime, String category, String prepared, String sql) {
        P6LogQuery.logElapsed(connectionId, startTime, System.currentTimeMillis(), category, prepared, sql);
    }

    public static void logElapsed(int connectionId, long startTime, long endTime, String category, String prepared, String sql) {
        if (logger != null && P6LogQuery.meetsThresholdRequirement(endTime - startTime) && P6LogQuery.isLoggable(sql) && P6LogQuery.isCategoryOk(category)) {
            P6LogQuery.doLogElapsed(connectionId, startTime, endTime, category, prepared, sql);
        } else if (P6LogQuery.isDebugOn()) {
            P6LogQuery.logDebug("P6Spy intentionally did not log category: " + category + ", statement: " + sql + "  Reason: logger=" + logger + ", isLoggable=" + P6LogQuery.isLoggable(sql) + ", isCategoryOk=" + P6LogQuery.isCategoryOk(category));
        }
    }

    private static boolean meetsThresholdRequirement(long timeTaken) {
        long executionThreshold = P6SpyOptions.getExecutionThreshold();
        if (executionThreshold <= 0L) {
            return true;
        }
        return timeTaken > executionThreshold;
    }

    public static void logInfo(String sql) {
        if (logger != null && P6LogQuery.isCategoryOk("info")) {
            P6LogQuery.doLog(-1L, "info", "", sql);
        }
    }

    public static boolean isDebugOn() {
        return P6LogQuery.isCategoryOk("debug");
    }

    public static void logDebug(String sql) {
        if (P6LogQuery.isDebugOn()) {
            if (logger != null) {
                P6LogQuery.doLog(-1L, "debug", "", sql);
            } else {
                System.err.println(sql);
            }
        }
    }

    public static void logError(String sql) {
        System.err.println("Warning: " + sql);
        if (logger != null) {
            P6LogQuery.doLog(-1L, "error", "", sql);
        }
    }

    static {
        P6LogQuery.initMethod();
    }
}

