/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String NAVIGATION_RULE = "navigation-rule";
    private static final String FROM_VIEW_ID = "from-view-id";
    private static final String NAVIGATION_CASE = "navigation-case";
    private static final String FROM_ACTION = "from-action";
    private static final String FROM_OUTCOME = "from-outcome";
    private static final String TO_VIEW_ID = "to-view-id";
    private static final String REDIRECT = "redirect";
    private static final String FROM_VIEW_ID_DEFAULT = "*";

    @Override
    public void process(Document[] documents) throws Exception {
        for (Document document : documents) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation-rule elements for document: ''{0}''", new Object[]{document.getDocumentURI()}));
            }
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList navigationRules = document.getDocumentElement().getElementsByTagNameNS(namespace, NAVIGATION_RULE);
            if (navigationRules == null || navigationRules.getLength() <= 0) continue;
            this.addNavigationRules(navigationRules);
        }
        this.invokeNext(documents);
    }

    private void addNavigationRules(NodeList navigationRules) throws XPathExpressionException {
        int size = navigationRules.getLength();
        for (int i = 0; i < size; ++i) {
            Node navigationRule = navigationRules.item(i);
            if (navigationRule.getNodeType() != 1) continue;
            NodeList children = navigationRule.getChildNodes();
            String fromViewId = FROM_VIEW_ID_DEFAULT;
            List navigationCases = null;
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (n.getNodeType() != 1) continue;
                if (FROM_VIEW_ID.equals(n.getLocalName())) {
                    String t = this.getNodeText(n);
                    String string = fromViewId = t == null ? FROM_VIEW_ID_DEFAULT : t;
                    if (fromViewId.equals(FROM_VIEW_ID_DEFAULT) || fromViewId.charAt(0) == '/') continue;
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "jsf.config.navigation.from_view_id_leading_slash", new String[]{fromViewId});
                    }
                    fromViewId = '/' + fromViewId;
                    continue;
                }
                if (!NAVIGATION_CASE.equals(n.getLocalName())) continue;
                if (navigationCases == null) {
                    navigationCases = new ArrayList(csize);
                }
                navigationCases.add(n);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing navigation rule with 'from-view-id' of ''{0}''", new Object[]{fromViewId}));
            }
            this.addNavigationCasesForRule(fromViewId, navigationCases);
        }
    }

    private void addNavigationCasesForRule(String fromViewId, List<Node> navigationCases) {
        if (navigationCases != null && !navigationCases.isEmpty()) {
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            Iterator i$ = navigationCases.iterator();
            while (i$.hasNext()) {
                Node navigationCase = (Node)i$.next();
                if (navigationCase.getNodeType() != 1) continue;
                NodeList children = navigationCase.getChildNodes();
                String outcome = null;
                String action = null;
                String toViewId = null;
                boolean redirect = false;
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    Node n = children.item(i);
                    if (n.getNodeType() != 1) continue;
                    if (FROM_OUTCOME.equals(n.getLocalName())) {
                        outcome = this.getNodeText(n);
                        continue;
                    }
                    if (FROM_ACTION.equals(n.getLocalName())) {
                        action = this.getNodeText(n);
                        continue;
                    }
                    if (TO_VIEW_ID.equals(n.getLocalName())) {
                        toViewId = this.getNodeText(n);
                        if (toViewId.charAt(0) == '/') continue;
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, "jsf.config.navigation.to_view_id_leading_slash", new String[]{toViewId, fromViewId});
                        }
                        toViewId = '/' + toViewId;
                        continue;
                    }
                    if (!REDIRECT.equals(n.getLocalName())) continue;
                    redirect = true;
                }
                ConfigNavigationCase cnc = new ConfigNavigationCase(fromViewId, action, outcome, toViewId, redirect);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding NavigationCase: {0}", new Object[]{cnc.toString()}));
                }
                associate.addNavigationCase(cnc);
            }
        }
    }
}

