/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

public class LifecycleImpl
extends Lifecycle {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private Phase response = new RenderResponsePhase();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase(), this.response};
    private List<PhaseListener> listeners = new CopyOnWriteArrayList<PhaseListener>();

    public void execute(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("execute(" + context + ")");
        }
        int len = this.phases.length - 1;
        for (int i = 1; i < len && !context.getRenderResponse() && !context.getResponseComplete(); ++i) {
            this.phases[i].doPhase(context, this, this.listeners.listIterator());
        }
    }

    public void render(FacesContext context) throws FacesException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("render(" + context + ")");
        }
        if (!context.getResponseComplete()) {
            this.response.doPhase(context, this, this.listeners.listIterator());
        }
    }

    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<PhaseListener>();
        }
        if (this.listeners.contains((Object)listener)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.lifecycle.duplicate_phase_listener_detected", listener.getClass().getName());
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "addPhaseListener({0},{1})", new Object[]{listener.getPhaseId().toString(), listener.getClass().getName()});
            }
            this.listeners.add((Object)listener);
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return (PhaseListener[])this.listeners.toArray((Object[])new PhaseListener[this.listeners.size()]);
    }

    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners.remove((Object)listener) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "removePhaseListener({0})", new Object[]{listener.getClass().getName()});
        }
    }
}

