/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Timer timer;
        PhaseEvent event = null;
        if (listeners.hasNext()) {
            event = new PhaseEvent(context, this.getId(), lifecycle);
        }
        if ((timer = Timer.getInstance()) != null) {
            timer.startTiming();
        }
        this.handleBeforePhase(context, listeners, event);
        Exception ex = null;
        try {
            if (!this.shouldSkip(context)) {
                this.execute(context);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "jsf.lifecycle.phase.exception", new Object[]{this.getId().toString(), context.getViewRoot() != null ? context.getViewRoot().getViewId() : "", event});
            }
            ex = e;
        }
        finally {
            this.handleAfterPhase(context, listeners, event);
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Execution time for phase (including any PhaseListeners) -> " + this.getId().toString());
            }
        }
        if (ex != null) {
            if (!(ex instanceof FacesException)) {
                ex = new FacesException(ex);
            }
            throw (FacesException)ex;
        }
    }

    public abstract void execute(FacesContext var1) throws FacesException;

    public abstract PhaseId getId();

    protected void handleAfterPhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        while (listenersIterator.hasPrevious()) {
            PhaseListener listener = (PhaseListener)listenersIterator.previous();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.afterPhase(event);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "jsf.lifecycle.phaselistener.exception", new Object[]{listener.getClass().getName() + ".afterPhase()", this.getId().toString(), context.getViewRoot() != null ? context.getViewRoot().getViewId() : "", e});
                LOGGER.warning(Util.getStackTraceString(e));
                return;
            }
        }
    }

    protected void handleBeforePhase(FacesContext context, ListIterator<PhaseListener> listenersIterator, PhaseEvent event) {
        while (listenersIterator.hasNext()) {
            PhaseListener listener = (PhaseListener)listenersIterator.next();
            if (!this.getId().equals(listener.getPhaseId()) && !PhaseId.ANY_PHASE.equals(listener.getPhaseId())) continue;
            try {
                listener.beforePhase(event);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.lifecycle.phaselistener.exception", new Object[]{listener.getClass().getName() + ".beforePhase()", this.getId().toString(), context.getViewRoot() != null ? context.getViewRoot().getViewId() : "", e});
                    LOGGER.warning(Util.getStackTraceString(e));
                }
                if (listenersIterator.hasPrevious()) {
                    listenersIterator.previous();
                }
                return;
            }
        }
    }

    private boolean shouldSkip(FacesContext context) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse() && !PhaseId.RENDER_RESPONSE.equals(this.getId());
    }
}

