/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedCollections {
    private static boolean checkCollectionMembers(Collection<?> c, Class<?> type) {
        Iterator i$ = c.iterator();
        while (i$.hasNext()) {
            Object element = i$.next();
            if (element == null || type.isInstance(element)) continue;
            return false;
        }
        return true;
    }

    public static <E, TypedC extends Collection<E>> TypedC dynamicallyCastCollection(Collection<?> c, Class<E> type, Class<TypedC> collectionType) {
        if (c == null) {
            return null;
        }
        if (!collectionType.isInstance(c)) {
            throw new ClassCastException(c.getClass().getName());
        }
        assert (TypedCollections.checkCollectionMembers(c, type)) : "The collection contains members with a type other than " + type.getName();
        return (TypedC)((Collection)collectionType.cast(c));
    }

    public static <E> List<E> dynamicallyCastList(List<?> list, Class<E> type) {
        return TypedCollections.dynamicallyCastCollection(list, type, List.class);
    }

    public static <E> Set<E> dynamicallyCastSet(Set<?> set, Class<E> type) {
        return TypedCollections.dynamicallyCastCollection(set, type, Set.class);
    }

    public static <K, V> Map<K, V> dynamicallyCastMap(Map<?, ?> map, Class<K> keyType, Class<V> valueType) {
        if (map == null) {
            return null;
        }
        assert (TypedCollections.checkCollectionMembers(map.keySet(), keyType)) : "The map contains keys with a type other than " + keyType.getName();
        assert (TypedCollections.checkCollectionMembers(map.values(), valueType)) : "The map contains values with a type other than " + valueType.getName();
        return map;
    }
}

