/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeELResolver
extends ELResolver {
    private final ArrayList<ELResolver> elResolvers = new ArrayList();

    public void add(ELResolver elResolver) {
        if (elResolver == null) {
            throw new NullPointerException();
        }
        this.elResolvers.add((Object)elResolver);
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            Object value = elResolver.getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return value;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            Class<?> type = elResolver.getType(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return type;
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            elResolver.setValue(context, base, property, val);
            if (!context.isPropertyResolved()) continue;
            return;
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int len = this.elResolvers.size();
        for (int i = 0; i < len; ++i) {
            ELResolver elResolver = (ELResolver)this.elResolvers.get(i);
            boolean readOnly = elResolver.isReadOnly(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return readOnly;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return new CompositeIterator(this.elResolvers.iterator(), context, base);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        Class<?> commonPropertyType = null;
        Iterator iter = this.elResolvers.iterator();
        while (iter.hasNext()) {
            ELResolver elResolver = (ELResolver)iter.next();
            Class<?> type = elResolver.getCommonPropertyType(context, base);
            if (type == null) continue;
            if (commonPropertyType == null) {
                commonPropertyType = type;
                continue;
            }
            if (commonPropertyType.isAssignableFrom(type)) continue;
            if (type.isAssignableFrom(commonPropertyType)) {
                commonPropertyType = type;
                continue;
            }
            return null;
        }
        return commonPropertyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeIterator
    implements Iterator<FeatureDescriptor> {
        Iterator<ELResolver> compositeIter;
        Iterator<FeatureDescriptor> propertyIter;
        ELContext context;
        Object base;

        CompositeIterator(Iterator<ELResolver> iter, ELContext context, Object base) {
            this.compositeIter = iter;
            this.context = context;
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            if (this.propertyIter == null || !this.propertyIter.hasNext()) {
                while (this.compositeIter.hasNext()) {
                    ELResolver elResolver = (ELResolver)this.compositeIter.next();
                    this.propertyIter = elResolver.getFeatureDescriptors(this.context, this.base);
                    if (this.propertyIter == null) continue;
                    return this.propertyIter.hasNext();
                }
                return false;
            }
            return this.propertyIter.hasNext();
        }

        @Override
        public FeatureDescriptor next() {
            if (this.propertyIter == null || !this.propertyIter.hasNext()) {
                while (this.compositeIter.hasNext()) {
                    ELResolver elResolver = (ELResolver)this.compositeIter.next();
                    this.propertyIter = elResolver.getFeatureDescriptors(this.context, this.base);
                    if (this.propertyIter == null) continue;
                    return (FeatureDescriptor)this.propertyIter.next();
                }
                return null;
            }
            return (FeatureDescriptor)this.propertyIter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

