/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.MessageFactory;
import javax.faces.component.SelectItemsIterator;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class UISelectMany
extends UIInput {
    public static final String COMPONENT_TYPE = "javax.faces.SelectMany";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectMany";
    public static final String INVALID_MESSAGE_ID = "javax.faces.component.UISelectMany.INVALID";

    public UISelectMany() {
        this.setRendererType("javax.faces.Listbox");
    }

    public String getFamily() {
        return "javax.faces.SelectMany";
    }

    public Object[] getSelectedValues() {
        return (Object[])this.getValue();
    }

    public void setSelectedValues(Object[] selectedValues) {
        this.setValue(selectedValues);
    }

    public ValueBinding getValueBinding(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueBinding("value");
        }
        return super.getValueBinding(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("selectedValues".equals(name)) {
            super.setValueBinding("value", binding);
        } else {
            super.setValueBinding(name, binding);
        }
    }

    public ValueExpression getValueExpression(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("selectedValues".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null && value != null) {
            return true;
        }
        if (previous != null && value == null) {
            return true;
        }
        if (previous == null) {
            return false;
        }
        boolean valueChanged = false;
        if (!(previous instanceof Object[])) {
            previous = UISelectMany.toObjectArray(previous);
        }
        if (!(value instanceof Object[])) {
            value = UISelectMany.toObjectArray(value);
        }
        if (!(previous instanceof Object[]) || !(value instanceof Object[])) {
            return false;
        }
        Object[] oldarray = previous;
        Object[] newarray = value;
        if (oldarray.length != newarray.length) {
            return true;
        }
        for (int i = 0; i < oldarray.length; ++i) {
            int count2;
            int count1 = UISelectMany.countElementOccurrence(oldarray[i], oldarray);
            if (count1 == (count2 = UISelectMany.countElementOccurrence(oldarray[i], newarray))) continue;
            valueChanged = true;
            break;
        }
        return valueChanged;
    }

    private static int countElementOccurrence(Object element, Object[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            Object arrayElement = array[i];
            if (arrayElement == null || element == null || !arrayElement.equals(element)) continue;
            ++count;
        }
        return count;
    }

    private static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray == null) {
            throw new NullPointerException();
        }
        if (primitiveArray instanceof Object[]) {
            return (Object[])primitiveArray;
        }
        if (primitiveArray instanceof List) {
            return ((List)primitiveArray).toArray();
        }
        Class clazz = primitiveArray.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int length = Array.getLength(primitiveArray);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(primitiveArray, i);
        }
        return array;
    }

    protected void validateValue(FacesContext context, Object value) {
        SelectItemsIterator items;
        Object indexValue;
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        boolean isList = value instanceof List;
        int length = isList ? ((List)value).size() : Array.getLength(value);
        boolean found = true;
        for (int i = 0; i < length && (found = this.matchValue(indexValue = isList ? ((List)value).get(i) : Array.get(value, i), items = new SelectItemsIterator(this))); ++i) {
        }
        if (!found) {
            FacesMessage message = MessageFactory.getMessage(context, INVALID_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }

    private boolean matchValue(Object value, Iterator items) {
        while (items.hasNext()) {
            Object newValue;
            SelectItem item = (SelectItem)items.next();
            if (item instanceof SelectItemGroup) {
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (subitems == null || subitems.length <= 0 || !this.matchValue(value, new ArrayIterator(subitems))) continue;
                return true;
            }
            Class type = value.getClass();
            try {
                newValue = this.getFacesContext().getApplication().getExpressionFactory().coerceToType(item.getValue(), type);
            }
            catch (ELException ele) {
                newValue = item.getValue();
            }
            catch (IllegalArgumentException iae) {
                newValue = item.getValue();
            }
            if (!value.equals(newValue)) continue;
            return true;
        }
        return false;
    }

    static class ArrayIterator
    implements Iterator {
        private Object[] items;
        private int index = 0;

        public ArrayIterator(Object[] items) {
            this.items = items;
        }

        public boolean hasNext() {
            return this.index < this.items.length;
        }

        public Object next() {
            try {
                return this.items[this.index++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

