/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeDataSupport
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 8003518976613702244L;
    private SortedMap contents = new TreeMap();
    private CompositeType compositeType;
    private transient int m_hashcode = 0;

    public CompositeDataSupport(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        this.init(compositeType, itemNames, itemValues);
    }

    public CompositeDataSupport(CompositeType compositeType, Map items) throws OpenDataException {
        this.init(compositeType, items != null ? (String[])items.keySet().toArray(new String[items.size()]) : null, items != null ? items.values().toArray() : null);
    }

    private void init(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        if (compositeType == null) {
            throw new IllegalArgumentException("Null CompositeType is not an acceptable value");
        }
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("ItemNames cannot be null or empty (zero length)");
        }
        if (itemValues == null || itemValues.length == 0) {
            throw new IllegalArgumentException("ItemValues cannot be null or empty (zero length)");
        }
        if (itemNames.length != itemValues.length) {
            throw new IllegalArgumentException("Both the itemNames and itemValues arrays must be of equals length");
        }
        this.validateTypes(compositeType, itemNames);
        this.validateContents(compositeType, itemNames, itemValues);
        this.compositeType = compositeType;
        this.createMapData(itemNames, itemValues);
    }

    private void validateContents(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        for (int i = 0; i < itemValues.length; ++i) {
            OpenType openType;
            if (itemValues[i] == null || (openType = compositeType.getType(itemNames[i])).isValue(itemValues[i])) continue;
            throw new OpenDataException("itemValue at index " + i + " is not a valid value for itemName " + itemNames[i] + " and itemType " + openType);
        }
    }

    private void validateTypes(CompositeType compositeType, String[] itemNames) throws OpenDataException {
        for (int i = 0; i < itemNames.length; ++i) {
            if (itemNames[i] != null && !itemNames[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Value of itemName at [" + i + "] is null or empty, unacceptable values");
        }
        Set keyTypes = compositeType.keySet();
        if (itemNames.length != keyTypes.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType");
        }
        if (!Arrays.asList(itemNames).containsAll(keyTypes)) {
            throw new OpenDataException("itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
    }

    private void createMapData(String[] itemNames, Object[] itemValues) {
        for (int i = 0; i < itemNames.length; ++i) {
            this.contents.put(itemNames[i], itemValues[i]);
        }
    }

    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    public Object get(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Null or empty key");
        }
        if (!this.contents.containsKey(key.trim())) {
            throw new InvalidKeyException("Key with value " + key + " is not a current stored key in this instance");
        }
        return this.contents.get(key.trim());
    }

    public Object[] getAll(String[] keys) {
        if (keys == null || keys.length == 0) {
            return new Object[0];
        }
        Object[] dataMapValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            dataMapValues[i] = this.get(keys[i]);
        }
        return dataMapValues;
    }

    public boolean containsKey(String key) {
        if (key == null || key.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)obj;
        boolean result = this.getCompositeType().equals(compositeData.getCompositeType());
        if (result) {
            Iterator i = this.contents.entrySet().iterator();
            while (i.hasNext() && result) {
                Map.Entry entry = (Map.Entry)i.next();
                String key = (String)entry.getKey();
                Object entryvalue = entry.getValue();
                Object cdvalue = compositeData.get(key);
                if (entryvalue == null) {
                    result = cdvalue == null;
                    continue;
                }
                result = entryvalue.equals(cdvalue);
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = this.getCompositeType().hashCode();
            Iterator i = this.contents.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (entry.getValue() == null) continue;
                result += entry.getValue().hashCode();
            }
            this.m_hashcode = result;
        }
        return this.m_hashcode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("\tCompositeType = ");
        buffer.append(this.compositeType.toString());
        buffer.append("\tcontents are: ");
        buffer.append(this.contents.toString());
        return buffer.toString();
    }
}

