/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class SetUtils {
    private SetUtils() {
    }

    public static Set predicatedSet(Set set, Predicate predicate) {
        return new PredicatedSet(set, predicate);
    }

    public static SortedSet predicatedSortedSet(SortedSet sortedSet, Predicate predicate) {
        return new PredicatedSortedSet(sortedSet, predicate);
    }

    static class PredicatedSet
    extends CollectionUtils.PredicatedCollection
    implements Set {
        public PredicatedSet(Set set, Predicate predicate) {
            super(set, predicate);
        }
    }

    static class PredicatedSortedSet
    extends PredicatedSet
    implements SortedSet {
        public PredicatedSortedSet(SortedSet sortedSet, Predicate predicate) {
            super(sortedSet, predicate);
        }

        public Comparator comparator() {
            return this.getSortedSet().comparator();
        }

        public Object first() {
            return this.getSortedSet().first();
        }

        private SortedSet getSortedSet() {
            return (SortedSet)this.collection;
        }

        public SortedSet headSet(Object object) {
            SortedSet sortedSet = this.getSortedSet().headSet(object);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }

        public Object last() {
            return this.getSortedSet().last();
        }

        public SortedSet subSet(Object object, Object object2) {
            SortedSet sortedSet = this.getSortedSet().subSet(object, object2);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }

        public SortedSet tailSet(Object object) {
            SortedSet sortedSet = this.getSortedSet().tailSet(object);
            return new PredicatedSortedSet(sortedSet, this.predicate);
        }
    }
}

