/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.StringSubstitution;

public class Perl5Substitution
extends StringSubstitution {
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
    int _numInterpolations;
    ArrayList _substitutions;
    transient String _lastInterpolation;

    public Perl5Substitution() {
        this("", 0);
    }

    public Perl5Substitution(String string) {
        this(string, 0);
    }

    public Perl5Substitution(String string, int n) {
        this.setSubstitution(string, n);
    }

    void _calcSub(StringBuffer stringBuffer, MatchResult matchResult) {
        Iterator iterator = this._substitutions.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                stringBuffer.append(object);
                continue;
            }
            Integer n = (Integer)object;
            int n2 = n;
            if (n2 > 0 && n2 < matchResult.groups()) {
                String string = matchResult.group(n2);
                if (string == null) continue;
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append('$');
            stringBuffer.append(n2);
        }
    }

    String _finalInterpolatedSub(MatchResult matchResult) {
        StringBuffer stringBuffer = new StringBuffer(10);
        this._calcSub(stringBuffer, matchResult);
        return stringBuffer.toString();
    }

    static ArrayList _parseSubs(String string) {
        ArrayList arrayList = new ArrayList(5);
        StringBuffer stringBuffer = new StringBuffer(5);
        StringBuffer stringBuffer2 = new StringBuffer(10);
        char[] cArray = string.toCharArray();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (n < cArray.length) {
            if (bl && Character.isDigit(cArray[n])) {
                stringBuffer.append(cArray[n]);
                if (stringBuffer2.length() > 0) {
                    arrayList.add(stringBuffer2.toString());
                    stringBuffer2.setLength(0);
                }
            } else {
                if (bl) {
                    try {
                        arrayList.add(new Integer(stringBuffer.toString()));
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    bl = false;
                }
                if (cArray[n] == '$' && n + 1 < cArray.length && cArray[n + 1] != '0' && Character.isDigit(cArray[n + 1])) {
                    bl = true;
                } else {
                    stringBuffer2.append(cArray[n]);
                }
            }
            ++n;
        }
        if (bl) {
            try {
                arrayList.add(new Integer(stringBuffer.toString()));
                bl2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(stringBuffer.toString());
            }
        } else if (stringBuffer2.length() > 0) {
            arrayList.add(stringBuffer2.toString());
        }
        return bl2 ? arrayList : null;
    }

    public void appendSubstitution(StringBuffer stringBuffer, MatchResult matchResult, int n, String string, PatternMatcher patternMatcher, Pattern pattern) {
        if (this._substitutions == null) {
            super.appendSubstitution(stringBuffer, matchResult, n, string, patternMatcher, pattern);
            return;
        }
        if (this._numInterpolations < 1 || n < this._numInterpolations) {
            this._calcSub(stringBuffer, matchResult);
        } else {
            if (n == this._numInterpolations) {
                this._lastInterpolation = this._finalInterpolatedSub(matchResult);
            }
            stringBuffer.append(this._lastInterpolation);
        }
    }

    public void setSubstitution(String string) {
        this.setSubstitution(string, 0);
    }

    public void setSubstitution(String string, int n) {
        super.setSubstitution(string);
        this._numInterpolations = n;
        this._substitutions = n != -1 && string.indexOf(36) != -1 ? Perl5Substitution._parseSubs(string) : null;
        this._lastInterpolation = null;
    }
}

