/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class JSTLXPathNamespaceContext
implements NamespaceContext {
    HashMap namespaces;

    public JSTLXPathNamespaceContext() {
        this.namespaces = new HashMap();
    }

    public JSTLXPathNamespaceContext(HashMap nses) {
        this.namespaces = nses;
    }

    public String getNamespaceURI(String prefix) throws IllegalArgumentException {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot get Namespace URI for null prefix");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String namespaceURI = (String)this.namespaces.get(prefix);
        if (namespaceURI != null) {
            return namespaceURI;
        }
        return "";
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot get prefix for null NamespaceURI");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Iterator iter = this.namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.namespaces.get(key);
            if (!value.equals(namespaceURI)) continue;
            return value;
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Cannot get prefix for null NamespaceURI");
        }
        if (namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Arrays.asList(new String[]{"xml"}).iterator();
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Arrays.asList(new String[]{"xmlns"}).iterator();
        }
        ArrayList prefixList = new ArrayList();
        Iterator iter = this.namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this.namespaces.get(key);
            if (!value.equals(namespaceURI)) continue;
            prefixList.add(key);
        }
        return prefixList.iterator();
    }

    protected void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    private static void p(String s) {
        System.out.println("[JSTLXPathNameContext] " + s);
    }
}

