/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

class ProcessDestroyer
implements Runnable {
    private static final int TWENTY_SECONDS = 20000;
    private Vector processes = new Vector();
    private Method addShutdownHookMethod;
    private Method removeShutdownHookMethod;
    private ProcessDestroyerImpl destroyProcessThread = null;
    private boolean added = false;
    private boolean running = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    ProcessDestroyer() {
        try {
            Class[] paramTypes = new Class[]{class$java$lang$Thread == null ? (class$java$lang$Thread = ProcessDestroyer.class$("java.lang.Thread")) : class$java$lang$Thread};
            this.addShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = ProcessDestroyer.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", paramTypes);
            this.removeShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = ProcessDestroyer.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("removeShutdownHook", paramTypes);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addShutdownHook() {
        if (this.addShutdownHookMethod != null && !this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            Object[] args = new Object[]{this.destroyProcessThread};
            try {
                this.addShutdownHookMethod.invoke(Runtime.getRuntime(), args);
                this.added = true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t != null && t.getClass() == (class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = ProcessDestroyer.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException)) {
                    this.running = true;
                }
                e.printStackTrace();
            }
        }
    }

    private void removeShutdownHook() {
        if (this.removeShutdownHookMethod != null && this.added && !this.running) {
            Object[] args = new Object[]{this.destroyProcessThread};
            try {
                Boolean removed = (Boolean)this.removeShutdownHookMethod.invoke(Runtime.getRuntime(), args);
                if (!removed.booleanValue()) {
                    System.err.println("Could not remove shutdown hook");
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t != null && t.getClass() == (class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = ProcessDestroyer.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException)) {
                    this.running = true;
                }
                e.printStackTrace();
            }
            this.destroyProcessThread.setShouldDestroy(false);
            if (!this.destroyProcessThread.getThreadGroup().isDestroyed()) {
                this.destroyProcessThread.start();
            }
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Process process) {
        Vector vector = this.processes;
        synchronized (vector) {
            if (this.processes.size() == 0) {
                this.addShutdownHook();
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Process process) {
        Vector vector = this.processes;
        synchronized (vector) {
            boolean processRemoved = this.processes.removeElement(process);
            if (processRemoved && this.processes.size() == 0) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector vector = this.processes;
        synchronized (vector) {
            this.running = true;
            Enumeration e = this.processes.elements();
            while (e.hasMoreElements()) {
                ((Process)e.nextElement()).destroy();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy = true;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
        }

        public void run() {
            if (this.shouldDestroy) {
                ProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy = shouldDestroy;
        }
    }
}

