/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.osgi.framework.Filter;

public class Event {
    String topic;
    Hashtable properties;
    private static final String SEPARATOR = "/";
    private static final String tokenAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";

    public Event(String topic, Dictionary properties) {
        this.topic = topic;
        this.validateTopicName();
        this.properties = new Hashtable();
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = properties.get(key);
                this.properties.put(key, value);
            }
        }
        this.properties.put("event.topics", topic);
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final String[] getPropertyNames() {
        String[] names = new String[this.properties.size()];
        Enumeration keys = this.properties.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            names[i] = (String)keys.nextElement();
            ++i;
        }
        return names;
    }

    public final String getTopic() {
        return this.topic;
    }

    public final boolean matches(Filter filter) {
        return filter.matchCase(this.properties);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event event = (Event)object;
        return this.topic.equals(event.topic) && this.properties.equals(event.properties);
    }

    public int hashCode() {
        return this.topic.hashCode() ^ this.properties.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " [topic=" + this.topic + "]";
    }

    private void validateTopicName() {
        try {
            StringTokenizer st = new StringTokenizer(this.topic, SEPARATOR, true);
            this.validateToken(st.nextToken());
            while (st.hasMoreTokens()) {
                st.nextToken();
                this.validateToken(st.nextToken());
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid topic");
        }
    }

    private void validateToken(String token) {
        int length = token.length();
        if (length < 1) {
            throw new IllegalArgumentException("invalid topic");
        }
        for (int i = 0; i < length; ++i) {
            if (tokenAlphabet.indexOf(token.charAt(i)) != -1) continue;
            throw new IllegalArgumentException("invalid topic");
        }
    }
}

