/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.installer.jonas;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.ow2.jonas.tools.configurator.Jonas;
import org.ow2.jonas.tools.configurator.api.JonasConfigurator;

public class JOnASConfigurationGenerator {
    private final Jonas jonas;
    private JonasConfigurator configurator = null;
    private VelocityEngine ve = null;
    private VelocityContext context = null;
    private Template template = null;
    private static final String STARTJM_BAT_NAME_TEMPLATE = "startjm.bat.vm";
    private static final String STARTJM_SH_NAME_TEMPLATE = "startjm.sh.vm";
    private static final String STARTJM_BAT_NAME = "startjm.bat";
    private static final String STARTJM_SH_NAME = "startjm.sh";

    public JOnASConfigurationGenerator(String jonasRoot, String jonasBase) {
        this.jonas = new Jonas(jonasRoot);
        this.configurator = this.jonas.getJonasConfigurator();
        this.configurator.setJonasBase(jonasBase);
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve = new VelocityEngine();
        this.context = new VelocityContext();
        try {
            this.ve.init(p);
            StringWriter writer = new StringWriter();
            this.context.put("jonas_root", jonasRoot);
            this.context.put("jonas_base", jonasBase);
            this.template = this.ve.getTemplate(STARTJM_BAT_NAME_TEMPLATE);
            if (this.template != null) {
                this.template.merge(this.context, writer);
            }
            this.write(jonasBase + File.separator + STARTJM_BAT_NAME);
            this.template = this.ve.getTemplate(STARTJM_SH_NAME_TEMPLATE);
            if (this.template != null) {
                this.template.merge(this.context, writer);
            }
            this.write(jonasBase + File.separator + STARTJM_SH_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void configure() {
        this.configurator.setServices("jtm,db,dbm,security,resource,ejb3,jaxws,web,ear,depmonitor");
        this.configurator.setJmsTopic("jasmine,JASMINeAlarmsTopic");
        this.configurator.execute();
        System.out.println("A JOnAS base has been created and configured for JASMINe Monitoring.");
    }

    private void write(String filename) throws Exception {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(this.generate());
        out.close();
    }

    private String generate() throws Exception {
        StringWriter writer = new StringWriter();
        if (this.template != null) {
            this.template.merge(this.context, writer);
        }
        return new String(writer.getBuffer());
    }
}

