/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.installer.jonas;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.installer.jonas.JOnASConfigurationGenerator;

public class Main {
    private Options options;
    private CommandLine commandline;
    private static final String JONAS_ROOT_OPT = "jonas_root";
    private static final String JONAS_BASE_OPT = "jonas_base";

    public Main(String[] args) {
        this.initOptions();
        BasicParser parser = new BasicParser();
        try {
            this.commandline = parser.parse(this.options, args);
        }
        catch (MissingOptionException e) {
            System.err.println(e.getMessage());
            System.exit(0);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(0);
        }
    }

    public final void generatedJOnASConfiguration() {
        String jonasRoot = "";
        String jonasBase = "";
        if (this.commandline.hasOption(JONAS_BASE_OPT)) {
            jonasBase = this.commandline.getOptionValue(JONAS_BASE_OPT);
        }
        if (this.commandline.hasOption(JONAS_ROOT_OPT)) {
            jonasRoot = this.commandline.getOptionValue(JONAS_ROOT_OPT);
        }
        new JOnASConfigurationGenerator(jonasRoot, jonasBase).configure();
    }

    public static void main(String[] args) {
        Main main = new Main(args);
        main.generatedJOnASConfiguration();
    }

    private void initOptions() {
        this.options = new Options();
        OptionBuilder.withArgName(JONAS_ROOT_OPT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Location of JONAS_ROOT");
        Option jonasRoot = OptionBuilder.create(JONAS_ROOT_OPT);
        this.options.addOption(jonasRoot);
        OptionBuilder.withArgName(JONAS_BASE_OPT);
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Location of JONAS_BASE");
        Option jonasBase = OptionBuilder.create(JONAS_BASE_OPT);
        this.options.addOption(jonasBase);
    }
}

