/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.ant.jonasbase.JEcho;
import org.ow2.jonas.ant.jonasbase.JMkdir;
import org.ow2.jonas.ant.jonasbase.JTouch;
import org.ow2.jonas.ant.jonasbase.Tasks;

public class Director
extends Tasks {
    private static final String INFO = "[Director] ";
    private static final String DIRECTOR_FILE = "enhydra_director.conf";
    private File configurationFile = null;
    private List appServerList = new ArrayList();
    private boolean stickySession = false;

    public void createFile(String destDir) {
        JMkdir mkdir = new JMkdir();
        mkdir.setDestDir(new File(destDir));
        this.addTask(mkdir);
        JTouch touchWorker = new JTouch();
        this.configurationFile = new File(destDir + "/" + DIRECTOR_FILE);
        touchWorker.setDestDir(this.configurationFile);
        this.addTask(touchWorker);
    }

    public void addAppServer(String portNumber, String lbFactor) {
        AppServer appServer = new AppServer();
        appServer.setPortNumber(portNumber);
        appServer.setLbFactor(lbFactor);
        this.appServerList.add(appServer);
    }

    private String getAppServerDef(AppServer appServer) {
        String appServerDef = "\n      <AppServer host= \"localhost\" port=\"" + appServer.getPortNumber() + "\" weight=\"" + appServer.getLbFactor() + "\" />";
        return appServerDef;
    }

    private void flushAppServerFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.configurationFile);
        String appServersDefs = "";
        int ind = 1;
        Iterator it = this.appServerList.iterator();
        while (it.hasNext()) {
            AppServer appServer = (AppServer)it.next();
            appServer.setName("appServer" + ind);
            appServersDefs = appServersDefs + this.getAppServerDef(appServer);
            ++ind;
        }
        String contentFile = "\n<?xml version=\"1.0\"?>\n<!DOCTYPE EnhydraDirectorConfig SYSTEM \"EnhydraDirectorConfig.dtd\">\n<EnhydraDirectorConfig>\n   <Application prefix=\"/sampleCluster2/\">" + appServersDefs + "\n" + "   </Application>" + "\n" + "   <Status prefix=\"/status\">" + "\n" + "      <Restrict server=\"127.0.0.1\" />" + "\n" + "      <Restrict client=\"127.0.0.1\" />" + "\n" + "   </Status>" + "\n" + "</EnhydraDirectorConfig>";
        echo.setMessage(contentFile);
        echo.setLogInfo("[Director] Flushing AppServer Configuration in '" + this.configurationFile + "'");
        this.addTask(echo);
    }

    public void flushFile() {
        this.flushAppServerFile();
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    public class AppServer {
        private String portNumber = null;
        private String lbFactor = null;
        private String name = null;

        public String getPortNumber() {
            return this.portNumber;
        }

        public void setPortNumber(String portNumber) {
            this.portNumber = portNumber;
        }

        public String getLbFactor() {
            return this.lbFactor;
        }

        public void setLbFactor(String lbFactor) {
            this.lbFactor = lbFactor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

