/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase.jaas;

import java.util.Iterator;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.jaas.JResourceLoginModule;
import org.ow2.jonas.ant.jonasbase.jaas.JaasEntry;
import org.ow2.jonas.ant.jonasbase.jaas.LoginModule;

public class Jaas
extends Tasks {
    private static final String INFO = "[JAAS] ";
    private static final String TOKEN_BEGIN_CONF_FILE = "jaasclient {";

    public void addConfiguredJaasEntry(JaasEntry entry) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jaas.config");
        propertyReplace.setToken(TOKEN_BEGIN_CONF_FILE);
        StringBuffer value = new StringBuffer();
        value.append(entry.getName() + "{" + "\n");
        Iterator i$ = entry.getLoginModules().iterator();
        while (i$.hasNext()) {
            LoginModule lm = (LoginModule)i$.next();
            if (lm instanceof JResourceLoginModule) {
                JResourceLoginModule rlm = (JResourceLoginModule)lm;
                value.append("    org.ow2.jonas.security.auth.spi.JResourceLoginModule " + lm.getFlag() + "\n");
                value.append("    resourceName=\"" + rlm.getResourceName() + "\"" + "\n");
                if (rlm.getServerName() != null && !"".equals(rlm.getServerName())) {
                    value.append("    serverName=\"" + rlm.getServerName() + "\"" + "\n");
                }
                if (rlm.isUseUpperCaseUsername()) {
                    value.append("    useUpperCaseUsername=\"" + rlm.isUseUpperCaseUsername() + "\"" + "\n");
                }
                if (rlm.isCertCallback()) {
                    value.append("    certCallback=\"" + rlm.isCertCallback() + "\"" + "\n");
                }
            }
            value.append("\n");
        }
        value.append("    ;\n");
        value.append("};\n");
        value.append("\n");
        value.append(TOKEN_BEGIN_CONF_FILE);
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[JAAS] Add the JAAS entry : " + entry.getName());
        this.addTask(propertyReplace);
    }
}

