/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ear;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ow2.jonas.deployment.common.AbsDeploymentDesc;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.xml.Application;
import org.ow2.jonas.deployment.ear.xml.JonasApplication;
import org.ow2.jonas.deployment.ear.xml.JonasSecurity;
import org.ow2.jonas.deployment.ear.xml.Module;
import org.ow2.jonas.deployment.ear.xml.SecurityRole;
import org.ow2.jonas.deployment.ear.xml.SecurityRoleMapping;
import org.ow2.jonas.deployment.ear.xml.Web;

public class EarDeploymentDesc
extends AbsDeploymentDesc {
    private Vector connectorTags = null;
    private Vector altDDConnectors = null;
    private Vector ejbTags = null;
    private Vector altDDEjbs = null;
    private Vector webTags = null;
    private Vector clientTags = null;
    private Vector altDDWebs = null;
    private Vector altDDClients = null;
    private Vector securityRolesNames = null;
    private String xmlContent = null;
    private String jonasXmlContent = null;
    private Map userToRoleMapping = null;

    public EarDeploymentDesc(ClassLoader classLoaderForCls, Application application, JonasApplication jonasApplication) throws EarDeploymentDescException {
        if (classLoaderForCls == null) {
            throw new EarDeploymentDescException("DeploymentDesc: Classloader is null");
        }
        this.ejbTags = new Vector();
        this.connectorTags = new Vector();
        this.webTags = new Vector();
        this.clientTags = new Vector();
        this.altDDEjbs = new Vector();
        this.altDDClients = new Vector();
        this.altDDConnectors = new Vector();
        this.altDDWebs = new Vector();
        this.securityRolesNames = new Vector();
        this.displayName = application.getDisplayName();
        Iterator i = application.getModuleList().iterator();
        while (i.hasNext()) {
            Module module = (Module)i.next();
            String ejb = module.getEjb();
            String connector = module.getConnector();
            String java = module.getJava();
            Web web = module.getWeb();
            String altDD = module.getAltDd();
            if (ejb != null) {
                this.ejbTags.add(ejb);
                this.altDDEjbs.add(altDD);
                continue;
            }
            if (connector != null) {
                this.connectorTags.add(connector);
                this.altDDConnectors.add(altDD);
                continue;
            }
            if (java != null) {
                this.clientTags.add(java);
                this.altDDClients.add(altDD);
                continue;
            }
            if (web == null) continue;
            this.webTags.add(web);
            this.altDDWebs.add(altDD);
        }
        i = application.getSecurityRoleList().iterator();
        while (i.hasNext()) {
            SecurityRole securityRole = (SecurityRole)i.next();
            if (securityRole == null || securityRole.getRoleName() == null) continue;
            this.securityRolesNames.add(securityRole.getRoleName());
        }
        JonasSecurity jonasSecurity = jonasApplication.getJonasSecurity();
        if (jonasSecurity != null) {
            this.userToRoleMapping = new HashMap();
            Iterator it = jonasSecurity.getSecurityRoleMappingList().iterator();
            while (it.hasNext()) {
                SecurityRoleMapping securityRoleMapping = (SecurityRoleMapping)it.next();
                if (securityRoleMapping == null) continue;
                String roleName = securityRoleMapping.getRoleName();
                JLinkedList principals = securityRoleMapping.getPrincipalNamesList();
                Iterator itPrincipals = principals.iterator();
                while (itPrincipals.hasNext()) {
                    String principalName = (String)itPrincipals.next();
                    List currentMapping = (List)this.userToRoleMapping.get(principalName);
                    if (currentMapping == null) {
                        currentMapping = new ArrayList();
                        this.userToRoleMapping.put(principalName, currentMapping);
                    }
                    currentMapping.add(roleName);
                }
            }
        }
    }

    public String[] getEjbTags() {
        Object[] tmp = new String[this.ejbTags.size()];
        this.ejbTags.copyInto(tmp);
        return tmp;
    }

    public String[] getAltDDEjbs() {
        Object[] tmp = new String[this.altDDEjbs.size()];
        this.altDDEjbs.copyInto(tmp);
        return tmp;
    }

    public String[] getClientTags() {
        Object[] tmp = new String[this.clientTags.size()];
        this.clientTags.copyInto(tmp);
        return tmp;
    }

    public String[] getAltDDClients() {
        Object[] tmp = new String[this.altDDClients.size()];
        this.altDDClients.copyInto(tmp);
        return tmp;
    }

    public Web[] getWebTags() {
        Object[] tmp = new Web[this.webTags.size()];
        this.webTags.copyInto(tmp);
        return tmp;
    }

    public String[] getAltDDWebs() {
        Object[] tmp = new String[this.altDDWebs.size()];
        this.altDDWebs.copyInto(tmp);
        return tmp;
    }

    public String[] getConnectorTags() {
        Object[] tmp = new String[this.connectorTags.size()];
        this.connectorTags.copyInto(tmp);
        return tmp;
    }

    public String[] getAltDDConnectors() {
        Object[] tmp = new String[this.altDDConnectors.size()];
        this.altDDConnectors.copyInto(tmp);
        return tmp;
    }

    public String[] getSecurityRolesNames() {
        Object[] tmp = new String[this.securityRolesNames.size()];
        this.securityRolesNames.copyInto(tmp);
        return tmp;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public String getJonasXmlContent() {
        return this.jonasXmlContent;
    }

    public void setXmlContent(String xml) {
        this.xmlContent = xml;
    }

    public void setJonasXmlContent(String xml) {
        this.jonasXmlContent = xml;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ndisplay-name=" + this.displayName);
        ret.append("\nconnectors=");
        Enumeration e = this.connectorTags.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        ret.append("\nejbs=");
        e = this.ejbTags.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        ret.append("\nwebs=");
        e = this.webTags.elements();
        while (e.hasMoreElements()) {
            ret.append(((Web)e.nextElement()).getWebUri() + ",");
        }
        ret.append("\njavas=");
        e = this.clientTags.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        ret.append("\nsecurity-roles-names=");
        e = this.securityRolesNames.elements();
        while (e.hasMoreElements()) {
            ret.append(e.nextElement() + ",");
        }
        return ret.toString();
    }

    public Map getUserToRoleMapping() {
        return this.userToRoleMapping;
    }
}

