/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.EjbRelationDesc;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.EjbJar;
import org.ow2.jonas.deployment.ejb.xml.EjbRelation;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbJar;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbRelation;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.deployment.ejb.xml.JonasMessageDriven;
import org.ow2.jonas.deployment.ejb.xml.MessageDriven;

public class DeploymentDescEjb2
extends DeploymentDesc {
    private ArrayList ejbRelations = new ArrayList();

    public DeploymentDescEjb2(ClassLoader classLoader, EjbJar ejbJar, JonasEjbJar jonasEjbJar, Logger l, String fileName) throws DeploymentDescException {
        super(classLoader, ejbJar, jonasEjbJar, l, fileName);
        HashMap jonasMessageDriven = new HashMap();
        Iterator i = jonasEjbJar.getJonasMessageDrivenList().iterator();
        while (i.hasNext()) {
            JonasMessageDriven jMd = (JonasMessageDriven)i.next();
            jonasMessageDriven.put(jMd.getEjbName(), jMd);
        }
        if (ejbJar.getEnterpriseBeans() != null) {
            i = ejbJar.getEnterpriseBeans().getMessageDrivenList().iterator();
            while (i.hasNext()) {
                MessageDrivenDesc bd = null;
                MessageDriven md = (MessageDriven)i.next();
                if (md.getEjbName() == null) {
                    throw new DeploymentDescException("ejb-name missing for a message driven bean");
                }
                JonasMessageDriven jMd = (JonasMessageDriven)jonasMessageDriven.get(md.getEjbName());
                if (jMd == null) {
                    throw new DeploymentDescException("jonas-message-driven-bean missing for bean " + md.getEjbName());
                }
                bd = new MessageDrivenDesc(classLoader, md, this.asd, jMd, jonasEjbJar.getJonasMessageDestinationList(), fileName);
                bd.setDeploymentDesc(this);
                ((BeanDesc)bd).check();
                this.beanDesc.put(bd.getEjbName(), bd);
            }
        }
        if (ejbJar.getRelationships() != null) {
            String jerName;
            JonasEjbRelation jer;
            ArrayList stdRelations = new ArrayList();
            HashMap jonasRelations = new HashMap();
            Iterator i2 = jonasEjbJar.getJonasEjbRelationList().iterator();
            while (i2.hasNext()) {
                jer = (JonasEjbRelation)i2.next();
                jerName = jer.getEjbRelationName();
                jonasRelations.put(jerName, jer);
            }
            i2 = ejbJar.getRelationships().getEjbRelationList().iterator();
            while (i2.hasNext()) {
                EjbRelation er = (EjbRelation)i2.next();
                EjbRelationDesc erd = new EjbRelationDesc(er, this.logger);
                this.ejbRelations.add(erd);
                stdRelations.add(erd.getName());
                JonasEjbRelation jer2 = (JonasEjbRelation)jonasRelations.get(erd.getName());
                erd.setJonasInfo(jer2);
                EjbRelationshipRoleDesc rsd1 = erd.getRelationshipRole1();
                EjbRelationshipRoleDesc rsd2 = erd.getRelationshipRole2();
                EntityCmp2Desc ed1 = (EntityCmp2Desc)this.beanDesc.get(rsd1.getSourceBeanName());
                EntityCmp2Desc ed2 = (EntityCmp2Desc)this.beanDesc.get(rsd2.getSourceBeanName());
                if (ed1 == null || ed2 == null) {
                    throw new DeploymentDescException("Invalid ejb-name for a relation-ship-role-source for the relation '" + erd.getName() + "' ('" + rsd1.getSourceBeanName() + "' or '" + rsd2.getSourceBeanName() + "' invalid)");
                }
                if (ed1.getLocalHomeClass() == null || ed1.getLocalClass() == null) {
                    throw new DeploymentDescException("The entity bean '" + ed1.getEjbName() + "' involved in the relationship '" + erd.getName() + "' must have local interfaces");
                }
                if (ed2.getLocalHomeClass() == null || ed2.getLocalClass() == null) {
                    throw new DeploymentDescException("The entity bean '" + ed2.getEjbName() + "' involved in the relationship '" + erd.getName() + "' must have local interfaces");
                }
                ed1.addEjbRelationshipRoleDesc(rsd1);
                ed2.addEjbRelationshipRoleDesc(rsd2);
                rsd1.setTargetBean(ed2);
                rsd1.setSourceBean(ed1);
                rsd2.setTargetBean(ed1);
                rsd2.setSourceBean(ed2);
                erd.fillMappingInfo();
                erd.fillMappingInfoWithDefault();
            }
            i2 = jonasEjbJar.getJonasEjbRelationList().iterator();
            while (i2.hasNext()) {
                jer = (JonasEjbRelation)i2.next();
                jerName = jer.getEjbRelationName();
                if (stdRelations.contains(jerName)) continue;
                throw new DeploymentDescException("ejb-relation missing in ejb-jar.xml for the relation " + jerName);
            }
        }
        if (this.logger.getCurrentIntLevel() == BasicLevel.DEBUG) {
            this.logger.log(BasicLevel.DEBUG, (Object)("DEPLOYMENT DESCRIPTOR = \n(" + this.toString() + "\n)"));
        }
    }

    protected BeanDesc newEntityBeanDesc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, JLinkedList jMDRList) throws DeploymentDescException {
        if (ent.getCmpVersion() == null || ent.getCmpVersion().equals("2.x")) {
            return new EntityJdbcCmp2Desc(classLoader, ent, asd, jEnt, this, jMDRList, this.fileName);
        }
        return new EntityJdbcCmp1Desc(classLoader, ent, asd, jEnt, jMDRList, this.fileName);
    }

    public Iterator getEjbRelationDescIterator() {
        return this.ejbRelations.iterator();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        Iterator i = this.getEjbRelationDescIterator();
        while (i.hasNext()) {
            ret.append("\nejbRelationDesc[]=" + i.next());
        }
        return ret.toString();
    }
}

