/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.SessionSynchronization;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.JonasSession;
import org.ow2.jonas.deployment.ejb.xml.Session;

public abstract class SessionDesc
extends BeanDesc {
    protected int transactionType;
    int sessionTimeout = 0;
    boolean monitoringEnabled = false;
    int warningThreshold = 0;
    boolean monitoringSettingsDefinedInDD = false;

    public SessionDesc(ClassLoader classLoader, Session ses, AssemblyDescriptor asd, JonasSession jSes, JLinkedList jMDRList, String filename) throws DeploymentDescException {
        super(classLoader, ses, jSes, asd, jMDRList, filename);
        Integer tval;
        String tstr;
        if (jSes.getSessionTimeout() != null) {
            tstr = jSes.getSessionTimeout();
            tval = new Integer(tstr);
            this.sessionTimeout = tval;
        }
        if (jSes.getMonitoringEnabled() != null) {
            this.monitoringSettingsDefinedInDD = true;
            if (jSes.getMonitoringEnabled().equalsIgnoreCase("True")) {
                this.monitoringEnabled = true;
            } else if (jSes.getMonitoringEnabled().equalsIgnoreCase("False")) {
                this.monitoringEnabled = false;
            } else {
                throw new DeploymentDescException("Invalid monitoringEnabled value for bean " + this.ejbName);
            }
        }
        if (jSes.getWarningThreshold() != null) {
            this.monitoringSettingsDefinedInDD = true;
            tstr = jSes.getWarningThreshold();
            tval = new Integer(tstr);
            this.warningThreshold = tval;
        }
        if (jSes.getMinPoolSize() != null) {
            tstr = jSes.getMinPoolSize();
            tval = new Integer(tstr);
            this.poolMin = tval;
        }
        if (jSes.getMaxCacheSize() != null) {
            tstr = jSes.getMaxCacheSize();
            tval = new Integer(tstr);
            this.cacheMax = tval;
        }
        if ("Bean".equals(ses.getTransactionType())) {
            this.transactionType = 1;
        } else if ("Container".equals(ses.getTransactionType())) {
            this.transactionType = 2;
        } else {
            throw new DeploymentDescException("Invalid transaction-type content for ejb-name " + this.ejbName);
        }
    }

    protected void checkTxAttribute(MethodDesc md) throws DeploymentDescException {
        Method m = md.getMethod();
        if (this.getTransactionType() == 2) {
            if (md.getTxAttribute() == 0 && EJBObject.class.isAssignableFrom(m.getDeclaringClass()) && !EJBObject.class.equals((Object)m.getDeclaringClass())) {
                logger.log(BasicLevel.WARN, (Object)("trans-attribute missing for method " + m.toString() + " in session bean " + this.getEjbName() + " (set to the default value " + "Supports" + ")"));
                md.setTxAttribute("Supports");
            }
            if (md.getTxAttribute() != 0 && EJBHome.class.isAssignableFrom(m.getDeclaringClass()) && (md.getTxAttributeStatus() == 2 || md.getTxAttributeStatus() == 4 || md.getTxAttributeStatus() == 6)) {
                logger.log(BasicLevel.WARN, (Object)("trans-attribute must not be specified for home interface's method " + m.toString() + " in session bean " + this.getEjbName()));
            }
        } else if (md.getTxAttribute() != 0) {
            throw new DeploymentDescException(md.getTxAttributeName() + " is not a valid trans-attribute for method " + m.toString() + " in session bean " + this.getEjbName());
        }
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public boolean isBeanManagedTransaction() {
        return this.transactionType == 1;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void check() throws DeploymentDescException {
        super.check();
        if (this.getTransactionType() == 1 && SessionSynchronization.class.isAssignableFrom(this.ejbClass)) {
            throw new DeploymentDescException(this.ejbClass.getName() + " should NOT manage transactions and implement javax.ejb.SessionSynchronization");
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\ngetTransactionType()" + TRANS[this.getTransactionType()]);
        ret.append("\nsessionTimeout = " + this.sessionTimeout);
        return ret.toString();
    }

    public boolean isMonitoringSettingsDefinedInDD() {
        return this.monitoringSettingsDefinedInDD;
    }

    public void setWarningThreshold(int warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }
}

