/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.jonas.deployment.web.MethodDesc;

public class MethodsDesc {
    private Map httpMethods = new HashMap();
    public static final String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};

    public MethodsDesc() {
        for (int m = 0; m < METHODS.length; ++m) {
            this.httpMethods.put(METHODS[m], new MethodDesc(METHODS[m]));
        }
    }

    public void addMethods(String[] methods, String transportGuarantee, boolean isExcluded) {
        MethodDesc method = null;
        for (int m = 0; m < methods.length; ++m) {
            method = this.getMethod(methods[m]);
            method.addTransportGuarantee(transportGuarantee);
            if (!isExcluded) continue;
            method.setExcluded();
        }
    }

    public void addMethodsOnRole(String[] methods, String role, String transportGuarantee) {
        for (int m = 0; m < methods.length; ++m) {
            this.getMethod(methods[m]).addRole(role, transportGuarantee);
            this.getMethod(methods[m]).setUnchecked(false);
        }
    }

    private MethodDesc getMethod(String methodName) {
        MethodDesc m = (MethodDesc)this.httpMethods.get(methodName.toUpperCase());
        if (m == null) {
            m = new MethodDesc(methodName);
            this.httpMethods.put(methodName, m);
        }
        return m;
    }

    public String getExcludedActions() {
        StringBuffer actions = new StringBuffer();
        MethodDesc method = null;
        Iterator it = this.httpMethods.values().iterator();
        while (it.hasNext()) {
            method = (MethodDesc)it.next();
            if (!method.isExcluded()) continue;
            if (actions.length() > 0) {
                actions.append(",");
            }
            actions.append(method.getName());
        }
        return actions.toString();
    }

    public String getUncheckedActions() {
        StringBuffer actions = new StringBuffer();
        MethodDesc method = null;
        Iterator it = this.httpMethods.values().iterator();
        while (it.hasNext()) {
            method = (MethodDesc)it.next();
            if (method.isUnchecked()) continue;
            if (actions.length() > 0) {
                actions.append(",");
            }
            actions.append(method.getName());
        }
        if (actions.length() == 0) {
            return null;
        }
        return "!".concat(actions.toString());
    }

    public Map getRoleMapActions() {
        MethodDesc method = null;
        HashMap rolesMap = new HashMap();
        Iterator it = this.httpMethods.values().iterator();
        while (it.hasNext()) {
            method = (MethodDesc)it.next();
            if (!method.hasRole()) continue;
            Iterator itRoles = method.getRolesIterator();
            while (itRoles.hasNext()) {
                String roleName = (String)itRoles.next();
                String actions = (String)rolesMap.get(roleName);
                if (actions == null) {
                    actions = method.getName();
                } else {
                    actions = actions + ",";
                    actions = actions + method.getName();
                }
                rolesMap.put(roleName, actions);
            }
        }
        return rolesMap;
    }

    public List getUncheckedWebUserDataActionsRoleList() {
        MethodDesc method = null;
        StringBuffer nones = null;
        StringBuffer confidentials = null;
        StringBuffer integrals = null;
        Iterator it = this.httpMethods.values().iterator();
        while (it.hasNext()) {
            method = (MethodDesc)it.next();
            String methodName = method.getName();
            if (method.isExcluded() || !method.hasRole()) continue;
            if (method.getTransportGuarantee().hasNone()) {
                if (nones == null) {
                    nones = new StringBuffer(methodName);
                } else {
                    nones.append(",");
                    nones.append(methodName);
                }
            }
            if (method.getTransportGuarantee().isIntegral()) {
                if (integrals == null) {
                    integrals = new StringBuffer(methodName);
                } else {
                    integrals.append(",");
                    integrals.append(methodName);
                }
            }
            if (!method.getTransportGuarantee().isConfidential()) continue;
            if (confidentials == null) {
                confidentials = new StringBuffer(methodName);
                continue;
            }
            confidentials.append(",");
            confidentials.append(methodName);
        }
        ArrayList unchecked = new ArrayList();
        if (nones != null) {
            unchecked.add(null);
        }
        if (integrals != null) {
            integrals.append(":");
            integrals.append("INTEGRAL");
            unchecked.add(integrals.toString());
        }
        if (confidentials != null) {
            confidentials.append(":");
            confidentials.append("CONFIDENTIAL");
            unchecked.add(confidentials.toString());
        }
        return unchecked;
    }
}

