/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.JndiEnvRefsGroupDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.RunAs;
import org.ow2.jonas.deployment.common.xml.SecurityRole;
import org.ow2.jonas.deployment.web.SecurityConstraintListDesc;
import org.ow2.jonas.deployment.web.SecurityRoleDesc;
import org.ow2.jonas.deployment.web.ServletDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDescException;
import org.ow2.jonas.deployment.web.xml.JonasServlet;
import org.ow2.jonas.deployment.web.xml.JonasWebApp;
import org.ow2.jonas.deployment.web.xml.Servlet;
import org.ow2.jonas.deployment.web.xml.ServletMapping;
import org.ow2.jonas.deployment.web.xml.WebApp;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContainerDeploymentDesc
extends JndiEnvRefsGroupDesc {
    private String host = null;
    private String contextRoot = null;
    private String port = null;
    private boolean java2DelegationModel = true;
    private Map<String, ServletDesc> servlets = new HashMap();
    private Map<String, List<String>> servletsUrlMapping = new Hashtable();
    private Map<String, String> servletsPrincipalName = new Hashtable();
    private String xmlContent = "";
    private String jonasXmlContent = "";
    private List<SecurityRoleDesc> securityRoleList;
    private SecurityConstraintListDesc securityConstraintListDesc;
    private Map<String, IWarClassMetadata> webServicesMetadatas;

    public WebContainerDeploymentDesc(String fileName, ClassLoader classLoader, WebApp webApp, JonasWebApp jonasWebApp, IWarDeployableMetadata metadata) throws DeploymentDescException {
        super(classLoader, webApp, jonasWebApp, fileName);
        this.host = jonasWebApp.getHost() != null ? jonasWebApp.getHost() : null;
        this.contextRoot = jonasWebApp.getContextRoot() != null ? jonasWebApp.getContextRoot() : null;
        this.port = jonasWebApp.getPort() != null ? jonasWebApp.getPort() : null;
        String delegationModel = null;
        delegationModel = jonasWebApp.getJava2DelegationModel() != null ? jonasWebApp.getJava2DelegationModel() : "true";
        if (delegationModel.equalsIgnoreCase("false")) {
            this.java2DelegationModel = false;
        } else if (delegationModel.equalsIgnoreCase("true")) {
            this.java2DelegationModel = true;
        } else {
            throw new WebContainerDeploymentDescException("The java2 delegation model could be 'true' or 'false', not '" + delegationModel + "'.");
        }
        SecurityRole securityRole = null;
        this.securityRoleList = new ArrayList();
        Iterator itSecurityRole = webApp.getSecurityRoleList().iterator();
        while (itSecurityRole.hasNext()) {
            securityRole = (SecurityRole)itSecurityRole.next();
            this.securityRoleList.add((Object)new SecurityRoleDesc(securityRole));
        }
        JLinkedList servletList = webApp.getServletList();
        Iterator i = servletList.iterator();
        while (i.hasNext()) {
            String runAsAnnotationValue;
            Servlet servlet = (Servlet)i.next();
            if (servlet.getRunAs() == null && (runAsAnnotationValue = this.runAsAnnotationValue(servlet, metadata)) != null) {
                RunAs runAs = new RunAs();
                runAs.setRoleName(runAsAnnotationValue);
                servlet.setRunAs(runAs);
            }
            if (servlet.getServletName() == null) continue;
            ServletDesc servletDesc = new ServletDesc(servlet);
            this.servlets.put((Object)servlet.getServletName(), (Object)servletDesc);
        }
        JLinkedList urlMappings = webApp.getServletMappingList();
        Iterator i2 = servletList.iterator();
        while (i2.hasNext()) {
            Servlet servlet = (Servlet)i2.next();
            String name = servlet.getServletName().trim();
            ArrayList mappings = new ArrayList();
            Iterator m = urlMappings.iterator();
            while (m.hasNext()) {
                ServletMapping sm = (ServletMapping)m.next();
                if (!sm.getServletName().trim().equals(name)) continue;
                String pattern = sm.getUrlPattern().trim();
                if (pattern.indexOf(10) != -1) {
                    throw new WebContainerDeploymentDescException("There is a '\\n' character inside the url pattern for servlet named '" + sm.getServletName() + "' in the file '" + fileName + "'.");
                }
                mappings.add(pattern);
            }
            this.servletsUrlMapping.put((Object)name, (Object)mappings);
        }
        this.securityConstraintListDesc = new SecurityConstraintListDesc(webApp);
        JLinkedList jonasServlets = jonasWebApp.getServletList();
        Iterator i$ = jonasServlets.iterator();
        while (i$.hasNext()) {
            JonasServlet jonasServlet = (JonasServlet)i$.next();
            this.servletsPrincipalName.put((Object)jonasServlet.getServletName(), (Object)jonasServlet.getPrincipalName());
        }
        if (webApp.getJspConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element jsp-config in file '" + fileName + "'");
        }
        if (webApp.getLoginConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element login-config in file '" + fileName + "'");
        }
        if (webApp.getSessionConfigNumber() > 1) {
            throw new WebContainerDeploymentDescException("The web-app element must contain only one element session-config in file '" + fileName + "'");
        }
    }

    private String runAsAnnotationValue(Servlet servlet, IWarDeployableMetadata metadata) {
        Collection<IWarClassMetadata> classes = metadata.getWarClassMetadataCollection();
        Iterator i$ = classes.iterator();
        while (i$.hasNext()) {
            IWarClassMetadata clazz = (IWarClassMetadata)i$.next();
            String className = clazz.getJClass().getName();
            if (!(className = className.replace((CharSequence)"/", (CharSequence)".")).equals(servlet.getServletClass()) || clazz.getRunAs() == null) continue;
            return clazz.getRunAs();
        }
        return null;
    }

    public String getXmlContent() {
        return this.xmlContent;
    }

    public String getJOnASXmlContent() {
        return this.jonasXmlContent;
    }

    public void setXmlContent(String xml) {
        this.xmlContent = xml;
    }

    public void setJOnASXmlContent(String jXml) {
        this.jonasXmlContent = jXml;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean getJava2DelegationModel() {
        return this.java2DelegationModel;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\ngetDisplayName()=" + this.getDisplayName());
        IResourceEnvRefDesc[] rer = this.getResourceEnvRefDesc();
        for (int i = 0; i < rer.length; ++i) {
            ret.append("\ngetResourceEnvRefDesc(" + i + ")=" + rer[i].getClass().getName());
            ret.append(rer[i].toString());
        }
        IResourceRefDesc[] resourceRefDesc = this.getResourceRefDesc();
        for (int i = 0; i < resourceRefDesc.length; ++i) {
            ret.append("\ngetResourceRefDesc(" + i + ")=" + resourceRefDesc[i].getClass().getName());
            ret.append(resourceRefDesc[i].toString());
        }
        IEnvEntryDesc[] envEntries = this.getEnvEntryDesc();
        for (int i = 0; i < envEntries.length; ++i) {
            ret.append("\ngetEnvEntryDesc(" + i + ")=" + envEntries[i].getClass().getName());
            ret.append(envEntries[i].toString());
        }
        EjbRefDesc[] ejbRefDesc = this.getEjbRefDesc();
        for (int i = 0; i < ejbRefDesc.length; ++i) {
            ret.append("\ngetEjbRefDesc(" + i + ")=" + ejbRefDesc[i].getClass().getName());
            ret.append(((Object)ejbRefDesc[i]).toString());
        }
        EjbLocalRefDesc[] ejbLocalRefDesc = this.getEjbLocalRefDesc();
        for (int i = 0; i < ejbLocalRefDesc.length; ++i) {
            ret.append("\ngetEjbLocalRefDesc(" + i + ")=" + ejbLocalRefDesc[i].getClass().getName());
            ret.append(((Object)ejbLocalRefDesc[i]).toString());
        }
        IServiceRefDesc[] svcRef = this.getServiceRefDesc();
        for (int i = 0; i < svcRef.length; ++i) {
            ret.append("\ngetServiceRefDesc(" + i + ")=" + svcRef[i].getClass().getName());
            ret.append(svcRef[i].toString());
        }
        MessageDestinationRefDesc[] mdRefDesc = this.getMessageDestinationRefDesc();
        for (int i = 0; i < mdRefDesc.length; ++i) {
            ret.append("\ngetMessageDestinationRefDesc(" + i + ")=" + mdRefDesc[i].getClass().getName());
            ret.append(((Object)mdRefDesc[i]).toString());
        }
        ret.append("\ngetHost()=" + this.getHost());
        ret.append("\ngetContextRoot()=" + this.getContextRoot());
        return ret.toString();
    }

    public Collection<ServletDesc> getServletDescList() {
        return this.servlets.values();
    }

    public String[] getServletsName() {
        Object[] st = new String[this.servlets.size()];
        return (String[])this.servlets.keySet().toArray(st);
    }

    public String getServletClassname(String servName) {
        return ((ServletDesc)this.servlets.get((Object)servName)).getServletClass();
    }

    public SecurityConstraintListDesc getSecurityConstraintListDesc() {
        return this.securityConstraintListDesc;
    }

    public List<SecurityRoleDesc> getSecurityRoleList() {
        return this.securityRoleList;
    }

    public List<String> getServletMappings(String servName) {
        return (List)this.servletsUrlMapping.get((Object)servName);
    }

    public String getServletPrincipalName(String servName) {
        return (String)this.servletsPrincipalName.get((Object)servName);
    }

    public void setWebServices(Map<String, IWarClassMetadata> services) {
        this.webServicesMetadatas = services;
    }

    public Map<String, IWarClassMetadata> getWebServices() {
        return this.webServicesMetadatas;
    }

    public void mergeServletsRunAS(IWarDeployableMetadata warDeployableMetadata) {
    }
}

