/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.Log;

public class WSManagerWrapper {
    private static final String WS_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ear");

    private WSManagerWrapper() {
    }

    public static WSDeploymentDesc getDeploymentDesc(URL url, ClassLoader moduleCL, ClassLoader earCL) throws WSDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        WSDeploymentDesc wsDD = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(WS_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("getDeploymentDesc", new Class[]{URL.class, ClassLoader.class, ClassLoader.class});
            wsDD = (WSDeploymentDesc)m.invoke(instance, new Object[]{url, moduleCL, earCL});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WSDeploymentDescException.class.isInstance((Object)t)) {
                throw (WSDeploymentDescException)ite.getTargetException();
            }
            throw new WSDeploymentDescException("WSDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new WSDeploymentDescException("Problems when using reflection on WSDeploymentDescManager", e);
        }
        return wsDD;
    }

    public static WSDeploymentDesc getDeploymentDesc(URL url, URL unpackedURL, ClassLoader moduleCL, ClassLoader earCL) throws WSDeploymentDescException {
        LoaderManager lm = LoaderManager.getInstance();
        WSDeploymentDesc wsDD = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(WS_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("getDeploymentDesc", new Class[]{URL.class, URL.class, ClassLoader.class, ClassLoader.class});
            wsDD = (WSDeploymentDesc)m.invoke(instance, new Object[]{url, unpackedURL, moduleCL, earCL});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (WSDeploymentDescException.class.isInstance((Object)t)) {
                throw (WSDeploymentDescException)ite.getTargetException();
            }
            throw new WSDeploymentDescException("WSDeploymentDescManager.getDeploymentDesc fails", t);
        }
        catch (Exception e) {
            throw new WSDeploymentDescException("Problems when using reflection on WSDeploymentDescManager", e);
        }
        return wsDD;
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(WS_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", new Class[]{Boolean.TYPE});
            m.invoke(null, new Object[]{new Boolean(b)});
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public static void removeCache(ClassLoader cl) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(WS_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getInstance", new Class[0]);
            Object instance = m.invoke(null, new Object[0]);
            m = manager.getDeclaredMethod("removeCache", new Class[]{ClassLoader.class});
            m.invoke(instance, new Object[]{cl});
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }
}

