/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.cpmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.cpmanager.EarClassPathManagerException;
import org.ow2.jonas.lib.cpmanager.JarList;
import org.ow2.jonas.lib.cpmanager.JarListException;
import org.ow2.jonas.lib.util.Log;

public class EarClassPathManager {
    private Logger logger = null;
    private URL[] urls = null;
    private JarList toParse = null;
    private JarList parsed = null;
    private JarList libraries = null;
    private JarList ejbs = null;
    private JarList wars = null;
    private JarList clients = null;
    private URL directory = null;

    public EarClassPathManager(JarList ejbs, JarList wars, URL directory) throws EarClassPathManagerException {
        this.logger = Log.getLogger("org.ow2.jonas.ear");
        if (ejbs == null || wars == null || directory == null) {
            throw new EarClassPathManagerException("The constructor EarClassPathManager can't accept null parameters");
        }
        if (!directory.getProtocol().equalsIgnoreCase("file")) {
            throw new EarClassPathManagerException("Only the file:/ URL can be used");
        }
        this.ejbs = ejbs;
        this.wars = wars;
        this.clients = new JarList();
        this.directory = directory;
    }

    public EarClassPathManager(JarList clients, URL directory) throws EarClassPathManagerException {
        if (clients == null || directory == null) {
            throw new EarClassPathManagerException("The constructor EarClassPathManager can't accept null parameters");
        }
        if (!directory.getProtocol().equalsIgnoreCase("file")) {
            throw new EarClassPathManagerException("Only the file:/ URL can be used");
        }
        this.ejbs = new JarList();
        this.wars = new JarList();
        this.clients = clients;
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarList getManifestClassPath(URL url) throws EarClassPathManagerException, IOException {
        if (url == null) {
            throw new EarClassPathManagerException("JarList.getManifestClassPath : The url parameter can't be null");
        }
        Manifest manifest = null;
        if (new File(url.getFile()).isDirectory()) {
            File manifestFile = new File(url.getFile() + File.separator + "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(manifestFile);
                    manifest = new Manifest(is);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(url.getFile());
                manifest = jarFile.getManifest();
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        String classPath = null;
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            classPath = attributes.getValue(Attributes.Name.CLASS_PATH);
        }
        JarList jarList = null;
        jarList = classPath != null ? new JarList(new StringTokenizer(classPath)) : new JarList();
        return jarList;
    }

    public URL[] getResolvedClassPath() throws EarClassPathManagerException {
        if (this.urls == null) {
            this.resolveClassPath();
        }
        return this.urls;
    }

    private void resolveClassPath() throws EarClassPathManagerException {
        this.toParse = new JarList();
        this.parsed = new JarList();
        this.libraries = new JarList();
        this.toParse.merge(this.ejbs);
        this.toParse.merge(this.wars);
        this.toParse.merge(this.clients);
        JarList lstOfFilesDep = new JarList();
        URL depUrl = null;
        while (this.toParse.size() > 0) {
            String fileName = (String)this.toParse.firstElement();
            if (fileName.endsWith("/")) {
                throw new EarClassPathManagerException("In j2ee application, Class-Path with directory is forbidden. '" + fileName + "' is not authorized.");
            }
            try {
                depUrl = new URL(this.directory.toExternalForm() + "/" + fileName);
                lstOfFilesDep = this.getManifestClassPath(depUrl);
            }
            catch (MalformedURLException mue) {
                lstOfFilesDep.removeAllElements();
                this.logger.log(BasicLevel.ERROR, (Object)("Error while trying to get the url for " + this.directory.toExternalForm() + File.separator + fileName + " : "), (Throwable)mue);
            }
            catch (IOException ioe) {
                lstOfFilesDep.removeAllElements();
                this.logger.log(BasicLevel.ERROR, (Object)("Error while reading manifest file from the file " + fileName + " : "), (Throwable)ioe);
            }
            String parentDir = new File(fileName).getParent();
            String subDir = null;
            subDir = parentDir != null ? parentDir : "";
            lstOfFilesDep.setRelativePath(subDir);
            this.toParse.merge(lstOfFilesDep);
            this.parsed.add(fileName);
            if (this.isALibrary(fileName)) {
                this.libraries.add(fileName);
            }
            this.toParse.remove(this.parsed);
        }
        try {
            this.urls = this.libraries.getURLs(this.directory.toExternalForm());
        }
        catch (JarListException e) {
            throw new EarClassPathManagerException("Error while geting the URLs of the jars files which must be loaded at the EAR level");
        }
    }

    private boolean isALibrary(String fileName) {
        return !this.ejbs.contains(fileName) && !this.wars.contains(fileName);
    }
}

