/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIUtils {
    private JNDIUtils() {
    }

    public static byte[] getBytesFromObject(Object obj) {
        return JNDIUtils.getBytesFromObject(obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromObject(Object obj, Logger logger) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        byte[] bytes = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            block13: {
                try {
                    oos.close();
                    baos.close();
                }
                catch (Exception e) {
                    if (logger == null) break block13;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close output streams : '" + e.getMessage() + "'"));
                }
            }
        }
        return bytes;
    }

    public static Object getObjectFromBytes(byte[] bytes) {
        return JNDIUtils.getObjectFromBytes(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromBytes(byte[] bytes, Logger logger) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        Object obj = null;
        if (bytes == null) {
            return null;
        }
        bis = new ByteArrayInputStream(bytes);
        try {
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (ClassNotFoundException cfe) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + cfe.getMessage()));
            }
        }
        catch (OptionalDataException ode) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + ode.getMessage()));
            }
        }
        catch (IOException ioe) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + ioe.getMessage()));
            }
        }
        finally {
            block24: {
                try {
                    bis.close();
                    ois.close();
                }
                catch (Exception e) {
                    if (logger == null) break block24;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close input stream : " + e.getMessage()));
                }
            }
        }
        return obj;
    }

    public static void insertInto(Reference ref, String key, String value) {
        if (value != null) {
            StringRefAddr addr = new StringRefAddr(key, value);
            ref.add(addr);
        }
    }

    public static void insertInto(Reference ref, String key, Object value) {
        if (value != null) {
            BinaryRefAddr addr = new BinaryRefAddr(key, JNDIUtils.getBytesFromObject(value));
            ref.add(addr);
        }
    }

    public static String extractStringFrom(Reference ref, String key) {
        StringRefAddr addr = (StringRefAddr)ref.get(key);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    public static <T> T extractObjectFrom(Reference ref, String key, Class<T> type) {
        BinaryRefAddr addr = (BinaryRefAddr)ref.get(key);
        if (addr == null) {
            return null;
        }
        byte[] serialized = (byte[])addr.getContent();
        Object result = JNDIUtils.getObjectFromBytes(serialized);
        return (T)type.cast(result);
    }
}

