/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    public static final String LOOP_BACK_ADDR = "127.0.0.1";

    public static String getLocalAddress() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        if (localhost.getHostAddress().equals(LOOP_BACK_ADDR)) {
            try {
                NetworkInterface inter = null;
                InetAddress addr = null;
                Enumeration<NetworkInterface> networkEnum = NetworkInterface.getNetworkInterfaces();
                while (networkEnum.hasMoreElements()) {
                    inter = (NetworkInterface)networkEnum.nextElement();
                    Enumeration<InetAddress> enumAddr = inter.getInetAddresses();
                    while (enumAddr.hasMoreElements()) {
                        addr = (InetAddress)enumAddr.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        return addr.getHostAddress();
                    }
                }
                return localhost.getHostAddress();
            }
            catch (SocketException e) {
                return localhost.getHostAddress();
            }
        }
        return localhost.getHostAddress();
    }
}

