/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tools.configurator.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FileReplacerHelper {
    private static Logger logger = Logger.getLogger(FileReplacerHelper.class);
    private List<Task> tasks = new ArrayList();

    protected void addReplacement(String file, String from, String to) {
        this.tasks.add((Object)new Task(file, from, to));
    }

    protected void doReplacements(File parent) {
        Iterator i$ = this.tasks.iterator();
        while (i$.hasNext()) {
            Task task = (Task)i$.next();
            File file = new File(parent, task.file);
            if (file.isFile()) {
                try {
                    String line;
                    StringBuffer sb = new StringBuffer();
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    while ((line = br.readLine()) != null) {
                        sb.append(line.replace((CharSequence)task.from, (CharSequence)task.to));
                        sb.append(System.getProperty("line.separator"));
                    }
                    br.close();
                    FileWriter fw = new FileWriter(file);
                    fw.write(sb.toString());
                    fw.close();
                }
                catch (Exception e) {
                    logger.error("Failed writing '" + file + ":' " + e);
                }
                continue;
            }
            logger.error("Skipped file '" + file + "'");
        }
    }

    private class Task {
        String file;
        String from;
        String to;

        public Task(String file, String from, String to) {
            this.file = file;
            this.from = from;
            this.to = to;
        }
    }
}

