/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.enc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.asm.Type;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.CommonFieldMetadata;
import org.ow2.util.ee.metadata.common.impl.CommonMethodMetadata;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBinding;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingException;
import org.ow2.util.ee.metadata.common.impl.enc.ENCBindingHolder;
import org.ow2.util.ee.metadata.common.impl.enc.InjectionTargetEncImpl;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsENCBindingBuilder {
    private ENCBindingHolder bindingHolder = new ENCBindingHolder();
    private static final int GETTER_LENGTH = 3;

    protected abstract Collection<? extends ICommonClassMetadata<?, ?, ?>> getClassMetadataCollection();

    protected AbsENCBindingBuilder() {
    }

    protected void analyze() throws ENCBindingException {
        Iterator i$ = this.getClassMetadataCollection().iterator();
        while (i$.hasNext()) {
            ICommonClassMetadata classMetadata = (ICommonClassMetadata)i$.next();
            this.analyzeClassMetadata(classMetadata);
        }
    }

    protected void analyzeClassMetadata(ICommonClassMetadata<?, ?, ?> classMetadata) throws ENCBindingException {
        Iterator i$;
        List<IJaxwsWebServiceRef> refs;
        List<IJEjbEJB> jEjbEJBs;
        List<IJAnnotationResource> jAnnotationResources;
        List<IJavaxPersistenceUnit> javaxPersistenceUnits;
        List<IJavaxPersistenceContext> javaxPersistenceContexts = classMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistenceContexts != null) {
            Iterator i$2 = javaxPersistenceContexts.iterator();
            while (i$2.hasNext()) {
                IJavaxPersistenceContext javaxPersistenceContext = (IJavaxPersistenceContext)i$2.next();
                this.addPersistenceContext(javaxPersistenceContext, null);
            }
        }
        if ((javaxPersistenceUnits = classMetadata.getJavaxPersistencePersistenceUnits()) != null) {
            Iterator i$3 = javaxPersistenceUnits.iterator();
            while (i$3.hasNext()) {
                IJavaxPersistenceUnit javaxPersistenceUnit = (IJavaxPersistenceUnit)i$3.next();
                this.addPersistenceUnit(javaxPersistenceUnit, null);
            }
        }
        if ((jAnnotationResources = classMetadata.getJAnnotationResources()) != null) {
            Iterator i$4 = jAnnotationResources.iterator();
            while (i$4.hasNext()) {
                IJAnnotationResource jAnnotationResource = (IJAnnotationResource)i$4.next();
                this.addResource(jAnnotationResource, null);
            }
        }
        if ((jEjbEJBs = classMetadata.getJEjbEJBs()) != null) {
            Iterator i$5 = jEjbEJBs.iterator();
            while (i$5.hasNext()) {
                IJEjbEJB jEjbEJB = (IJEjbEJB)i$5.next();
                this.addEJB(jEjbEJB, null);
            }
        }
        if ((refs = classMetadata.getJaxwsWebServiceRefs()) != null) {
            i$ = refs.iterator();
            while (i$.hasNext()) {
                IJaxwsWebServiceRef ref = (IJaxwsWebServiceRef)i$.next();
                if (this.isNullOrEmpty(ref.getName())) {
                    throw new ENCBindingException("@WebServiceRef.name (or service-ref/service-ref-name) required in the annotation/XML defined for the class '" + classMetadata.getJClass() + "'.");
                }
                if (this.isNullOrEmpty(ref.getType())) {
                    throw new ENCBindingException("@WebServiceRef.type (or service-ref/service-ref-type) required in the annotation/XML defined for the class '" + classMetadata.getJClass() + "'.");
                }
                if (this.isNullOrEmpty(ref.getValue())) {
                    ref.setValue(ref.getType());
                }
                this.addWebServiceRef(ref, null);
            }
        }
        this.analyzeCommonMetadata(classMetadata);
        i$ = classMetadata.getStandardFieldMetadataCollection().iterator();
        while (i$.hasNext()) {
            ICommonFieldMetadata fieldAnnotationMetadata = (ICommonFieldMetadata)i$.next();
            this.analyzeFieldMetadata(fieldAnnotationMetadata);
        }
        i$ = classMetadata.getStandardMethodMetadataCollection().iterator();
        while (i$.hasNext()) {
            ICommonMethodMetadata methodAnnotationMetadata = (ICommonMethodMetadata)i$.next();
            this.analyzeMethodMetadata(methodAnnotationMetadata);
        }
    }

    protected void analyzeFieldMetadata(ICommonFieldMetadata<?, ?, ?> fieldMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(fieldMetadata);
    }

    protected void analyzeMethodMetadata(ICommonMethodMetadata<?, ?, ?> methodMetadata) throws ENCBindingException {
        this.analyzeCommonMetadata(methodMetadata);
    }

    protected void analyzeCommonMetadata(ISharedMetadata commonMetadata) throws ENCBindingException {
        IJaxwsWebServiceRef ref;
        IJEjbEJB jEjbEJB;
        IJAnnotationResource jAnnotationResource;
        IJavaxPersistenceUnit javaxPersistenceUnit;
        IJavaxPersistenceContext javaxPersistenceContext = commonMetadata.getJavaxPersistenceContext();
        if (javaxPersistenceContext != null) {
            if (this.isNullOrEmpty(javaxPersistenceContext.getName())) {
                javaxPersistenceContext.setName(this.getName(commonMetadata, javaxPersistenceContext));
            }
            this.addPersistenceContext(javaxPersistenceContext, commonMetadata);
        }
        if ((javaxPersistenceUnit = commonMetadata.getJavaxPersistenceUnit()) != null) {
            if (this.isNullOrEmpty(javaxPersistenceUnit.getName())) {
                javaxPersistenceUnit.setName(this.getName(commonMetadata, javaxPersistenceUnit));
            }
            this.addPersistenceUnit(javaxPersistenceUnit, commonMetadata);
        }
        if ((jAnnotationResource = commonMetadata.getJAnnotationResource()) != null) {
            if (this.isNullOrEmpty(jAnnotationResource.getName())) {
                jAnnotationResource.setName(this.getName(commonMetadata, jAnnotationResource));
            }
            jAnnotationResource.setType(this.getType(commonMetadata, jAnnotationResource.getType()));
            this.addResource(jAnnotationResource, commonMetadata);
        }
        if ((jEjbEJB = commonMetadata.getJEjbEJB()) != null) {
            if (this.isNullOrEmpty(jEjbEJB.getName())) {
                jEjbEJB.setName(this.getName(commonMetadata, jEjbEJB));
            }
            jEjbEJB.setBeanInterface(this.getType(commonMetadata, jEjbEJB.getBeanInterface()));
            this.addEJB(jEjbEJB, commonMetadata);
        }
        if ((ref = commonMetadata.getJaxwsWebServiceRef()) != null) {
            if (this.isNullOrEmpty(ref.getName())) {
                ref.setName(this.getName(commonMetadata, ref));
            }
            if (this.isNullOrEmpty(ref.getValue()) || "java.lang.Object".equals(ref.getValue())) {
                ref.setValue(this.getType(commonMetadata, null));
            }
            ref.setType(this.getType(commonMetadata, ref.getType()));
            this.addWebServiceRef(ref, commonMetadata);
        }
    }

    private boolean isNullOrEmpty(String name) {
        return name == null || "".equals(name);
    }

    private String getName(ISharedMetadata commonMetadata, Object o) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            return ((ICommonClassMetadata)fieldAnnotationMetadata.getClassMetadata()).getJClass().getName().replace((CharSequence)"/", (CharSequence)".") + "/" + fieldAnnotationMetadata.getJField().getName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            StringBuilder propertyBuilder = new StringBuilder(methodAnnotationMetadata.getJMethod().getName());
            propertyBuilder.delete(0, 3);
            propertyBuilder.setCharAt(0, Character.toLowerCase(propertyBuilder.charAt(0)));
            propertyBuilder.insert(0, ((ICommonClassMetadata)methodAnnotationMetadata.getClassMetadata()).getJClass().getName().replace((CharSequence)"/", (CharSequence)".") + "/");
            return propertyBuilder.toString();
        }
        throw new ENCBindingException("There is no defined name in the object '" + o + "' that is defined on the class '" + commonMetadata + "'.");
    }

    private String getType(ISharedMetadata commonMetadata, String currentType) throws ENCBindingException {
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            Type typeInterface = Type.getType(fieldAnnotationMetadata.getJField().getDescriptor());
            return typeInterface.getClassName();
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            JMethod jMethod = methodAnnotationMetadata.getJMethod();
            Object[] args = Type.getArgumentTypes(jMethod.getDescriptor());
            if (args.length != 1) {
                throw new ENCBindingException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
            }
            Type typeInterface = args[0];
            return typeInterface.getClassName();
        }
        return currentType;
    }

    protected void addPersistenceContext(IJavaxPersistenceContext javaxPersistenceContext, ISharedMetadata commonMetadata) {
        this.bindingHolder.addPersistenceContextBinding(new ENCBinding<IJavaxPersistenceContext>(javaxPersistenceContext.getName(), javaxPersistenceContext));
        this.addFieldOrMethodENC(javaxPersistenceContext.getName(), commonMetadata);
    }

    protected void addPersistenceUnit(IJavaxPersistenceUnit javaxPersistenceUnit, ISharedMetadata commonMetadata) {
        this.bindingHolder.addPersistenceUnitBinding(new ENCBinding<IJavaxPersistenceUnit>(javaxPersistenceUnit.getName(), javaxPersistenceUnit));
        this.addFieldOrMethodENC(javaxPersistenceUnit.getName(), commonMetadata);
    }

    protected void addResource(IJAnnotationResource jAnnotationResource, ISharedMetadata commonMetadata) {
        this.bindingHolder.addResourceBinding(new ENCBinding<IJAnnotationResource>(jAnnotationResource.getName(), jAnnotationResource));
        this.addFieldOrMethodENC(jAnnotationResource.getName(), commonMetadata);
    }

    protected void addEJB(IJEjbEJB jEjbEJB, ISharedMetadata commonMetadata) {
        this.bindingHolder.addEJBBinding(new ENCBinding<IJEjbEJB>(jEjbEJB.getName(), jEjbEJB));
        this.addFieldOrMethodENC(jEjbEJB.getName(), commonMetadata);
    }

    protected void addWebServiceRef(IJaxwsWebServiceRef ref, ISharedMetadata commonMetadata) {
        this.bindingHolder.addWebServicesBinding(new ENCBinding<IJaxwsWebServiceRef>(ref.getName(), ref));
        this.addFieldOrMethodENC(ref.getName(), commonMetadata);
    }

    protected void addFieldOrMethodENC(String encName, ISharedMetadata commonMetadata) {
        if (commonMetadata == null) {
            return;
        }
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            String fieldName = fieldAnnotationMetadata.getJField().getName();
            this.bindingHolder.addFieldInjectionTarget(((ICommonClassMetadata)fieldAnnotationMetadata.getClassMetadata()).getJClass().getName().replace('/', '.'), new InjectionTargetEncImpl(fieldName, encName));
        } else if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            String methodName = methodAnnotationMetadata.getJMethod().getName();
            this.bindingHolder.addMethodInjectionTarget(((ICommonClassMetadata)methodAnnotationMetadata.getClassMetadata()).getJClass().getName().replace('/', '.'), new InjectionTargetEncImpl(methodName, encName));
        }
    }

    protected ENCBindingHolder getHolder() {
        return this.bindingHolder;
    }
}

