/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.parsing;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceGroup;
import org.ow2.util.ee.metadata.common.api.xml.struct.IServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AbsEJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBLocalRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EJBRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.xml.struct.Handler;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChain;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.struct.InjectionTarget;
import org.ow2.util.ee.metadata.common.impl.xml.struct.LifeCycleCallback;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MessageDestinationRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceContextRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PersistenceUnitRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.PortComponentRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceEnvRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ResourceRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.SecurityRoleRef;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CommonDeploymentDescLoader
extends AbsDeploymentDescLoader {
    private static final Log logger = LogFactory.getLog(CommonDeploymentDescLoader.class);

    protected CommonDeploymentDescLoader(URL url) {
        super(url);
    }

    protected void analyzeEnvironment(Element envElement, IEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "post-construct");
        this.analyzeLifeCycle(envElement, env, "pre-destroy");
        this.analyzeEnvEnvtry(envElement, env);
        this.analyzeEJBRef(envElement, env);
        this.analyzeEJBLocalRef(envElement, env);
        this.analyzeResourceRef(envElement, env);
        this.analyzeResourceEnvRef(envElement, env);
        this.analyzeMessageDestinationRef(envElement, env);
        this.analyzePersistenceContextRef(envElement, env);
        this.analyzePersistenceUnitRef(envElement, env);
        this.analyzeServiceRef(envElement, env);
        this.analyzeSecurityRoleRef(envElement, env);
    }

    private void analyzeCommonEJBRef(Element refElement, AbsEJBRef ref) {
        String ejbRefName = XMLUtils.getStringValueElement(this.getXMLNS(), refElement, "ejb-ref-name");
        ref.setEjbRefName(ejbRefName);
        String ejbRefType = XMLUtils.getStringValueElement(this.getXMLNS(), refElement, "ejb-ref-type");
        ref.setEjbRefType(ejbRefType);
        String mappedName = XMLUtils.getStringValueElement(this.getXMLNS(), refElement, "mapped-name");
        ref.setMappedName(mappedName);
        String ejbLink = XMLUtils.getStringValueElement(this.getXMLNS(), refElement, "ejb-link");
        ref.setEjbLink(ejbLink);
        this.analyzeInjectionTarget(refElement, ref);
    }

    private void analyzeInjectionTarget(Element refElement, IResourceGroup resourceGroup) {
        NodeList injectionTargetList = refElement.getElementsByTagNameNS(this.getXMLNS(), "injection-target");
        for (int j = 0; j < injectionTargetList.getLength(); ++j) {
            Element injectionTargetElement = (Element)injectionTargetList.item(j);
            InjectionTarget injectionTarget = new InjectionTarget();
            String className = XMLUtils.getStringValueElement(this.getXMLNS(), injectionTargetElement, "injection-target-class");
            injectionTarget.setClassname(className);
            String targetName = XMLUtils.getStringValueElement(this.getXMLNS(), injectionTargetElement, "injection-target-name");
            injectionTarget.setTargetName(targetName);
            resourceGroup.addInjectionTarget(injectionTarget);
        }
    }

    private void analyzeEJBRef(Element envElement, IEnvironment env) {
        NodeList ejbRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-ref");
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbRef);
            String remote = XMLUtils.getStringValueElement(this.getXMLNS(), ejbRefElement, "remote");
            ejbRef.setRemote(remote);
            String home = XMLUtils.getStringValueElement(this.getXMLNS(), ejbRefElement, "home");
            ejbRef.setHome(home);
            env.addEJBRef(ejbRef);
        }
    }

    private void analyzeResourceRef(Element envElement, IEnvironment env) {
        NodeList resourceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-ref");
        for (int i = 0; i < resourceRefList.getLength(); ++i) {
            Element resourceRefElement = (Element)resourceRefList.item(i);
            ResourceRef resourceRef = new ResourceRef();
            String resRefName = XMLUtils.getStringValueElement(this.getXMLNS(), resourceRefElement, "res-ref-name");
            resourceRef.setResRefName(resRefName);
            String resRefType = XMLUtils.getStringValueElement(this.getXMLNS(), resourceRefElement, "res-type");
            resourceRef.setResRefType(resRefType);
            String mappedName = XMLUtils.getStringValueElement(this.getXMLNS(), resourceRefElement, "mapped-name");
            resourceRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceRefElement, resourceRef);
            env.addResourceRef(resourceRef);
        }
    }

    private void analyzeSecurityRoleRef(Element envElement, IEnvironment env) {
        NodeList securityRoleRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "security-role-ref");
        for (int i = 0; i < securityRoleRefList.getLength(); ++i) {
            Element securityRoleRefElement = (Element)securityRoleRefList.item(i);
            SecurityRoleRef securityRoleRef = new SecurityRoleRef();
            String roleName = XMLUtils.getStringValueElement(this.getXMLNS(), securityRoleRefElement, "role-name");
            securityRoleRef.setRoleName(roleName);
            String roleLink = XMLUtils.getStringValueElement(this.getXMLNS(), securityRoleRefElement, "role-link");
            securityRoleRef.setRoleLink(roleLink);
            env.addSecurityRoleRef(securityRoleRef);
        }
    }

    private void analyzeMessageDestinationRef(Element envElement, IEnvironment env) {
        NodeList messageDestinationRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination-ref");
        for (int i = 0; i < messageDestinationRefList.getLength(); ++i) {
            Element messageDestinationRefElement = (Element)messageDestinationRefList.item(i);
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            String name = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationRefElement, "message-destination-ref-name");
            messageDestinationRef.setName(name);
            String type = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationRefElement, "message-destination-type");
            messageDestinationRef.setType(type);
            String usage = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationRefElement, "message-destination-usage");
            messageDestinationRef.setUsage(usage);
            String link = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationRefElement, "message-destination-link");
            messageDestinationRef.setLink(link);
            String mappedName = XMLUtils.getStringValueElement(this.getXMLNS(), messageDestinationRefElement, "mapped-name");
            messageDestinationRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(messageDestinationRefElement, messageDestinationRef);
            env.addMessageDestinationRef(messageDestinationRef);
        }
    }

    private void analyzePersistenceUnitRef(Element envElement, IEnvironment env) {
        logger.debug("Analyze environment, looking for persistence-unit-ref", new Object[0]);
        NodeList persistenceUnitRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-unit-ref");
        for (int i = 0; i < persistenceUnitRefList.getLength(); ++i) {
            Element persistenceUnitRefElement = (Element)persistenceUnitRefList.item(i);
            PersistenceUnitRef persistenceUnitRef = new PersistenceUnitRef();
            String unitRefName = XMLUtils.getStringValueElement(this.getXMLNS(), persistenceUnitRefElement, "persistence-unit-ref-name");
            if (unitRefName != null) {
                persistenceUnitRef.setPersistenceUnitRefName(unitRefName);
            }
            logger.debug("Analyze environment, found persistence-unit-ref-name " + unitRefName, new Object[0]);
            String unitName = XMLUtils.getStringValueElement(this.getXMLNS(), persistenceUnitRefElement, "persistence-unit-name");
            if (unitName != null) {
                persistenceUnitRef.setPersistenceUnitName(unitName);
            }
            env.addPersistenceUnitRef(persistenceUnitRef);
        }
    }

    private void analyzePersistenceContextRef(Element envElement, IEnvironment env) {
        logger.debug("Analyze environment, looking for persistence-context-ref", new Object[0]);
        NodeList persistenceContextRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "persistence-context-ref");
        for (int i = 0; i < persistenceContextRefList.getLength(); ++i) {
            String contextType;
            Element persistenceContextRefElement = (Element)persistenceContextRefList.item(i);
            PersistenceContextRef persistenceContextRef = new PersistenceContextRef();
            String contextRefName = XMLUtils.getStringValueElement(this.getXMLNS(), persistenceContextRefElement, "persistence-context-ref-name");
            if (contextRefName != null) {
                persistenceContextRef.setPersistenceContextRefName(contextRefName);
            }
            logger.debug("Analyze environment, found persistence-context-ref-name " + contextRefName, new Object[0]);
            String unitName = XMLUtils.getStringValueElement(this.getXMLNS(), persistenceContextRefElement, "persistence-unit-name");
            if (unitName != null) {
                persistenceContextRef.setPersistenceUnitName(unitName);
            }
            if ((contextType = XMLUtils.getStringValueElement(this.getXMLNS(), persistenceContextRefElement, "persistence-context-type")) != null) {
                persistenceContextRef.setPersistenceContextType(contextType);
            }
            env.addPersistenceContextRef(persistenceContextRef);
        }
    }

    private void analyzeServiceRef(Element envElement, IEnvironment env) {
        NodeList serviceRefList = envElement.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "service-ref");
        for (int i = 0; i < serviceRefList.getLength(); ++i) {
            NodeList serviceQNameList;
            Element serviceRefElement = (Element)serviceRefList.item(i);
            ServiceRef serviceRef = new ServiceRef();
            String name = XMLUtils.getStringValueElement(this.getXMLNS(), serviceRefElement, "service-ref-name");
            serviceRef.setName(name);
            String type = XMLUtils.getStringValueElement(this.getXMLNS(), serviceRefElement, "service-interface");
            serviceRef.setServiceInterface(type);
            String usage = XMLUtils.getStringValueElement(this.getXMLNS(), serviceRefElement, "service-ref-type");
            serviceRef.setServiceRefType(usage);
            String link = XMLUtils.getStringValueElement(this.getXMLNS(), serviceRefElement, "wsdl-file");
            if (link != null) {
                URI location = null;
                try {
                    location = new URI(link);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Element 'wsdl-file' is not a valid URI", (Throwable)e);
                }
                serviceRef.setWsdlFile(location);
            }
            if ((serviceQNameList = envElement.getElementsByTagNameNS(this.getXMLNS(), "service-qname")).getLength() == 1) {
                QName serviceQName = XMLUtils.getValueAsQName((Element)serviceQNameList.item(0));
                serviceRef.setServiceQName(serviceQName);
            }
            this.analyzePortComponentRef(serviceRefElement, serviceRef);
            this.analyzeHandlerChains(serviceRefElement, serviceRef);
            this.analyzeInjectionTarget(serviceRefElement, serviceRef);
            env.addServiceRef(serviceRef);
        }
    }

    private void analyzeHandlerChains(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList handlerChainsList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chains");
        if (handlerChainsList.getLength() == 1) {
            Element handlerChainsElement = (Element)handlerChainsList.item(0);
            HandlerChains handlerChains = new HandlerChains();
            serviceRef.setHandlerChains(handlerChains);
            this.analyzeHandlerChain(handlerChainsElement, handlerChains);
        }
    }

    protected void analyzeHandlerChain(Element handlerChainsElement, HandlerChains handlerChains) {
        NodeList handlerChainList = handlerChainsElement.getElementsByTagNameNS(this.getXMLNS(), "handler-chain");
        for (int i = 0; i < handlerChainList.getLength(); ++i) {
            Element handlerChainElement = (Element)handlerChainList.item(i);
            HandlerChain handlerChain = new HandlerChain();
            handlerChains.addHandlerChain(handlerChain);
            QName servicePattern = XMLUtils.getChildValueAsQName(handlerChainElement, "service-name-pattern");
            handlerChain.setServiceNamePattern(servicePattern);
            QName portPattern = XMLUtils.getChildValueAsQName(handlerChainElement, "port-name-pattern");
            handlerChain.setPortNamePattern(portPattern);
            this.analyzeProtocolBindings(handlerChainElement, handlerChain);
            this.analyzeHandlers(handlerChainElement, handlerChain);
        }
    }

    private void analyzeHandlers(Element handlerChainElement, HandlerChain handlerChain) {
        NodeList handlerList = handlerChainElement.getElementsByTagNameNS(this.getXMLNS(), "handler");
        for (int i = 0; i < handlerList.getLength(); ++i) {
            Element handlerElement = (Element)handlerList.item(i);
            String name = XMLUtils.getStringValueElement(this.getXMLNS(), handlerElement, "handler-name");
            String classname = XMLUtils.getStringValueElement(this.getXMLNS(), handlerElement, "handler-class");
            Handler handler = new Handler(name, classname);
            handlerChain.addHandler(handler);
            QName soapHeader = XMLUtils.getChildValueAsQName(handlerElement, "soap-header");
            handler.setSoapHeader(soapHeader);
            String soapRole = XMLUtils.getStringValueElement(this.getXMLNS(), handlerElement, "soap-role");
            handler.setSoapRole(soapRole);
            this.analyzeInitParam(handlerElement, handler);
        }
    }

    private void analyzeInitParam(Element handlerElement, Handler handler) {
        NodeList initParamList = handlerElement.getElementsByTagNameNS(this.getXMLNS(), "init-param");
        for (int i = 0; i < initParamList.getLength(); ++i) {
            Element initParamElement = (Element)initParamList.item(i);
            String name = XMLUtils.getStringValueElement(this.getXMLNS(), handlerElement, "param-name");
            String value = XMLUtils.getStringValueElement(this.getXMLNS(), handlerElement, "param-value");
            handler.addInitParam(name, value);
        }
    }

    private void analyzeProtocolBindings(Element handlerChainElement, HandlerChain handlerChain) {
        String bindingsValue = XMLUtils.getStringValueElement(this.getXMLNS(), handlerChainElement, "protocol-bindings");
        if (bindingsValue != null) {
            String[] bindings;
            for (String binding : bindings = bindingsValue.split(" ")) {
                handlerChain.addProtocolBinding(binding);
            }
        }
    }

    private void analyzePortComponentRef(Element serviceRefElement, IServiceRef serviceRef) {
        NodeList portComponentRefList = serviceRefElement.getElementsByTagNameNS(this.getXMLNS(), "port-component-ref");
        for (int i = 0; i < portComponentRefList.getLength(); ++i) {
            Element portComponentRefElement = (Element)portComponentRefList.item(i);
            PortComponentRef portComponentRef = new PortComponentRef();
            String sei = XMLUtils.getStringValueElement(this.getXMLNS(), portComponentRefElement, "service-endpoint-interface");
            portComponentRef.setServiceEndpointInterface(sei);
            String enableMTOM = XMLUtils.getStringValueElement(this.getXMLNS(), portComponentRefElement, "enable-mtom");
            if (enableMTOM != null) {
                portComponentRef.setEnableMTOM(Boolean.parseBoolean((String)enableMTOM));
            }
            String link = XMLUtils.getStringValueElement(this.getXMLNS(), portComponentRefElement, "port-component-link");
            portComponentRef.setPortComponentLink(link);
            serviceRef.addPortComponentRef(portComponentRef);
        }
    }

    private void analyzeResourceEnvRef(Element envElement, IEnvironment env) {
        NodeList resourceEnvRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-env-ref");
        for (int i = 0; i < resourceEnvRefList.getLength(); ++i) {
            Element resourceEnvRefElement = (Element)resourceEnvRefList.item(i);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef();
            String resourceEnvRefName = XMLUtils.getStringValueElement(this.getXMLNS(), resourceEnvRefElement, "resource-env-ref-name");
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            String resourceEnvRefType = XMLUtils.getStringValueElement(this.getXMLNS(), resourceEnvRefElement, "resource-env-ref-type");
            resourceEnvRef.setResourceEnvRefType(resourceEnvRefType);
            String mappedName = XMLUtils.getStringValueElement(this.getXMLNS(), resourceEnvRefElement, "mapped-name");
            resourceEnvRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceEnvRefElement, resourceEnvRef);
            env.addResourceEnvRef(resourceEnvRef);
        }
    }

    private void analyzeEJBLocalRef(Element envElement, IEnvironment env) {
        NodeList ejbLocalRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-local-ref");
        for (int i = 0; i < ejbLocalRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbLocalRefList.item(i);
            EJBLocalRef ejbLocalRef = new EJBLocalRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbLocalRef);
            String local = XMLUtils.getStringValueElement(this.getXMLNS(), ejbRefElement, "local");
            ejbLocalRef.setLocal(local);
            String localHome = XMLUtils.getStringValueElement(this.getXMLNS(), ejbRefElement, "local-home");
            ejbLocalRef.setLocalHome(localHome);
            env.addEJBLocalRef(ejbLocalRef);
        }
    }

    private void analyzeEnvEnvtry(Element envElement, IEnvironment bean) {
        NodeList envEntryList = envElement.getElementsByTagNameNS(this.getXMLNS(), "env-entry");
        for (int i = 0; i < envEntryList.getLength(); ++i) {
            Element envEntryElement = (Element)envEntryList.item(i);
            EnvEntry envEntry = new EnvEntry();
            bean.addEnvEntry(envEntry);
            String envEntryName = XMLUtils.getStringValueElement(this.getXMLNS(), envEntryElement, "env-entry-name");
            envEntry.setEnvEntryName(envEntryName);
            String envEntryType = XMLUtils.getStringValueElement(this.getXMLNS(), envEntryElement, "env-entry-type");
            envEntry.setEnvEntryType(envEntryType);
            String envEntryValue = XMLUtils.getStringValueElement(this.getXMLNS(), envEntryElement, "env-entry-value", false);
            envEntry.setEnvEntryValue(envEntryValue);
            this.analyzeInjectionTarget(envEntryElement, envEntry);
        }
    }

    protected void analyzeLifeCycle(Element envElement, IEnvironment env, String lifecycleName) {
        NodeList lifecycleList = envElement.getElementsByTagNameNS(this.getXMLNS(), lifecycleName);
        for (int i = 0; i < lifecycleList.getLength(); ++i) {
            Element lifeCycleElement = (Element)lifecycleList.item(i);
            LifeCycleCallback lifecycleCallback = new LifeCycleCallback();
            if ("post-construct".equals(lifecycleName)) {
                env.addPostConstructCallback(lifecycleCallback);
            } else if ("pre-destroy".equals(lifecycleName)) {
                env.addPreDestroyCallback(lifecycleCallback);
            } else if ("pre-passivate".equals(lifecycleName)) {
                env.addPrePassivateCallback(lifecycleCallback);
            } else if ("post-activate".equals(lifecycleName)) {
                env.addPostActivateCallback(lifecycleCallback);
            } else {
                throw new IllegalArgumentException("Unknown lifecycle named '" + lifecycleName + "'.");
            }
            String className = XMLUtils.getStringValueElement(this.getXMLNS(), lifeCycleElement, "lifecycle-callback-class");
            lifecycleCallback.setLifecycleCallbackClass(className);
            String method = XMLUtils.getStringValueElement(this.getXMLNS(), lifeCycleElement, "lifecycle-callback-method");
            lifecycleCallback.setMethodName(method);
        }
    }
}

