/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.xml.parsing;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.IEntityResolver;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChains;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.SchemaEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class HandlerChainsLoader
extends CommonDeploymentDescLoader {
    private static final Log logger = LogFactory.getLog(HandlerChainsLoader.class);
    private static final String[] HANDLER_CHAINS_SCHEMAS = new String[]{"org/ow2/util/ee/metadata/common/impl/xml/javaee_5.xsd", "org/ow2/util/ee/metadata/common/impl/xml/javaee_web_services_client_1_2.xsd", "org/ow2/util/ee/metadata/common/impl/xml/javaee_web_services_metadata_handler_2_0.xsd", "org/ow2/util/ee/metadata/common/impl/xml/xml.xsd"};
    private HandlerChains handlerChains;
    private Element handlerChainsElement;

    private HandlerChainsLoader(URL url) {
        super(url);
        this.handlerChains = new HandlerChains();
    }

    private HandlerChainsLoader(Element element) {
        super(null);
        this.handlerChainsElement = element;
        this.handlerChains = new HandlerChains();
    }

    public static IHandlerChains loadHandlerChains(URL url, boolean validation) throws ParsingException {
        logger.debug("Analyzing url {0}", url);
        HandlerChainsLoader handlerChainsLoader = new HandlerChainsLoader(url);
        handlerChainsLoader.setValidating(validation);
        handlerChainsLoader.parse();
        return handlerChainsLoader.getHandlerChains();
    }

    public static IHandlerChains loadHandlerChains(Element handlerChainsElement) throws ParsingException {
        logger.debug("Analyzing element {0}", handlerChainsElement);
        HandlerChainsLoader handlerChainsLoader = new HandlerChainsLoader(handlerChainsElement);
        handlerChainsLoader.parse();
        return handlerChainsLoader.getHandlerChains();
    }

    private void parse() throws ParsingException {
        if (this.handlerChainsElement == null) {
            Document document = this.loadDocument();
            this.handlerChainsElement = document.getDocumentElement();
        }
        if (this.handlerChainsElement.getNamespaceURI() != null) {
            this.defineXMLNS(this.handlerChainsElement);
        }
        this.analyzeHandlerChain(this.handlerChainsElement, this.handlerChains);
    }

    private Document loadDocument() throws ParsingException {
        Document document;
        Reader reader = null;
        try {
            String handlerChainsSchemaLocation = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/javaee_web_services_metadata_handler_2_0.xsd";
            List schemaLocations = Collections.singletonList(handlerChainsSchemaLocation);
            reader = new InputStreamReader(this.getURL().openStream());
            InputSource inputSource = new InputSource(reader);
            document = DocumentParser.getDocument(inputSource, HandlerChainsLoader.isValidating(), new HandlerChainsEntityResolver(), schemaLocations);
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url " + this.getURL(), e);
        }
        catch (IOException e) {
            throw new ParsingException("Cannot open the url " + this.getURL(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return document;
    }

    private IHandlerChains getHandlerChains() {
        return this.handlerChains;
    }

    private class HandlerChainsEntityResolver
    extends SchemaEntityResolver
    implements IEntityResolver {
        public HandlerChainsEntityResolver() {
            super(HANDLER_CHAINS_SCHEMAS);
        }
    }
}

