/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.impl.deployable.metadata.DeployableMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.marshalling.Serialization;
import org.ow2.util.marshalling.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarDeployableMetadata<E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>>
extends DeployableMetadata<E>
implements IEjbJarDeployableMetadata<E, D, C, M, F> {
    private static final long serialVersionUID = 2467337105092579966L;
    private static Log logger = LogFactory.getLog(EjbJarDeployableMetadata.class);
    private Map<String, C> classesAnnotationMetadata = new HashMap();
    private Map<String, Map<String, C>> beanClassesAnnotationMetadata = new HashMap();
    private IEJB3 ejb3 = null;
    private IWebservices webservices = null;
    private Map<String, ApplicationException> applicationExceptions = null;
    private IJInterceptors defaultInterceptorsClasses = null;

    public EjbJarDeployableMetadata() {
    }

    public EjbJarDeployableMetadata(E deployable) {
        this();
        this.setDeployable(deployable);
    }

    @Override
    public void addScannedClassMetadata(C classAnnotationMetadata) {
        String key = classAnnotationMetadata.getClassName();
        if (this.classesAnnotationMetadata.containsKey((Object)key)) {
            String msg = logger.getI18n().getMessage("EjbJarAnnotationMetadata.addClassAnnotationMetadata.alreadyPresent", key);
            logger.debug(msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.classesAnnotationMetadata.put((Object)key, classAnnotationMetadata);
    }

    @Override
    public C getEjbJarClassMetadataForEjbName(String ejbName) {
        Map beanMapClassMetadata = (Map)this.beanClassesAnnotationMetadata.get((Object)ejbName);
        if (beanMapClassMetadata == null) {
            return null;
        }
        Iterator i$ = beanMapClassMetadata.values().iterator();
        while (i$.hasNext()) {
            IEjbJarClassMetadata metadata = (IEjbJarClassMetadata)i$.next();
            IJCommonBean bean = metadata.getJCommonBean();
            if (bean == null || !ejbName.equals(bean.getName())) continue;
            return (C)metadata;
        }
        return null;
    }

    @Override
    public C getBeanEjbJarClassMetadataForEjbName(String ejbName, String ejbClass) {
        IEjbJarClassMetadata classMetadata;
        logger.debug("Call with ''{0}'' and ejbClass ''{1}''", ejbName, ejbClass);
        Map beanMapClassMetadata = (Map)this.beanClassesAnnotationMetadata.get((Object)ejbName);
        if (beanMapClassMetadata == null) {
            beanMapClassMetadata = new HashMap();
            this.beanClassesAnnotationMetadata.put((Object)ejbName, (Object)beanMapClassMetadata);
            logger.debug("Creating a Map for EJB ''{0}''", ejbName);
        }
        String ejbClassEncoded = null;
        if (ejbClass == null) {
            Iterator i$ = this.getEjbJarClassMetadataCollection().iterator();
            while (i$.hasNext()) {
                IEjbJarClassMetadata tmpMetaData = (IEjbJarClassMetadata)i$.next();
                IJCommonBean bean = tmpMetaData.getJCommonBean();
                if (bean == null || ejbName == null || !ejbName.equals(bean.getName())) continue;
                ejbClassEncoded = tmpMetaData.getClassName();
                break;
            }
        } else {
            ejbClassEncoded = EjbJarDeployableMetadata.encode(ejbClass);
        }
        if ((classMetadata = (IEjbJarClassMetadata)beanMapClassMetadata.get(ejbClassEncoded)) != null) {
            return (C)classMetadata;
        }
        classMetadata = this.getScannedClassMetadata(ejbClassEncoded);
        if (classMetadata == null) {
            throw new IllegalStateException("No metadata defined for the EJB class '" + ejbClass + "'");
        }
        IEjbJarClassMetadata clonedClassMetadata = null;
        try {
            clonedClassMetadata = Serialization.cloneObject(classMetadata);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Cannot clone classmetada for '" + ejbClass + "'", (Throwable)e);
        }
        clonedClassMetadata.setLinkedBean(ejbName);
        logger.debug("Cloning scanning classmetadata ''{0}''", ejbClassEncoded);
        beanMapClassMetadata.put(ejbClassEncoded, clonedClassMetadata);
        clonedClassMetadata.setEjbJarArchiveMetadata(this);
        return (C)clonedClassMetadata;
    }

    protected static String encode(String className) {
        if (className != null) {
            return className.replace((CharSequence)".", (CharSequence)"/");
        }
        return null;
    }

    @Override
    public C getScannedClassMetadata(String className) {
        return (C)((IEjbJarClassMetadata)this.classesAnnotationMetadata.get((Object)className));
    }

    @Override
    public Collection<C> getEjbJarClassMetadataCollection() {
        return this.classesAnnotationMetadata.values();
    }

    @Override
    public IEJB3 getEjb3() {
        return this.ejb3;
    }

    @Override
    public void setEjb3(IEJB3 ejb3) {
        this.ejb3 = ejb3;
    }

    @Override
    public IWebservices getWebservices12() {
        return this.webservices;
    }

    @Override
    public void setWebservices12(IWebservices webservices12) {
        this.webservices = webservices12;
    }

    @Override
    public Map<String, ApplicationException> getApplicationExceptions() {
        if (this.applicationExceptions != null) {
            return this.applicationExceptions;
        }
        this.applicationExceptions = new HashMap();
        Iterator i$ = this.getEjbJarClassMetadataCollection().iterator();
        while (i$.hasNext()) {
            IEjbJarClassMetadata classMetadata = (IEjbJarClassMetadata)i$.next();
            ApplicationException appException = classMetadata.getApplicationException();
            if (appException == null) continue;
            this.applicationExceptions.put((Object)classMetadata.getClassName().replaceAll("/", "."), (Object)appException);
            logger.debug("Adding application exception ''{}''", classMetadata.getClassName().replaceAll("/", "."));
        }
        this.applicationExceptions.put((Object)"DEFAULT", (Object)new JApplicationException());
        return this.applicationExceptions;
    }

    @Override
    public IJInterceptors getDefaultInterceptorsClasses() {
        return this.defaultInterceptorsClasses;
    }

    @Override
    public void setDefaultInterceptorsClasses(IJInterceptors defaultInterceptorsClasses) {
        this.defaultInterceptorsClasses = defaultInterceptorsClasses;
    }

    @Override
    public List<String> getBeanNames() {
        return Arrays.asList(this.beanClassesAnnotationMetadata.keySet().toArray(new String[0]));
    }

    @Override
    public Collection<C> getClassesForBean(String beanName) {
        Map beanClasses = (Map)this.beanClassesAnnotationMetadata.get((Object)beanName);
        if (beanClasses == null) {
            return Collections.EMPTY_LIST;
        }
        return beanClasses.values();
    }

    public C getClassForBean(String beanName, String className) {
        return (C)((IEjbJarClassMetadata)((Map)this.beanClassesAnnotationMetadata.get((Object)beanName)).get(className));
    }

    public List<String> getClassesnameForBean(String beanName) {
        return Arrays.asList(((Map)this.beanClassesAnnotationMetadata.get((Object)beanName)).keySet().toArray(new String[0]));
    }
}

