/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;

public class WarClassesLocator
implements IClassesLocator {
    private static final String CLASS_PREFIX = "WEB-INF/classes/";
    private static final String LIB_PREFIX = "WEB-INF/lib/";
    private static final String LIB_SUFFIX = ".jar";
    private IArchive archive;
    private List<IClassesLocator> libClassesLocator;

    public WarClassesLocator(IArchive archive) {
        this.archive = archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws ArchiveException {
        if (this.libClassesLocator != null) {
            return;
        }
        WarClassesLocator warClassesLocator = this;
        synchronized (warClassesLocator) {
            ArchiveManager archiveManager = ArchiveManager.getInstance();
            this.libClassesLocator = new ArrayList();
            Iterator<String> iterator = this.archive.getEntries();
            while (iterator.hasNext()) {
                String entry = (String)iterator.next();
                if (!entry.startsWith(LIB_PREFIX) || !entry.endsWith(LIB_SUFFIX)) continue;
                this.libClassesLocator.add((Object)new ArchiveClassesLocator(archiveManager.getArchive(this.archive.getResource(entry))));
            }
        }
    }

    public URL getClassURL(String className) throws ScanException {
        URL url;
        block5: {
            IClassesLocator classesLocator;
            try {
                this.init();
            }
            catch (ArchiveException e) {
                throw new ScanException("A lib of a war cannot be analyzed", e);
            }
            String classLocation = className.replace('.', '/').concat(".class");
            try {
                url = this.archive.getResource(CLASS_PREFIX + classLocation);
            }
            catch (ArchiveException e) {
                throw new ScanException("The war cannot be analyzed", e);
            }
            if (url != null) break block5;
            Iterator i$ = this.libClassesLocator.iterator();
            while (i$.hasNext() && (url = (classesLocator = (IClassesLocator)i$.next()).getClassURL(className)) == null) {
            }
        }
        return url;
    }
}

