/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadataFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IScanner;

public class Activator
implements BundleActivator,
ServiceListener {
    private BundleContext bundleContext = null;
    private ServiceRegistration serviceRegistration = null;
    private Log logger = LogFactory.getLog(Activator.class);

    public void start(BundleContext bc) throws Exception {
        this.bundleContext = bc;
        this.registerService();
        bc.addServiceListener(this, "(objectClass=" + IScanner.class.getName() + ")");
    }

    public void stop(BundleContext bc) {
        this.unregisterService();
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 1) {
            try {
                this.registerService();
            }
            catch (Exception e) {
                this.logger.error("Cannot register the " + IWarDeployableMetadataFactory.class.getName() + " service", new Object[0]);
            }
        } else if (serviceEvent.getType() == 4) {
            this.unregisterService();
        }
    }

    private void registerService() throws Exception {
        ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter("(objectClass=" + IScanner.class.getName() + ")"), null);
        serviceTracker.open();
        IScanner scanner = (IScanner)serviceTracker.getService();
        if (scanner != null) {
            this.serviceRegistration = this.bundleContext.registerService(IWarDeployableMetadataFactory.class.getName(), (Object)new WarDeployableMetadataFactory(scanner), null);
        }
    }

    private void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

