/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.api.IWarFieldMetadata;
import org.ow2.util.ee.metadata.war.api.IWarMethodMetadata;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(WarMetadataMerge.class);
    private WarDeployableMetadata warDeployableMetadata;

    public WarMetadataMerge(WarDeployableMetadata warDeployableMetadata) {
        this.warDeployableMetadata = warDeployableMetadata;
    }

    public void merge(WAR war) {
        this.applyJndiEnvironmentRefsGroup(war, this.warDeployableMetadata);
        Iterator i$ = this.warDeployableMetadata.getWarClassMetadataCollection().iterator();
        while (i$.hasNext()) {
            List<IJAnnotationResource> annotationResourcesDeployable;
            IWarClassMetadata warClassmetadata = (IWarClassMetadata)i$.next();
            List<IJavaxPersistenceUnit> persistenceUnitsDeployable = this.warDeployableMetadata.getJavaxPersistencePersistenceUnits();
            if (persistenceUnitsDeployable != null && persistenceUnitsDeployable.size() > 0) {
                List<IJavaxPersistenceUnit> persistenceUnitsClass = warClassmetadata.getJavaxPersistencePersistenceUnits();
                if (persistenceUnitsClass == null) {
                    warClassmetadata.setJavaxPersistencePersistenceUnits(persistenceUnitsDeployable);
                } else {
                    persistenceUnitsClass.addAll(persistenceUnitsDeployable);
                }
            }
            if ((annotationResourcesDeployable = this.warDeployableMetadata.getJAnnotationResources()) == null || annotationResourcesDeployable.size() <= 0) continue;
            List<IJAnnotationResource> annotationResourcesClass = warClassmetadata.getJAnnotationResources();
            if (annotationResourcesClass == null) {
                warClassmetadata.setJAnnotationResources(annotationResourcesDeployable);
                continue;
            }
            annotationResourcesClass.addAll(annotationResourcesDeployable);
        }
    }

    @Override
    protected List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(IEnvironmentRefAccessor warMetadata, String name) {
        ArrayList elements = new ArrayList();
        Collection<IWarClassMetadata> clientClassesMetadata = this.warDeployableMetadata.getWarClassMetadataCollection();
        if (clientClassesMetadata != null) {
            Iterator i$ = clientClassesMetadata.iterator();
            while (i$.hasNext()) {
                Collection methodMetadatas;
                IWarClassMetadata classMetadata = (IWarClassMetadata)i$.next();
                Collection fieldMetadatas = classMetadata.getStandardFieldMetadataCollection();
                if (fieldMetadatas != null) {
                    Iterator i$2 = fieldMetadatas.iterator();
                    while (i$2.hasNext()) {
                        IWarFieldMetadata fieldMetadata = (IWarFieldMetadata)i$2.next();
                        this.addJaxwsWebServiceRefIfFound(fieldMetadata, name, elements);
                    }
                }
                if ((methodMetadatas = classMetadata.getStandardMethodMetadataCollection()) == null) continue;
                Iterator i$3 = methodMetadatas.iterator();
                while (i$3.hasNext()) {
                    IWarMethodMetadata methodMetadata = (IWarMethodMetadata)i$3.next();
                    this.addJaxwsWebServiceRefIfFound(methodMetadata, name, elements);
                }
            }
        }
        return elements;
    }

    public IWarClassMetadata getClassMetadata(String className) {
        return this.warDeployableMetadata.getWarClassMetadata(className);
    }

    @Override
    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        return null;
    }

    @Override
    protected Collection<? extends ICommonClassMetadata> getAllClassMetadatas() {
        return this.warDeployableMetadata.getWarClassMetadataCollection();
    }

    @Override
    protected Collection<? extends ICommonMethodMetadata> getAllMethodMetadatas() {
        ArrayList methodMetadatas = new ArrayList();
        Collection<IWarClassMetadata> classMetadatas = this.warDeployableMetadata.getWarClassMetadataCollection();
        Iterator i$ = classMetadatas.iterator();
        while (i$.hasNext()) {
            ICommonClassMetadata classMetadata = (ICommonClassMetadata)i$.next();
            methodMetadatas.addAll(classMetadata.getStandardMethodMetadataCollection());
        }
        return methodMetadatas;
    }

    @Override
    protected Collection<? extends ICommonFieldMetadata> getAllFieldMetadatas() {
        ArrayList fieldMetadatas = new ArrayList();
        Collection<IWarClassMetadata> classMetadatas = this.warDeployableMetadata.getWarClassMetadataCollection();
        Iterator i$ = classMetadatas.iterator();
        while (i$.hasNext()) {
            ICommonClassMetadata classMetadata = (ICommonClassMetadata)i$.next();
            fieldMetadatas.addAll(classMetadata.getStandardFieldMetadataCollection());
        }
        return fieldMetadatas;
    }
}

